/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action.mm;

import latte.InternalLogicException;
import latte.Latte;
import latte.util.ModelUtil;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.VisibilityKind;

import com.sun.javadoc.FieldDoc;

/**
 * 
 * ̑i쐬AǉA폜j
 * 
 * @version $Id: AttributeManip.java,v 1.3 2004/02/19 18:23:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class AttributeManip implements IAddManip, IRemoveManip {
    /**
     * V`쐬
     */
    public EObject createDef(Object param){
        Property p = ModelUtil.Uml2Factory.createProperty();
        if (param instanceof FieldDoc) {
            FieldDoc doc = (FieldDoc)param;
            // 
            if (doc.isPublic()) {
                p.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            } else if (doc.isPackagePrivate()) {
                p.setVisibility(VisibilityKind.PACKAGE_LITERAL);
            } else if (doc.isProtected()) {
                p.setVisibility(VisibilityKind.PROTECTED_LITERAL);
            } else if (doc.isPrivate()) {
                p.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            }
            // O
            p.setName(doc.name());
        } else {
            // 
            p.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            // ^
            p.setType(Latte.getLatteData().lookupPrimitiveTypes("int"));
            // O
            p.setName("");
        }
        return p;
    }
    
    /**
     * V`eɒǉ
     */
    public void addDef(EObject parent, EObject newDef){
        
        // ǉ
        if (parent instanceof Class) {
            // NXɒǉ
            Class c = (Class)parent;
            int index = ModelUtil.getInsertIndex(c.getOwnedAttributes().toArray(), newDef, false);
            c.getOwnedAttributes().add(index, newDef);
        } else if (parent instanceof Interface) {
            // C^[tFCXɒǉ
            Interface i = (Interface)parent;
            int index = ModelUtil.getInsertIndex(i.getOwnedAttributes().toArray(), newDef, false);
            i.getOwnedAttributes().add(index, newDef);
        } else {
            throw new InternalLogicException("͒ǉł܂");
        }
    }
    
    /**
     * 폜
     */
    public void removeDef(EObject removeDef) {
        Property removeP = (Property)removeDef;
        Element owner = removeP.getOwner();
        
        switch (ModelUtil.getClassifierID(owner)) {
        case UML2Package.CLASS:
            // NX폜
            Class c = (Class)owner;
            c.getOwnedAttributes().remove(removeDef);
            break;
        
        case UML2Package.INTERFACE:
            // C^[tFCX폜
            Interface i = (Interface)owner;
            i.getOwnedAttributes().remove(removeDef);
            break;
            
        default:
            throw new InternalLogicException("͍폜ł܂");
        }
    }
}
