/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import latte.Latte;
import latte.util.GuiUtil;

/**
 * 
 * RoseRXP捞
 * 
 * @version $Id: ToolRoseImportAction.java,v 1.3 2004/09/08 13:17:11 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class ToolRoseImportAction extends AbstractLatteAction {
	private static String WITHID =" with id ";
	private static String NOTEVIEW =" NoteView @ ";
    private static int RATE = 4;
    private Shell dialog_ = null;
    private Text xmiFileTxt_ = null;
    private Text rxpFileTxt_ = null;
	
    public ToolRoseImportAction(String title, String imageFile) {
        super(title, imageFile);
    }
 
    /**
     * I
     */
    public void execMain(Object param) {
        try {
            // ۑmF
            Latte.getLatteData().checkSaving();

            // _CAO쐬\
            showDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * _CAO̍쐬\
     */
    private void showDialog() {
        dialog_ = GuiUtil.createDialog(600, 200, getTitle());
        GuiUtil.createLabelInForm(dialog_, "XMIt@C", 20, 22, 60, 13);
        xmiFileTxt_ = GuiUtil.createTextInForm(dialog_, 85, 20, 400, 13);
        GuiUtil.createButtonInForm(dialog_, "Q", 515, 20, 40, 20, new XmiFileDiagSelection());
            
        GuiUtil.createLabelInForm(dialog_, "RXPt@C", 20, 52, 60, 13);
        rxpFileTxt_ = GuiUtil.createTextInForm(dialog_, 85, 50, 400, 13);
        GuiUtil.createButtonInForm(dialog_, "Q", 515, 50, 40, 20, new RxpFileDiagSelection());

        GuiUtil.createLabelInForm(dialog_, "RXPt@Cw肷Ɠ{̕܂", 85, 80, 400, 30);
            
        GuiUtil.createButtonInForm(dialog_, "IMPORT", 200, 140, 90, 30, new ImportSelection());
        GuiUtil.createButtonInForm(dialog_, "LZ", 310, 140, 90, 30, new CancelSelection());
            
        dialog_.open();
    }
    
    /**
     * XMIt@CǍ
     */
    class ImportSelection extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
/*            try {
                // t@C擾
                final String xmiFileName = xmiFileTxt_.getText();
                final String rxpFileName = rxpFileTxt_.getText();
                if (xmiFileName.length() == 0) {
                    MsgUtil.showMsg("XMIt@C͂Ă");
                    return;
                }
                // LatteDataj
                Latte.getLatteData().destroy();
                // ҂}EXJ[\
                GuiUtil.setWaitMouseCursor();
                // _CAO
                dialog_.close();            
                
                new Thread() {
                    public void run() {
                        try {
                            // LatteData쐬At@C烍[h
                            LatteData latteData = new LatteData();
                            latteData.setFile(new File(xmiFileName));
                            latteData.load();
                            if (latteData.getXMI().getXMIContent() == null) {
                                throw new Exception("Lattet@C̓Ǎݎs");
                            }
                            // VLatteDataݒ
                            Latte.setLatteData(latteData);
                            
                            // toolRose->Latte֕ύX
                            // geometory4Ŋ        
                            changeRose2Latte();
            
                            // RXPt@CV{Ǎ
                            if (rxpFileName.length() != 0) {
                                Map map = readRxpFile(rxpFileName);
                                LogUtil.writeln("ǂݍ񂾃V{=" + map.size());
                                // V{f
                                reflectSymbol(map);
                            }
                            
                            // t@C𖳂ɂ
                            Latte.getLatteData().setFile(null);

                            // IuU[oǉ
                            latteData.addObserver(Latte.getMainForm());
                            // r[
                            GuiUtil.syncExce(new Runnable() {
                                public void run() {
                                    LMChangedEvent lmce = new LMChangedEvent(LMChangedEvent.INIT, null, null);
                                    Latte.getLatteData().notifyObserversForce(lmce);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MsgUtil.showMsgAsync("G[܂F"+e.getMessage());
                        }
                        finally {
                            // W}EXJ[\
                            GuiUtil.setNormalMouseCursor();                                                
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
*/
        }
    }
    class CancelSelection extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
            dialog_.close();
        }
    }
    class XmiFileDiagSelection extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
            // ǂݍݗp_CAOJ
            String openFile = GuiUtil.openFileDialog(SWT.OPEN, GuiUtil.XMI_EXTENTION);
            // LZȂ߂
            if (openFile == null) {
                return;
            }
            // It@C𔽉f
            xmiFileTxt_.setText(openFile);
        }
    }
    class RxpFileDiagSelection extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
            // ǂݍݗp_CAOJ
            String openFile = GuiUtil.openFileDialog(SWT.OPEN, GuiUtil.RXP_EXTENTION);
            // LZȂ߂
            if (openFile == null) {
                return;
            }
            // It@C𔽉f
            rxpFileTxt_.setText(openFile);
        }
    }
    
    /**
     * RXPt@CǍ݁AV{e[u쐬
     * @param file
     * @return map
     */
    private Map readRxpFile(String file) throws IOException {
    	HashMap map = new HashMap();
    	
		BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
    	String line = null;
    	
		int index = -1;
    	String key = null;
    	String value = null;
    	while ((line=reader.readLine()) != null) {
    		// t@C̍Ō܂œǂ
    		
			// PA" with id "̍sȉ̂悤ɒo
			// @@L[F̒P
			// @@l@FO''ň͂܂ꂽB{}
			index = line.lastIndexOf(WITHID);
			if (index != -1) {
				key = line.substring(index+WITHID.length());
				value = line.split("'")[1];
				map.put(key, value);
				continue;
			}
			// QA" NoteView @ "̍sȉ̂悤ɒo
			// @@L[F̒P
			// @@l@F̍s"**Text="ȉ
			index = line.lastIndexOf(NOTEVIEW);
			if (index != -1) {
				key = line.substring(index+NOTEVIEW.length());
				value = reader.readLine().substring(7);
				map.put(key, value);				
				continue;
			}
    	}
    	
    	return map;
    }
    
    /**
     * RoseLatte֊eύX
     * 
     * UML:Diagram̑toolNameύX"Rational Rose 98" -> "Latte ver1"
     * @@@@@@@@@geometory4Ŋ
     */
    private void changeRose2Latte() {
/*
        ILM13XMIContentChoice[] content = Latte.getLatteData().getXMI().getXMIContent().getContent();
        for (int i=0; i<content.length; i++) {
            if (content[i] instanceof LM13Diagram) {
                LM13Diagram diag = (LM13Diagram)content[i];

                // toolnameύX
                diag.setToolName(LVDiag.TOOL_NAME);
                
                // geometoryύX
                LM13DiagramElement1 de1 = ModelUtil.getDiagramElement(diag);
                LM13DiagramElement2[] de2 = de1.getDiagramElement();
                for (int j=0; j<de2.length; j++) {
                    de2[j].setGeometry(convGeometry(de2[j].getGeometry()));
                }
            }  
        }*/
    }
    
    /**
     * {ϊ@4̂Pɂ
     * @param roseGeo
     * @return latteGeometry
     */
    private String convGeometry(String roseGeo) {
        String[] s = roseGeo.split(",");
        int x = Integer.parseInt(s[0].trim())/RATE;
        int y = Integer.parseInt(s[1].trim())/RATE;
        int w = Integer.parseInt(s[2].trim())/RATE;
        int h = Integer.parseInt(s[3].trim())/RATE;
        
        String latteGeo = x+", "+y+", "+w+", "+h;

        return latteGeo;
    }

	/**
	 * V{𔽉f
	 * 
	 * commentrxp̂قid͂P
	 * @param map
	 */
	private void reflectSymbol(Map symbol) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
/*
		Set idRefs = Latte.getLatteData().idrefEntrySet();
		Iterator ite = idRefs.iterator();
		Map.Entry entry = null;
		int i=0,j=0;
		while (ite.hasNext()) {
			entry = (Map.Entry)ite.next();
			Object element = entry.getValue();
			Method m = element.getClass().getMethod("setName", new Class[]{String.class});
			String xmiid = (String)entry.getKey();
			if (element instanceof LM13Comment) {
				// rxpid = xmiid -1
				System.out.print(xmiid);
				int lastIndex = xmiid.lastIndexOf(".");
				int num = Integer.parseInt(xmiid.substring(lastIndex+1));
				xmiid = xmiid.substring(0,lastIndex+1) + String.valueOf(num-1);
			}
			String newName = (String)symbol.get(xmiid);
			if (newName != null) {
				// Oݒ
				m.invoke(element, new Object[]{newName});
				LogUtil.writeln(""+element);
				i++;
			} else {
				LogUtil.writeln("~"+element);
				j++;
			}
		}
        LogUtil.writeln("="+i);
        LogUtil.writeln("~="+j);
*/
	}
}
