/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;

import latte.Latte;
import latte.di.GraphNode;
import latte.util.ModelUtil;

/**
 * `IԂɂ
 * 
 * @version $Id: ShowDefAction.java,v 1.2 2004/09/04 16:05:38 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class ShowDefAction extends AbstractLatteAction {

    public ShowDefAction(String title, String imageFile) {
        super(title, imageFile);
    }
 
    /**
     * Is
     * 
     * @param param IꂽIuWFNg
     */   
    public void execMain(Object param) {
        // I擾
        GraphNode selectedNode = (GraphNode)Latte.getMainForm().getSelectedModels();
        Element selectedElement = ModelUtil.getElement(selectedNode);

        if (selectedElement instanceof Class || selectedElement instanceof Interface) {
            TreeItem treeItem = Latte.getMainForm().getTree().lookupTreeItem((Element)selectedElement);
            Latte.getMainForm().getTree().showItem(treeItem);
            Latte.getMainForm().getTree().setSelectionItem(treeItem);
        }
    }
}
