/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import latte.Latte;
import latte.LatteData;
import latte.util.LogUtil;
import latte.util.MsgUtil;

/**
 * @version $Id: FileSaveAction.java,v 1.3 2004/10/02 04:27:57 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class FileSaveAction extends AbstractLatteAction {

    public FileSaveAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        try {
            //LatteData擾
            LatteData latteData = Latte.getLatteData();
            latteData.save();

            // ^Cg
            Latte.getMainForm().setTitle(latteData.getFile().getAbsolutePath());
        }
        catch (IllegalStateException e) {
            AllAction.FILE_SAVEAS.execute(null);
        }
        catch (Exception e) {
            LogUtil.write("t@CۑɎs܂", e);
            MsgUtil.showMsg("t@CۑɎs܂");
        }
    }
}
