/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import latte.InternalLogicException;
import latte.Latte;
import latte.LatteData;
import latte.di.Diagram;
import latte.util.GuiUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.view.LVTree;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.UML2Package;

/**
 * 
 * t@CJ
 * 
 * @version $Id: FileOpenAction.java,v 1.5 2004/10/02 04:27:55 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class FileOpenAction extends AbstractLatteAction {

    public FileOpenAction(String title, String imageFile) {
        super(title, imageFile);
    }
 
    /**
     * I
     */
    public void execMain(Object param) {
        try {
            //LatteData擾
            LatteData latteData = Latte.getLatteData();
            // ۑmF
            latteData.checkSaving();
            
            // ǂݍݗp_CAOJ
			String openFile = GuiUtil.openFileDialog(SWT.OPEN);
            // LZȂ߂
            if (openFile == null) {
                return;
            }
            // LatteDataj
            latteData.destroy();
            
            // vJ[\
            GuiUtil.setWaitMouseCursor();

            // LatteData쐬At@C烍[h
            latteData = new LatteData();
            latteData.setFile(new File(openFile));
            latteData.load();
            
            // VLatteDataݒ
			Latte.setLatteData(latteData);

            // r[
            Latte.getMainForm().init();
            // ^Cg
            Latte.getMainForm().setTitle(latteData.getFile().getAbsolutePath());
            // c[fƓ
            Latte.getMainForm().getTree().syncTree();

            // SIuWFNgɃXiǉ
            // syncTreeOɏƒxȂ
            addListener();
        }
        catch (ActionCancelException e) {
            // LZ
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgUtil.showMsg("G[܂B:"+e.getMessage());
        }
        finally {
            // WJ[\
            GuiUtil.setNormalMouseCursor();
        }
    }    
    
    /**
     * SIuWFNgɃXiǉ
     *
     */
    private void addListener() {
        // f
        addModelListener(Latte.getLatteData().getModel());
        
        // }
        addDiagListener(Latte.getLatteData().getDiagrams());
    }
    
    /**
     * ċAIɃXiǉ
     * @param parentNode
     */
    private void addModelListener(EObject eobject){
        List list = new ArrayList();
        LVTree tree = Latte.getMainForm().getTree();
        
        switch (ModelUtil.getClassifierID(eobject)) {
        case UML2Package.MODEL:
            Model mdl = (Model)eobject;
        	mdl.eAdapters().add(tree);
            list = mdl.getOwnedMembers(); // pbP[WANXAC^[tFCX
            break;
        
        case UML2Package.PACKAGE:
            Package pkg = (Package)eobject;
            pkg.eAdapters().add(tree);
            list = pkg.getOwnedMembers(); // pbP[WANXAC^[tFCX
            break;
        
        case UML2Package.CLASS:
            Class cls = (Class)eobject;
            cls.eAdapters().add(tree);
            list = cls.getOwnedMembers(); // ANXAC^[tFCXA\bh
            break;
        
        case UML2Package.INTERFACE:
            Interface itf = (Interface)eobject;
            itf.eAdapters().add(tree);
            list = itf.getOwnedMembers(); // ANXAC^[tFCXA\bh
            break;

        case UML2Package.PROPERTY:
        case UML2Package.OPERATION:
        case UML2Package.ASSOCIATION:
        case UML2Package.DEPENDENCY:
        case UML2Package.GENERALIZATION:
        case UML2Package.IMPLEMENTATION:
            Element element = (Element)eobject;
            element.eAdapters().add(tree);
            break;

        default:
            throw new InternalLogicException("Xiǉs : "+eobject);
        }
        
        // ċAIɃXiǉ
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            EObject child = (EObject)ite.next();
            addModelListener(child);
        }
    }
    
    /**
     * }̃Xi(TreeDiagFolder)ǉ
     * 
     * @param childs
     */
    private void addDiagListener(EObject diagrams) {
        // }̒ǉA폜̂߃Xiǉ
        diagrams.eAdapters().add(Latte.getMainForm().getTree());
        diagrams.eAdapters().add(Latte.getMainForm().getDiagFolder());
        
        // }̖̕ύX̂߃Xiǉ
        Iterator i = diagrams.eContents().iterator();
        while (i.hasNext()) {
            Diagram diagram = (Diagram)i.next();
            diagram.eAdapters().add(Latte.getMainForm().getTree());
            diagram.eAdapters().add(Latte.getMainForm().getDiagFolder());
        }
    }
    
    
}
