/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import java.io.IOException;

import latte.Latte;
import latte.LatteData;
import latte.util.LogUtil;

/**
 * VLattef[^쐬
 * 
 * Lattef[^݂ꍇAۑԂȂ烆[UɕۑmF
 * 
 * @version $Id: FileNewAction.java,v 1.3 2004/10/02 04:27:55 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class FileNewAction extends AbstractLatteAction {

    public FileNewAction(String title, String imageFile) {
        super(title, imageFile);
    }
    
    /**
     * ICxg
     * 
     */
    public void execMain(Object param) {
        try {
			// ÂLatteDataɑ΂鏈
			LatteData latteData = Latte.getLatteData();// LatteData擾
            if (latteData != null) {
                // ݂
                latteData.checkSaving();// ۑmF
                latteData.destroy();// j
            }

            // VLatteDataɑ΂鏈
			latteData = new LatteData();// LatteDataVK쐬
			Latte.setLatteData(latteData);// VLatteDataݒ
            
            // r[
            Latte.getMainForm().init();

            // SIuWFNgɃXiǉ
            addListener();
        }
        catch (ActionCancelException e) {
            LogUtil.writeln("LZ܂");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * SIuWFNgɃXiǉ
     *
     */
    private void addListener() {
        Latte.getLatteData().getModel().eAdapters().add(Latte.getMainForm().getTree());
        Latte.getLatteData().getDiagrams().eAdapters().add(Latte.getMainForm().getTree());
        Latte.getLatteData().getDiagrams().eAdapters().add(Latte.getMainForm().getDiagFolder());
    }
}
