/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.swt.events.ShellEvent;

import latte.Latte;
import latte.util.LogUtil;


/**
 * @version $Id: FileExitAction.java,v 1.2 2004/09/04 16:05:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class FileExitAction extends AbstractLatteAction {

    public FileExitAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        LogUtil.writeln("FileExitAction.execute()");
        try {
            // ۑmF
            Latte.getLatteData().checkSaving();
            
            // LatteData̔j
            Latte.getLatteData().destroy();
            // MainForm̔j
            Latte.getMainForm().destroy();
            // Oo
            LogUtil.writeln("Latte end");
        }
        catch (ActionCancelException e) {
            // LZ
            if (param instanceof ShellEvent) {
                ShellEvent se = (ShellEvent)param;
                se.doit = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        } 
    }
    
    /**
     * ㏈(L^)Ȃ
     * 
     * OsȂ悤ɂ邽
     */
    public void execPost(Object o) {
    }
}
