/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import java.util.Iterator;

import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.UML2Package;

import latte.Latte;
import latte.di.Diagram;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

/**
 * OύXANV
 * 
 * @version $Id: EditRenameAction.java,v 1.4 2004/10/02 04:27:58 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class EditRenameAction extends AbstractLatteAction {

    public EditRenameAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        try {
            // VO
            Object model = ((Object[])param)[0];
            String newName = (String)((Object[])param)[1];
        
            // `FbN
            check(model, newName);
        
            if (model instanceof Diagram) {
                // }
            
                // `
                Diagram diag = (Diagram)model;
                // ̖OVOȂ
                if (!diag.getName().equals(newName)) {
                    diag.setName(newName);
                    // t@CۑKv
                    ModelUtil.setNeedSaving();            
                }
            } else {
                // }ȊO
            
                // `
                NamedElement namedElement = (NamedElement)model;
                // ̖OVOȂ
                if (!namedElement.getName().equals(newName)) {
                    // f̖OύXs
                    namedElement.setName(newName);
            
                    // t@CۑKv
                    ModelUtil.setNeedSaving();            
                }        
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgUtil.showMsg(e.getMessage());
        }        
    }
    
    /**
     * `FbN
     * 
     * @param renameDef
     */
    private void check(Object renameDef, String newName) {
        // f`FbN
        if (renameDef == Latte.getLatteData().getModel()) {
            throw new IllegalArgumentException("fi[gpbP[Wj͖̕ύXł܂");
        }
        
        // `FbN
        switch (ModelUtil.getClassifierID(renameDef)) {
        case UML2Package.CLASS:
        case UML2Package.INTERFACE:
        case UML2Package.PACKAGE:
        case UML2Package.PROPERTY:
            NamedElement renameNamedElement = (NamedElement)renameDef;
            NamedElement parentNamedElement = (NamedElement)renameNamedElement.getOwner();
            Iterator ite = parentNamedElement.getOwnedElements().iterator();
            while (ite.hasNext()) {
                Object o = ite.next();
                // ֌W
                if (o instanceof NamedElement) {
                    NamedElement ne = (NamedElement)o;
                    // ʃIuWFNgœȂG[
                    if (renameDef != ne && newName.equals(ne.getName())) {
                        throw new IllegalArgumentException("'"+newName + "'ɖ̕ύXł܂BO݂܂B");                    
                    }
                }
            }
            break;
            
        default:
            // `FbN
            break;
        }
    }
}
