/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.UML2Package;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.DIPackage;
import latte.util.ModelUtil;

/**
 * 
 * @version $Id: AllAction.java,v 1.6 2004/02/19 18:19:36 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class AllAction {
    // ANV̗LEݒ
    private static final boolean[][] actionEnableTable_ = {
    // 01`7ȊO
    //selectedTop-> 0,    1,      2,      3,      4,      5,      6,      7     8
                {true,  true,  true,  true,   true,  true,  true,  true, false}, // 1.add CLASS_DIAGRAM
                {true,  true,  true,  true,   true,  true,  true,  true, false}, // 2.add SEQUENCE_DIAGRAM
                {false, false, false, true,  true, true,  false, false, false}, // 3.add CLASS
                {false, false, false, true,  true, true,  false, false, false}, // 4.add INTERFACE
                {false, false, false, false, false, true,  false, false, false}, // 5.add PACKAGE
                {false, false, false, true,  true,  false, false, false, true}, // 6.add METHOD
                {false, false, false, true,  true, false, false, false, true}, // 7.add ATTRIBUTE
                {},//8.FIGURE
                {},//9.NOTE
                {},//10.ASSOCIATION
                {},//11.GENERALIZATION
                {},//12.DEPENDENCY
                {},//13.IMPLEMENTATION
                {},//14.NOTELINK
    };
    
    // t@C
    public static final AbstractLatteAction FILE_NEW = new FileNewAction("VK쐬", "images/new.gif");
    public static final AbstractLatteAction FILE_OPEN = new FileOpenAction("J", "images/open.gif");
    public static final AbstractLatteAction FILE_SAVE = new FileSaveAction("ۑ", "images/save.gif");
    public static final AbstractLatteAction FILE_SAVEAS = new FileSaveAsAction("ʖۑ", "images/saveas.gif");
    public static final AbstractLatteAction FILE_PRINT = new FilePrintAction("", "images/print.gif");
    public static final AbstractLatteAction FILE_EXIT = new FileExitAction("I", "images/new.gif");
    // ҏW
    public static final AbstractLatteAction EDIT_COPY = new EditCopyAction("Rs[", "images/copy.gif");
    public static final AbstractLatteAction EDIT_PASTE = new EditPasteAction("y[Xg", "images/paste.gif");
    public static final AbstractLatteAction EDIT_CUT = new EditCutAction("Jbg", "images/cut.gif");
    public static final AbstractLatteAction EDIT_REMOVE = new EditRemoveAction("폜", "images/delete.gif");
    public static final AbstractLatteAction EDIT_RENAME = new EditRenameAction("OύX", null);
    public static final AbstractLatteAction EDIT_NOTE = new EditNoteAction("m[gύX", null);
    // ǉ
    public static final AbstractLatteAction ADD_CLASS_DIAGRAM = new AddClassDiagramAction("NX}̍쐬", "images/classdiag.gif");
    public static final AbstractLatteAction ADD_SEQUENCE_DIAGRAM = new AddSequenceDiagramAction("V[PX}̍쐬", "images/seqdiag.gif");
    public static final AbstractLatteAction ADD_CLASS = new AddClassAction("NX̒ǉ", "images/class.gif");
    public static final AbstractLatteAction ADD_INTERFACE = new AddInterfaceAction("C^[tFCX̒ǉ", "images/interface.gif");
    public static final AbstractLatteAction ADD_PACKAGE = new AddPackageAction("pbP[W̒ǉ", "images/package.gif");
    public static final AbstractLatteAction ADD_METHOD = new AddMethodAction("̒ǉ", "images/addMethod.gif");
    public static final AbstractLatteAction ADD_ATTRIBUTE = new AddAttributeAction("̒ǉ", "images/addAttribute.gif");
    // c[ ̑
	public static final AbstractLatteAction TOOL_OPEN_RXP = new ToolRoseImportAction("Rose XMIt@C IMPORT", null);
    public static final AbstractLatteAction TOOL_JAVA_REVERSE = new ToolJavaReverseAction("Java\[X̃o[X", null);
    // wv
    public static final AbstractLatteAction HELP_DOC = new HelpDocAction("wv", null);
    public static final AbstractLatteAction HELP_VER = new HelpVerAction("latteɂ", "images/latte.gif");
    
    // NX}
    public static final AbstractLatteAction ADD_FIGURE = new AddFigureAction("tBMAǉ", null);
    public static final AbstractLatteAction ADD_RELATION = new AddRelationAction("֌Wǉ", null);
    public static final AbstractLatteAction ADD_NOTE = new AddNoteAction("m[gǉ", "images/note.gif");
    public static final AbstractLatteAction FIGURE_MOVE = new FigureMoveAction("tBMAړ", null);
    public static final AbstractLatteAction ROUTECONS_SET = new RoutingConsSetAction("[eBOύX", null);    
    public static final AbstractLatteAction ROUTECONS_DELETE = new RoutingConsDeleteAction("[eBO폜", null);    
	public static final AbstractLatteAction NAVIGATABLE = new NavigableAction("U\", null);
    public static final AbstractLatteAction CONTAINER_NONE = new AggregationNoneAction("W񖳂", null);
    public static final AbstractLatteAction CONTAINER_AGGREGATION = new AggregationShareAction("W()", null);
    public static final AbstractLatteAction CONTAINER_COMPOSITION = new AggregationCompositionAction("R|WV()", null);
    public static final AbstractLatteAction SHOW_DEF = new ShowDefAction("`̕\", null);
    public static final AbstractLatteAction SHOW_ATTRIBUTE = new ShowAttributeAction("̕\", "images/attribute.gif");
    public static final AbstractLatteAction SHOW_METHOD = new ShowMethodAction("\bh̕\", "images/method.gif");
    public static final AbstractLatteAction REMOVE_MODEL = new EditRemoveModelAction("f̍폜", null);
    
	// V[PX}
//	public static final AbstractLatteAction MODE_SELECTION = new ModeSelectionAction("I", "images/selection.gif");
//	public static final AbstractLatteAction MODE_ASSOCIATION = new ModeAssociationAction("֘A", "images/association.gif");

    // 
    public static final AbstractLatteAction LATTE_MYSELF = new LatteMainForm("Latte", "images/latte.gif");
    

    /**
     * JgvfɂANV̗L^ݒ肷
     */
    public static void updateActionState() {
    	EObject cur = Latte.getMainForm().getSelectedModels();
        int index=0;
        // indexݒ        
        if (cur==null) {
            index = 0;
        } else {
            switch (ModelUtil.getClassifierID(cur)) {
            case DIPackage.DIAGRAM:
                index = 1;break;
            case UML2Package.CLASS:
                index = 3;   break;
            case UML2Package.INTERFACE:
                index = 4;   break;
            case UML2Package.PACKAGE:
            case UML2Package.MODEL:
                index = 5;   break;
            case UML2Package.OPERATION:
                index = 6;   break;
            case UML2Package.PROPERTY:
                index = 7;   break;
            case DIPackage.GRAPH_NODE:
                index = 8;   break;
            case DIPackage.GRAPH_EDGE:
            case UML2Package.ASSOCIATION:
            case UML2Package.DEPENDENCY:
                index = 0;   break;
            default:
                throw new InternalLogicException("updateActionState()̍lR");
            }
        }
        
        // ANV̗L^ݒ
        ADD_CLASS_DIAGRAM.setEnabled(actionEnableTable_[0][index]);
        ADD_SEQUENCE_DIAGRAM.setEnabled(actionEnableTable_[1][index]);
        ADD_CLASS.setEnabled(actionEnableTable_[2][index]);
        ADD_INTERFACE.setEnabled(actionEnableTable_[3][index]);
        ADD_PACKAGE.setEnabled(actionEnableTable_[4][index]);
        ADD_METHOD.setEnabled(actionEnableTable_[5][index]);
        ADD_ATTRIBUTE.setEnabled(actionEnableTable_[6][index]); 
    }
}
