/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

import latte.util.GuiUtil;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/**
 * ^CgA摜AL^Ǘ
 * ԃXi
 * 
 * @version $Id: AbstractLatteAction.java,v 1.3 2004/10/02 07:37:26 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public abstract class AbstractLatteAction extends SelectionAdapter {
    /** ^Cg */
    private String title_ = null;
    /** C[W */
    private Image image_ = null;
    /** ԃXi */
    private ArrayList listener_ = new ArrayList();
    
    /** RXgN^ */
    public AbstractLatteAction(String title, String imageFile) {
        title_ = title;
        // nullȂC[W쐬Ȃ
        if (imageFile != null) {
            image_ = createImage(imageFile);
        }
    }
    /**
     * IꂽƂ
     */
    public void widgetSelected(SelectionEvent e) {
        synchronized(AbstractLatteAction.class) {
            execute(e);
        }
    }

	/**
	 * s
	 * 
	 * @param param ANVɓK؂ȃp[^n
	 */
	public void execute(Object param) {
		// O
		execPre(param);
		// 又
		execMain(param);
		// ㏈
		execPost(param);
	}
    
	/**
	 * s(O)
	 * 
	 * @param param ANVɓK؂ȃp[^n
	 */
	public void execPre(Object param) {
	}
    /**
     * s(又)
     * 
     * @param param ANVɓK؂ȃp[^n
     */
    public abstract void execMain(Object param);
	/**
	 * s(㏈)
	 * 
	 * @param param ANVɓK؂ȃp[^n
	 */
	public void execPost(Object param) {
		// Jg`ŃANV̗LEݒ肷
		AllAction.updateActionState();
	}
        
    /**
     * ^Cg擾
     */
    public String getTitle() {
        return title_;
    }
    
    /**
     * C[W擾
     */
    public Image getImage() {
        return image_;
    }
    
    /**
     * Xio^
     */
    public void addListener(Item i) {
        listener_.add(i);
    }
    
    /**
     * LE
     */
    public void setEnabled(boolean b) {
        Iterator iterator = listener_.iterator();
        while (iterator.hasNext()) {
            Item i = (Item)iterator.next();
            if (i instanceof MenuItem) {
                // j[
                MenuItem mi = (MenuItem)i;
                mi.setEnabled(b);
            } else if (i instanceof ToolItem) {
                // c[{^ڂȂ
                ToolItem ti = (ToolItem)i;
                ti.setEnabled(b);
            }
        }
    }
    
    /**
     * I
     * @param b
     */
    public void setSelected(boolean b) {
        Iterator iterator = listener_.iterator();
        while (iterator.hasNext()) {
            Item i = (Item)iterator.next();
            if (i instanceof ToolItem) {
                // c[{^ڂȂ
                ToolItem ti = (ToolItem)i;
                ti.setSelection(b);
            }
        }
        
    }
    
    /**
     * XiɊ܂܂Ă邩H
     * @param w
     * @return
     */
    public boolean isContainListener(Widget w) {
        return listener_.contains(w);
    }
    
    /**
     * C[W̐
     * w肳ꂽt@C̃C[W\[X擾܂B
     * @param fileName t@C
     * @return Image C[W
     */
    private Image createImage(String fileName) {
		InputStream is = getClass().getResourceAsStream(fileName);
		return GuiUtil.createImage(is);
    }
}
