/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.UML2Package;

import latte.Latte;
import latte.di.DIPackage;
import latte.di.GraphNode;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

/**
 * ǉANV̐^
 *
 * @version $Id: AbstractAddAction.java,v 1.7 2004/10/02 07:37:25 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public abstract class AbstractAddAction extends AbstractLatteAction {
    /** VK쐬IuWFNg(TuNXŎgp) */
    EObject newEObject_ = null;
    
    /**
     * RXgN^
     * 
     * @param title
     * @param imageFile
     */
    public AbstractAddAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    /**
     * PAI𒆂̒`eƂĎ擾
     * QAǉׂ`쐬
     * RAfŐe̖ɒǉ
     * SAIANV
     * TAt@Cۑ
     * @param }EXCxgȂSelectionEvent
     */
    public void execMain(Object param) {
        try {
            // Jgiej擾
            EObject parent = Latte.getMainForm().getSelectedModels();

            // GraphNodeȂO
            // ɂOtFigure瑮ƃ\bhǉ\ɂ
            switch (ModelUtil.getClassifierID(parent)) {
            case DIPackage.GRAPH_NODE:
            case DIPackage.GRAPH_EDGE:
                // Element\
                AllAction.SHOW_DEF.execMain(null);
                
                // Elementparentɂ
                parent = ModelUtil.getElement((GraphNode)parent);
                break;
            }
            
            // ǉ`쐬
            newEObject_ = createDef(param); // 쐬郂f
            
            // Oɐt
            appendNumber(parent);

            // fAe̖ɒǉ
            addDef(parent, newEObject_);
            
            // ^o^
            switch (ModelUtil.getClassifierID(newEObject_)) {
            case UML2Package.CLASS:
            case UML2Package.INTERFACE:
                NamedElement ne = (NamedElement)newEObject_;                
                Latte.getLatteData().addElementByQualifiedName(ne);
                break;

            default:
                break;
            }

            // IuU[oǉiIuU[o͒ǉȂj
            for (Iterator i = getObservers().iterator(); i.hasNext(); ) {
                Object o = i.next();
                // ܂łȂΒǉ
                if (!newEObject_.eAdapters().contains(o)) {
                    newEObject_.eAdapters().add(o);
                }
            }
            if (Latte.TRACE_EVENT) {
                System.out.println("------start--------");
                Iterator i = newEObject_.eAdapters().iterator();
                while (i.hasNext()) {
                    System.out.println("observer:"+i.next());
                }
                System.out.println("-------end--------");
            }
            
            // t@CۑKv
            ModelUtil.setNeedSaving();
        }
        catch(Exception e) {
            LogUtil.write("f쐬s", e);
            MsgUtil.showMsg("G[F" + e.getMessage());
        }
    }
    
    /**
     * ʒm̎擾
     * @return
     */
    Collection getObservers() {
        List observers = new ArrayList();

        // Xiǉ
        observers.add(Latte.getMainForm().getTree());
        
        return observers;
    }
    
    /**
     * ɒǉ
     * @param parent
     */
    private void appendNumber(EObject parent) {
        if (newEObject_ instanceof NamedElement) {
            String name = null;
            NamedElement newNamedElement = (NamedElement)newEObject_;
            NamedElement parentNamedElement = (NamedElement)parent;
            
            // ő1܂Ō
            for (int i=0; i<10000; i++) {
                boolean exist = false;
                // O
                name = newNamedElement.getName() + i;
                Iterator ite = parentNamedElement.getOwnedElements().iterator();
                while (ite.hasNext()) {
                    Object o = ite.next();
                    // ֌WȊOȂ
                    if (o instanceof NamedElement) {
                        NamedElement ne = (NamedElement)o;
                        if (name.equals(ne.getName())) {
                            exist = true;
                            break;
                        }
                    }
                }
                // ݂Ȃ΃[v
                if (!exist) {
                    break;
                }
            }
            newNamedElement.setName(name);
        }
    }
    
    /**
     * V`쐬
     */
    abstract EObject createDef(Object param);
    
    /**
     * V`eɒǉ
     */
    abstract void addDef(EObject parent, EObject newDef);
}
