/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintOperation;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class PrintFigureOperation
extends PrintOperation {
    private IFigure printSource;
    private Color oldBGColor;

    protected PrintFigureOperation(Printer p) {
        super(p);
    }

    public PrintFigureOperation(Printer p, IFigure srcFigure) {
        super(p);
        this.setPrintSource(srcFigure);
    }

    protected void preparePrintSource() {
        this.oldBGColor = this.getPrintSource().getLocalBackgroundColor();
        this.getPrintSource().setBackgroundColor(ColorConstants.white);
    }

    protected void restorePrintSource() {
        this.getPrintSource().setBackgroundColor(this.oldBGColor);
        this.oldBGColor = null;
    }

    protected void printPages() {
        this.getPrinter().startPage();
        PrinterGraphics g = this.getFreshPrinterGraphics();
        IFigure f = this.getPrintSource();
        this.setupPrinterGraphicsFor(g, f);
        f.paint(g);
        this.getPrinter().endPage();
    }

    protected void setupPrinterGraphicsFor(Graphics g, IFigure f) {
        g.setForegroundColor(f.getForegroundColor());
        g.setBackgroundColor(f.getBackgroundColor());
        g.setFont(f.getFont());
        g.scale((double)this.getPrinter().getDPI().x / (double)Display.getDefault().getDPI().x);
        g.translate(f.getBounds().getCopy().getLocation().negate());
        g.clipRect(f.getBounds());
    }

    protected IFigure getPrintSource() {
        return this.printSource;
    }

    protected void setPrintSource(IFigure printSource) {
        this.printSource = printSource;
    }
}

