/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.peer.PanelPeer;
import sun.awt.SunGraphicsCallback;
import sun.awt.windows.WCanvasPeer;
import sun.awt.windows.WColor;
import sun.awt.windows.WComponentPeer;

class WPanelPeer
extends WCanvasPeer
implements PanelPeer {
    Insets insets_;

    static {
        WPanelPeer.initIDs();
    }

    public void displayChanged() {
        super.displayChanged();
        Component[] componentArray = ((Container)this.target).getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            this.recursiveDisplayChanged(componentArray[i2]);
        }
    }

    private static native void initIDs();

    void initialize() {
        super.initialize();
        this.insets_ = new Insets(0, 0, 0, 0);
        Color color = ((Component)this.target).getBackground();
        if (color == null) {
            color = WColor.getDefaultColor(1);
            ((Component)this.target).setBackground(color);
            this.setBackground(color);
        }
        if ((color = ((Component)this.target).getForeground()) == null) {
            color = WColor.getDefaultColor(2);
            ((Component)this.target).setForeground(color);
            this.setForeground(color);
        }
    }

    void resetTargetGC() {
    }

    WPanelPeer(Component component) {
        super(component);
    }

    private void recursiveDisplayChanged(Component component) {
        Component[] componentArray;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                this.recursiveDisplayChanged(componentArray[i2]);
            }
        }
        if ((componentArray = component.getPeer()) != null && componentArray instanceof WComponentPeer) {
            WComponentPeer wComponentPeer = (WComponentPeer)componentArray;
            wComponentPeer.displayChanged();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        SunGraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.target).getComponents(), graphics, 3);
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.target).getComponents(), graphics, 3);
    }

    public Insets getInsets() {
        return this.insets_;
    }

    public Insets insets() {
        return this.getInsets();
    }
}

