/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AccessibleBundle {
    private static Hashtable table = new Hashtable();
    private final String defaultResourceBundleName = "com.sun.accessibility.internal.resources.accessibility";
    protected String key = null;

    public String toDisplayString() {
        return this.toDisplayString(Locale.getDefault());
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString(Locale locale) {
        return this.toDisplayString("com.sun.accessibility.internal.resources.accessibility", locale);
    }

    private void loadResourceBundle(String string, Locale locale) {
        if (!table.contains(locale)) {
            try {
                Hashtable hashtable = new Hashtable();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                Enumeration enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    hashtable.put(string2, resourceBundle.getObject(string2));
                }
                table.put(locale, hashtable);
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println("loadResourceBundle: " + missingResourceException);
                return;
            }
        }
    }

    protected String toDisplayString(String string, Locale locale) {
        Hashtable hashtable;
        this.loadResourceBundle(string, locale);
        Object object = table.get(locale);
        if (object != null && object instanceof Hashtable && (object = (hashtable = (Hashtable)object).get(this.key)) != null && object instanceof String) {
            return (String)object;
        }
        return this.key;
    }
}

