/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;

public final class Inet6Address
extends InetAddress {
    static final int INADDRSZ = 16;
    private transient int cached_scope_id = 0;
    byte[] ipaddress;
    private static final long serialVersionUID = 6880410070516793377L;
    private static final int INT16SZ = 2;

    public int hashCode() {
        if (this.ipaddress != null) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 16) {
                int n4 = 0;
                for (int i2 = 0; i2 < 4 && n3 < 16; ++i2, ++n3) {
                    n4 = (n4 << 8) + this.ipaddress[n3];
                }
                n2 += n4;
            }
            return n2;
        }
        return 0;
    }

    static {
        Inet6Address.init();
    }

    Inet6Address() {
        this.hostName = null;
        this.ipaddress = new byte[16];
        this.family = 2;
    }

    private static native void init();

    public boolean isAnyLocalAddress() {
        byte by = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            by = (byte)(by | this.ipaddress[i2]);
        }
        return by == 0;
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 128;
    }

    public boolean isLoopbackAddress() {
        byte by = 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            by = (byte)(by | this.ipaddress[i2]);
        }
        return by == 0 && this.ipaddress[15] == 1;
    }

    public boolean isMCGlobal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 14;
    }

    public boolean isMCLinkLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 2;
    }

    public boolean isMCNodeLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 1;
    }

    public boolean isMCOrgLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 8;
    }

    public boolean isMCSiteLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 5;
    }

    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xFF) == 255;
    }

    public boolean isSiteLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 192;
    }

    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    static boolean isIPv4MappedAddress(byte[] byArray) {
        if (byArray.length < 16) {
            return false;
        }
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == -1 && byArray[11] == -1;
    }

    static byte[] convertFromIPv4MappedAddress(byte[] byArray) {
        if (Inet6Address.isIPv4MappedAddress(byArray)) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 12, byArray2, 0, 4);
            return byArray2;
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ipaddress = (byte[])this.ipaddress.clone();
        if (this.ipaddress.length != 16) {
            throw new InvalidObjectException("invalid address length: " + this.ipaddress.length);
        }
        if (this.family != 2) {
            throw new InvalidObjectException("invalid address family type");
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inet6Address = (Inet6Address)object;
        for (int i2 = 0; i2 < 16; ++i2) {
            if (this.ipaddress[i2] == inet6Address.ipaddress[i2]) continue;
            return false;
        }
        return true;
    }

    public String getHostAddress() {
        return Inet6Address.numericToTextFormat(this.ipaddress);
    }

    static byte[] textToNumericFormat(String string) {
        int n2;
        if (string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[16];
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        if (cArray[n4] == ':' && cArray[++n4] != ':') {
            return null;
        }
        int n6 = n4;
        boolean bl2 = false;
        int n7 = 0;
        while (n4 < cArray.length) {
            char c2;
            if ((n2 = Character.digit(c2 = cArray[n4++], 16)) != -1) {
                n7 <<= 4;
                if ((n7 |= n2) > 65535) {
                    return null;
                }
                bl2 = true;
                continue;
            }
            if (c2 == ':') {
                n6 = n4;
                if (!bl2) {
                    if (n3 != -1) {
                        return null;
                    }
                    n3 = n5;
                    continue;
                }
                if (n4 == cArray.length) {
                    return null;
                }
                if (n5 + 2 > 16) {
                    return null;
                }
                byArray[n5++] = (byte)(n7 >> 8 & 0xFF);
                byArray[n5++] = (byte)(n7 & 0xFF);
                bl2 = false;
                n7 = 0;
                continue;
            }
            if (c2 == '.' && n5 + 4 <= 16) {
                byte[] byArray2 = Inet4Address.textToNumericFormat(string.substring(n6));
                if (byArray2 == null) {
                    return null;
                }
                for (int i2 = 0; i2 < 4; ++i2) {
                    byArray[n5++] = byArray2[i2];
                }
                bl2 = false;
                break;
            }
            return null;
        }
        if (bl2) {
            if (n5 + 2 > 16) {
                return null;
            }
            byArray[n5++] = (byte)(n7 >> 8 & 0xFF);
            byArray[n5++] = (byte)(n7 & 0xFF);
        }
        if (n3 != -1) {
            n2 = n5 - n3;
            if (n5 == 16) {
                return null;
            }
            for (n4 = 1; n4 <= n2; ++n4) {
                byArray[16 - n4] = byArray[n3 + n2 - n4];
                byArray[n3 + n2 - n4] = 0;
            }
            n5 = 16;
        }
        if (n5 != 16) {
            return null;
        }
        byte[] byArray3 = Inet6Address.convertFromIPv4MappedAddress(byArray);
        if (byArray3 != null) {
            return byArray3;
        }
        return byArray;
    }

    Inet6Address(String string, byte[] byArray) {
        this.hostName = string;
        if (byArray.length == 16) {
            this.family = 2;
            this.ipaddress = (byte[])byArray.clone();
        }
    }

    static String numericToTextFormat(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(39);
        for (int i2 = 0; i2 < 8; ++i2) {
            stringBuffer.append(Integer.toHexString(byArray[i2 << 1] << 8 & 0xFF00 | byArray[(i2 << 1) + 1] & 0xFF));
            if (i2 >= 7) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }
}

