/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import java.io.UnsupportedEncodingException;
import javax.naming.InvalidNameException;

public class ResourceRecord {
    static final int TYPE_A = 1;
    static final int TYPE_NS = 2;
    static final int TYPE_CNAME = 5;
    static final int TYPE_SOA = 6;
    static final int TYPE_PTR = 12;
    static final int TYPE_HINFO = 13;
    static final int TYPE_MX = 15;
    static final int TYPE_TXT = 16;
    static final int TYPE_AAAA = 28;
    static final int TYPE_SRV = 33;
    static final int TYPE_NAPTR = 35;
    static final int QTYPE_AXFR = 252;
    static final int QTYPE_STAR = 255;
    static final String[] rrTypeNames = new String[]{null, "A", "NS", null, null, "CNAME", "SOA", null, null, null, null, null, "PTR", "HINFO", null, "MX", "TXT", null, null, null, null, null, null, null, null, null, null, null, "AAAA", null, null, null, null, "SRV", null, "NAPTR"};
    static final int CLASS_INTERNET = 1;
    static final int CLASS_HESIOD = 2;
    static final int QCLASS_STAR = 255;
    static final String[] rrClassNames = new String[]{null, "IN", null, null, "HS"};
    byte[] msg;
    int msgLen;
    boolean qSection;
    int offset;
    int rrlen;
    DnsName name;
    int rrtype;
    String rrtypeName;
    int rrclass;
    String rrclassName;
    int ttl = 0;
    int rdlen = 0;
    Object rdata = null;

    public int getRrclass() {
        return this.rrclass;
    }

    public int getType() {
        return this.rrtype;
    }

    public int size() {
        return this.rrlen;
    }

    private int getInt(int n2) {
        return this.getUShort(n2) << 16 | this.getUShort(n2 + 2);
    }

    private int getUByte(int n2) {
        return this.msg[n2] & 0xFF;
    }

    private int getUShort(int n2) {
        return (this.msg[n2] & 0xFF) << 8 | this.msg[n2 + 1] & 0xFF;
    }

    private long getUInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    public static int compareSerialNumbers(long l2, long l3) {
        long l4 = l3 - l2;
        if (l4 == 0L) {
            return 0;
        }
        if (l4 > 0L && l4 <= Integer.MAX_VALUE || l4 < 0L && -l4 > Integer.MAX_VALUE) {
            return -1;
        }
        return 1;
    }

    private void decode(boolean bl2) throws InvalidNameException {
        int n2 = this.offset;
        this.name = new DnsName();
        n2 = this.decodeName(n2, this.name);
        this.rrtype = this.getUShort(n2);
        String string = this.rrtypeName = this.rrtype < rrTypeNames.length ? rrTypeNames[this.rrtype] : null;
        if (this.rrtypeName == null) {
            this.rrtypeName = Integer.toString(this.rrtype);
        }
        this.rrclass = this.getUShort(n2 += 2);
        String string2 = this.rrclassName = this.rrclass < rrClassNames.length ? rrClassNames[this.rrclass] : null;
        if (this.rrclassName == null) {
            this.rrclassName = Integer.toString(this.rrclass);
        }
        n2 += 2;
        if (!this.qSection) {
            this.ttl = this.getInt(n2);
            this.rdlen = this.getUShort(n2 += 4);
            Object object = this.rdata = bl2 || this.rrtype == 6 ? this.decodeRdata(n2 += 2) : null;
            if (this.rdata instanceof DnsName) {
                this.rdata = this.rdata.toString();
            }
            n2 += this.rdlen;
        }
        this.rrlen = n2 - this.offset;
        this.msg = null;
    }

    ResourceRecord(byte[] byArray, int n2, int n3, boolean bl2, boolean bl3) throws InvalidNameException {
        this.msg = byArray;
        this.msgLen = n2;
        this.offset = n3;
        this.qSection = bl2;
        this.decode(bl3);
    }

    public DnsName getName() {
        return this.name;
    }

    private DnsName decodeName(int n2) throws InvalidNameException {
        DnsName dnsName = new DnsName();
        this.decodeName(n2, dnsName);
        return dnsName;
    }

    private int decodeName(int n2, DnsName dnsName) throws InvalidNameException {
        if (this.msg[n2] == 0) {
            dnsName.add(0, "");
            return n2 + 1;
        }
        if ((this.msg[n2] & 0xC0) != 0) {
            this.decodeName(this.getUShort(n2) & 0x3FFF, dnsName);
            return n2 + 2;
        }
        byte by = this.msg[n2++];
        try {
            dnsName.add(0, new String(this.msg, n2, (int)by, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.decodeName(n2 + by, dnsName);
    }

    public Object getRdata() {
        return this.rdata;
    }

    private Object decodeRdata(int n2) throws InvalidNameException {
        if (this.rrclass == 1) {
            switch (this.rrtype) {
                case 1: {
                    return this.decodeA(n2);
                }
                case 28: {
                    return this.decodeAAAA(n2);
                }
                case 2: 
                case 5: 
                case 12: {
                    return this.decodeName(n2);
                }
                case 15: {
                    return this.decodeMx(n2);
                }
                case 6: {
                    return this.decodeSoa(n2);
                }
                case 33: {
                    return this.decodeSrv(n2);
                }
                case 35: {
                    return this.decodeNaptr(n2);
                }
                case 16: {
                    return this.decodeTxt(n2);
                }
                case 13: {
                    return this.decodeHinfo(n2);
                }
            }
        }
        byte[] byArray = new byte[this.rdlen];
        System.arraycopy(this.msg, n2, byArray, 0, this.rdlen);
        return byArray;
    }

    public String toString() {
        String string = this.name + " " + this.rrclassName + " " + this.rrtypeName;
        if (!this.qSection) {
            string = string + " " + this.ttl + " " + (this.rdata != null ? this.rdata : "[n/a]");
        }
        return string;
    }

    private String decodeA(int n2) {
        return (this.msg[n2] & 0xFF) + "." + (this.msg[n2 + 1] & 0xFF) + "." + (this.msg[n2 + 2] & 0xFF) + "." + (this.msg[n2 + 3] & 0xFF);
    }

    private String decodeAAAA(int n2) {
        int n3;
        int n4;
        int[] nArray = new int[8];
        for (n4 = 0; n4 < 8; ++n4) {
            nArray[n4] = this.getUShort(n2);
            n2 += 2;
        }
        n4 = -1;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            if (nArray[n3] == 0) {
                if (n4 == -1) {
                    n4 = n3;
                    n5 = 1;
                    continue;
                }
                if (++n5 < 2 || n5 <= n7) continue;
                n6 = n4;
                n7 = n5;
                continue;
            }
            n4 = -1;
        }
        if (n6 == 0) {
            if (n7 == 6 || n7 == 7 && nArray[7] > 1) {
                return "::" + this.decodeA(n2 - 4);
            }
            if (n7 == 5 && nArray[5] == 65535) {
                return "::ffff:" + this.decodeA(n2 - 4);
            }
        }
        n3 = n6 != -1 ? 1 : 0;
        StringBuffer stringBuffer = new StringBuffer(40);
        if (n6 == 0) {
            stringBuffer.append(':');
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            if (n3 == 0 || i2 < n6 || i2 >= n6 + n7) {
                stringBuffer.append(Integer.toHexString(nArray[i2]));
                if (i2 >= 7) continue;
                stringBuffer.append(':');
                continue;
            }
            if (n3 == 0 || i2 != n6) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    private String decodeHinfo(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.rdlen);
        n2 += this.decodeCharString(n2, stringBuffer);
        stringBuffer.append(' ');
        n2 += this.decodeCharString(n2, stringBuffer);
        return stringBuffer.toString();
    }

    private String decodeMx(int n2) throws InvalidNameException {
        int n3 = this.getUShort(n2);
        DnsName dnsName = this.decodeName(n2 += 2);
        return n3 + " " + dnsName;
    }

    private String decodeNaptr(int n2) throws InvalidNameException {
        int n3 = this.getUShort(n2);
        int n4 = this.getUShort(n2 += 2);
        n2 += 2;
        StringBuffer stringBuffer = new StringBuffer();
        n2 += this.decodeCharString(n2, stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer();
        n2 += this.decodeCharString(n2, stringBuffer2);
        StringBuffer stringBuffer3 = new StringBuffer(this.rdlen);
        n2 += this.decodeCharString(n2, stringBuffer3);
        DnsName dnsName = this.decodeName(n2);
        return n3 + " " + n4 + " " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " " + dnsName;
    }

    private String decodeSoa(int n2) throws InvalidNameException {
        DnsName dnsName = new DnsName();
        n2 = this.decodeName(n2, dnsName);
        DnsName dnsName2 = new DnsName();
        n2 = this.decodeName(n2, dnsName2);
        long l2 = this.getUInt(n2);
        long l3 = this.getUInt(n2 += 4);
        long l4 = this.getUInt(n2 += 4);
        long l5 = this.getUInt(n2 += 4);
        long l6 = this.getUInt(n2 += 4);
        n2 += 4;
        return dnsName + " " + dnsName2 + " " + l2 + " " + l3 + " " + l4 + " " + l5 + " " + l6;
    }

    private String decodeSrv(int n2) throws InvalidNameException {
        int n3 = this.getUShort(n2);
        int n4 = this.getUShort(n2 += 2);
        int n5 = this.getUShort(n2 += 2);
        DnsName dnsName = this.decodeName(n2 += 2);
        return n3 + " " + n4 + " " + n5 + " " + dnsName;
    }

    private String decodeTxt(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.rdlen);
        int n3 = n2 + this.rdlen;
        while (n2 < n3) {
            if ((n2 += this.decodeCharString(n2, stringBuffer)) >= n3) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String getRrclassName(int n2) {
        return ResourceRecord.valueToName(n2, rrClassNames);
    }

    public static String getTypeName(int n2) {
        return ResourceRecord.valueToName(n2, rrTypeNames);
    }

    public static int getRrclass(String string) {
        return ResourceRecord.nameToValue(string, rrClassNames);
    }

    public static int getType(String string) {
        return ResourceRecord.nameToValue(string, rrTypeNames);
    }

    private int decodeCharString(int n2, StringBuffer stringBuffer) {
        int n3;
        int n4 = stringBuffer.length();
        boolean bl2 = (n3 = this.getUByte(n2++)) == 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            bl2 |= (n5 = this.getUByte(n2++)) == 32;
            if (n5 == 92 || n5 == 34) {
                bl2 = true;
                stringBuffer.append('\\');
            }
            stringBuffer.append((char)n5);
        }
        if (bl2) {
            stringBuffer.insert(n4, '\"');
            stringBuffer.append('\"');
        }
        return n3 + 1;
    }

    private static String valueToName(int n2, String[] stringArray) {
        String string = null;
        if (n2 > 0 && n2 < stringArray.length) {
            string = stringArray[n2];
        } else if (n2 == 255) {
            string = "*";
        }
        if (string == null) {
            string = Integer.toString(n2);
        }
        return string;
    }

    private static int nameToValue(String string, String[] stringArray) {
        if (string.equals("")) {
            return -1;
        }
        if (string.equals("*")) {
            return 255;
        }
        if (Character.isDigit(string.charAt(0))) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || !string.equalsIgnoreCase(stringArray[i2])) continue;
            return i2;
        }
        return -1;
    }
}

