/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ECollections {
    public static final EList EMPTY_ELIST = new EmptyUnmodifiableEList();

    private ECollections() {
    }

    public static void reverse(EList list) {
        int last = list.size() - 1;
        int i = 0;
        while (i < last) {
            list.move(i, last);
            ++i;
        }
    }

    public static EList unmodifiableEList(EList list) {
        return new UnmodifiableEList(list);
    }

    private static class UnmodifiableEList
    implements EList {
        protected EList list;

        public UnmodifiableEList(EList list) {
            this.list = list;
        }

        public int size() {
            return this.list.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.list.toArray(a);
        }

        public String toString() {
            return this.list.toString();
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator i;
                final /* synthetic */ UnmodifiableEList this$1;
                {
                    this.this$1 = unmodifiableEList;
                    this.i = unmodifiableEList.list.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection coll) {
            return this.list.containsAll(coll);
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public boolean addAll(int index, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            return new ListIterator(this, index){
                ListIterator i;
                final /* synthetic */ UnmodifiableEList this$1;
                {
                    this.this$1 = unmodifiableEList;
                    this.i = unmodifiableEList.list.listIterator(n);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                public Object previous() {
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex();
                }

                public int previousIndex() {
                    return this.i.previousIndex();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object o) {
                    throw new UnsupportedOperationException();
                }

                public void add(Object o) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int fromIndex, int toIndex) {
            return new UnmodifiableEList(new BasicEList(this.list.subList(fromIndex, toIndex)));
        }

        public void move(int newPosition, Object o) {
            throw new UnsupportedOperationException();
        }

        public Object move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyUnmodifiableEList
    implements EList {
        ListIterator listIterator = new ListIterator(this){
            final /* synthetic */ EmptyUnmodifiableEList this$1;
            {
                this.this$1 = emptyUnmodifiableEList;
            }

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return false;
            }

            public Object previous() {
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return 0;
            }

            public int previousIndex() {
                return -1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object o) {
            return Collections.EMPTY_LIST.equals(o);
        }

        public int hashCode() {
            return Collections.EMPTY_LIST.hashCode();
        }

        public Object get(int index) {
            return Collections.EMPTY_LIST.get(index);
        }

        public boolean contains(Object o) {
            return false;
        }

        public int indexOf(Object o) {
            return -1;
        }

        public int lastIndexOf(Object o) {
            return -1;
        }

        public Iterator iterator() {
            return this.listIterator;
        }

        public ListIterator listIterator() {
            return this.listIterator;
        }

        public ListIterator listIterator(int index) {
            return this.listIterator;
        }

        public List subList(int fromIndex, int toIndex) {
            return Collections.EMPTY_LIST.subList(fromIndex, toIndex);
        }

        public Object[] toArray() {
            return Collections.EMPTY_LIST.toArray();
        }

        public Object[] toArray(Object[] a) {
            return Collections.EMPTY_LIST.toArray(a);
        }

        public String toString() {
            return Collections.EMPTY_LIST.toString();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection coll) {
            return false;
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void move(int newPosition, Object o) {
            throw new UnsupportedOperationException();
        }

        public Object move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }
    }
}

