/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;

public final class CommonPlugin
extends EMFPlugin {
    public static final CommonPlugin INSTANCE = new CommonPlugin();
    private static Implementation plugin;

    private CommonPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static URI asLocalURI(URI uri) {
        return plugin == null ? uri : Implementation.asLocalURI(uri);
    }

    public static URI resolve(URI uri) {
        return plugin == null ? uri : Implementation.resolve(uri);
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        protected static URI asLocalURI(URI uri) {
            try {
                String fragment = uri.fragment();
                URL url = Platform.asLocalURL((URL)new URL(uri.trimFragment().toString()));
                return Implementation.fix(url, fragment);
            }
            catch (IOException iOException) {
                return uri;
            }
        }

        protected static URI resolve(URI uri) {
            try {
                String fragment = uri.fragment();
                URL url = Platform.resolve((URL)new URL(uri.trimFragment().toString()));
                return Implementation.fix(url, fragment);
            }
            catch (IOException iOException) {
                return uri;
            }
        }

        protected static URI fix(URL url, String fragment) throws IOException {
            URI result;
            URI uRI = result = "file".equalsIgnoreCase(url.getProtocol()) ? URI.createFileURI(url.getFile()) : URI.createURI(url.toString());
            if (fragment != null) {
                result = result.appendFragment(fragment);
            }
            return result;
        }
    }
}

