/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.MessageOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ThreadInfo {
    private static List threads = Collections.synchronizedList(new ArrayList());
    private static boolean gotInitialThreads = false;
    private static ThreadInfo current = null;
    private static ThreadGroupReference group = null;
    private final ThreadReference thread;
    private int currentFrameIndex = 0;

    int getCurrentFrameIndex() {
        return this.currentFrameIndex;
    }

    private void assureSuspended() throws IncompatibleThreadStateException {
        if (!this.thread.isSuspended()) {
            throw new IncompatibleThreadStateException();
        }
    }

    private static void initThreads() {
        if (!gotInitialThreads) {
            Iterator iterator = Env.vm().allThreads().iterator();
            while (iterator.hasNext()) {
                ThreadReference threadReference = (ThreadReference)iterator.next();
                threads.add(new ThreadInfo(threadReference));
            }
            gotInitialThreads = true;
        }
    }

    void invalidate() {
        this.currentFrameIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateAll() {
        current = null;
        group = null;
        List list = threads;
        synchronized (list) {
            Iterator iterator = ThreadInfo.threads().iterator();
            while (iterator.hasNext()) {
                ThreadInfo threadInfo = (ThreadInfo)iterator.next();
                threadInfo.invalidate();
            }
        }
    }

    void down(int n) throws IncompatibleThreadStateException {
        this.setCurrentFrameIndex(this.currentFrameIndex - n);
    }

    void setCurrentFrameIndex(int n) throws IncompatibleThreadStateException {
        this.assureSuspended();
        if (n < 0 || n >= this.thread.frameCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex = n;
    }

    void up(int n) throws IncompatibleThreadStateException {
        this.setCurrentFrameIndex(this.currentFrameIndex + n);
    }

    StackFrame getCurrentFrame() throws IncompatibleThreadStateException {
        if (this.thread.frameCount() == 0) {
            return null;
        }
        return this.thread.frame(this.currentFrameIndex);
    }

    static ThreadGroupReference group() {
        if (group == null) {
            ThreadInfo.setThreadGroup((ThreadGroupReference)Env.vm().topLevelThreadGroups().get(0));
        }
        return group;
    }

    static void setThreadGroup(ThreadGroupReference threadGroupReference) {
        group = threadGroupReference;
    }

    ThreadReference getThread() {
        return this.thread;
    }

    private ThreadInfo(ThreadReference threadReference) {
        this.thread = threadReference;
        if (threadReference == null) {
            MessageOutput.fatalError("Internal error: null ThreadInfo created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addThread(ThreadReference threadReference) {
        List list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            ThreadInfo threadInfo = new ThreadInfo(threadReference);
            if (ThreadInfo.getThreadInfo(threadReference) == null) {
                threads.add(threadInfo);
            }
        }
    }

    static void removeThread(ThreadReference threadReference) {
        if (threadReference.equals(current)) {
            String string;
            try {
                string = "\"" + threadReference.name() + "\"";
            }
            catch (Exception exception) {
                string = "";
            }
            ThreadInfo.setCurrentThread(null);
            MessageOutput.println();
            MessageOutput.println("Current thread died. Execution continuing...", string);
        }
        threads.remove(ThreadInfo.getThreadInfo(threadReference));
    }

    static void setCurrentThread(ThreadReference threadReference) {
        if (threadReference == null) {
            ThreadInfo.setCurrentThreadInfo(null);
        } else {
            ThreadInfo threadInfo = ThreadInfo.getThreadInfo(threadReference);
            ThreadInfo.setCurrentThreadInfo(threadInfo);
        }
    }

    static ThreadInfo getCurrentThreadInfo() {
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadInfo getThreadInfo(long l) {
        ThreadInfo threadInfo = null;
        List list = threads;
        synchronized (list) {
            Iterator iterator = ThreadInfo.threads().iterator();
            while (iterator.hasNext()) {
                ThreadInfo threadInfo2 = (ThreadInfo)iterator.next();
                if (threadInfo2.thread.uniqueID() != l) continue;
                threadInfo = threadInfo2;
                break;
            }
        }
        return threadInfo;
    }

    static void setCurrentThreadInfo(ThreadInfo threadInfo) {
        current = threadInfo;
        if (current != null) {
            current.invalidate();
        }
    }

    List getStack() throws IncompatibleThreadStateException {
        return this.thread.frames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List threads() {
        List list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            return new ArrayList(threads);
        }
    }

    static ThreadInfo getThreadInfo(ThreadReference threadReference) {
        return ThreadInfo.getThreadInfo(threadReference.uniqueID());
    }

    static ThreadInfo getThreadInfo(String string) {
        ThreadInfo threadInfo = null;
        if (string.startsWith("t@")) {
            string = string.substring(2);
        }
        try {
            long l = Long.decode(string);
            threadInfo = ThreadInfo.getThreadInfo(l);
        }
        catch (NumberFormatException numberFormatException) {
            threadInfo = null;
        }
        return threadInfo;
    }
}

