/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.action.AllAction;
import latte.util.GuiUtil;
import latte.util.MsgUtil;
import latte.view.LVDiagFolder;
import latte.view.LVTree;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MainForm {
    private static Display display_ = new Display();
    private static Shell shell_ = new Shell(display_);
    private SashForm latteForm_ = null;
    private LVTree tree_ = null;
    private Text prop_ = null;
    private LVDiagFolder diagFolder_ = null;
    private EObject selectedModel_ = null;

    static {
        GuiUtil.init(display_, shell_);
        MsgUtil.init(display_, shell_);
    }

    public MainForm() {
        shell_.setText(AllAction.LATTE_MYSELF.getTitle());
        shell_.setImage(AllAction.LATTE_MYSELF.getImage());
        shell_.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AllAction.FILE_EXIT.execute(e);
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shell_.setLayout((Layout)layout);
        this.createMainMenuBar();
        this.createMainCoolBar();
        this.latteForm_ = new SashForm((Composite)shell_, 256);
        GridData gridData = new GridData(1808);
        this.latteForm_.setLayoutData((Object)gridData);
        Composite leftView = new Composite((Composite)this.latteForm_, 2048);
        leftView.setLayout((Layout)new FillLayout());
        SashForm leftSash = new SashForm(leftView, 512);
        this.tree_ = new LVTree((Composite)leftSash);
        this.prop_ = new Text((Composite)leftSash, 770);
        this.diagFolder_ = new LVDiagFolder((Composite)this.latteForm_);
        shell_.open();
    }

    public void init() {
        shell_.setText("Latte:");
        this.tree_.init();
        this.diagFolder_.init();
    }

    public EObject getSelectedModels() {
        return this.selectedModel_;
    }

    public void setSelectedModels(EObject model) {
        this.selectedModel_ = model;
        AllAction.updateActionState();
    }

    private void createMainCoolBar() {
        CoolBar coolbar = new CoolBar((Composite)shell_, 0);
        Control fileToolbar = this.createFileToolBar(coolbar);
        Control editToolbar = this.createEditToolBar(coolbar);
        Control addToolbar = this.createAddToolBar(coolbar);
        GuiUtil.createCoolItem(coolbar, fileToolbar);
        GuiUtil.createCoolItem(coolbar, editToolbar);
        GuiUtil.createCoolItem(coolbar, addToolbar);
    }

    private Control createFileToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar((Composite)coolbar, 0x800000);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.FILE_NEW);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.FILE_OPEN);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.FILE_SAVE);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.FILE_SAVEAS);
        new ToolItem(toolbar, 2);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.FILE_PRINT);
        return toolbar;
    }

    private Control createEditToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar((Composite)coolbar, 0x800000);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.EDIT_REMOVE);
        return toolbar;
    }

    private Control createAddToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar((Composite)coolbar, 0x800000);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_CLASS_DIAGRAM);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_SEQUENCE_DIAGRAM);
        new ToolItem(toolbar, 2);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_PACKAGE);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_CLASS);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_INTERFACE);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_METHOD);
        return toolbar;
    }

    private void createMainMenuBar() {
        Menu menubar = new Menu((Decorations)shell_, 2);
        shell_.setMenuBar(menubar);
        Menu fileMenu = GuiUtil.createMenu(menubar, "\u30d5\u30a1\u30a4\u30eb");
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_OPEN);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_SAVE);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_SAVEAS);
        new MenuItem(fileMenu, 2);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_PRINT);
        new MenuItem(fileMenu, 2);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_EXIT);
        Menu editMenu = GuiUtil.createMenu(menubar, "\u7de8\u96c6");
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_CUT);
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_COPY);
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_PASTE);
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_REMOVE);
        Menu addMenu = GuiUtil.createMenu(menubar, "\u8ffd\u52a0");
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_CLASS_DIAGRAM);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_SEQUENCE_DIAGRAM);
        new MenuItem(addMenu, 2);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_PACKAGE);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_CLASS);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_INTERFACE);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_METHOD);
        Menu toolMenu = GuiUtil.createMenu(menubar, "\u30c4\u30fc\u30eb");
        GuiUtil.createMenuItem(toolMenu, AllAction.TOOL_JAVA_REVERSE);
        Menu helpMenu = GuiUtil.createMenu(menubar, "\u30d8\u30eb\u30d7");
        GuiUtil.createMenuItem(helpMenu, AllAction.HELP_DOC);
        GuiUtil.createMenuItem(helpMenu, AllAction.HELP_VER);
    }

    public void setTitle(String title) {
        shell_.setText(title);
    }

    public void run() {
        while (!shell_.isDisposed()) {
            try {
                if (display_.readAndDispatch()) continue;
                display_.sleep();
            }
            catch (Exception e) {
                e.printStackTrace();
                MsgUtil.showMsg(e.getMessage());
            }
        }
        display_.dispose();
    }

    public Text getProp() {
        return this.prop_;
    }

    public LVTree getTree() {
        return this.tree_;
    }

    public LVDiagFolder getDiagFolder() {
        return this.diagFolder_;
    }

    public SashForm getLatteForm() {
        return this.latteForm_;
    }

    public void destroy() {
        shell_.dispose();
    }
}

