/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import latte.InternalLogicException;
import latte.Latte;
import latte.LatteData;
import latte.action.AbstractLatteAction;
import latte.action.AllAction;
import latte.di.Diagram;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.view.DragSourceEnabler;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;

public class LVTree
extends Composite
implements Adapter {
    private TreeItem selectedItem_ = null;
    private Tree tree_ = null;
    private TreeItem rootModelTreeItem_ = null;
    private TreeItem rootDiagTreeItem_ = null;
    private boolean sort_ = false;
    private boolean modelNotification_ = true;
    private TreeEditor treeEditor_ = null;
    private ItemEditor itemEditor_ = null;
    public static final String LATTE_DATA = "LATTE_DATA";
    private Image ATTRIBASSOC_IMAGE = null;
    private LVTreeSelectionListener selectionListener = new LVTreeSelectionListener();
    private LVTreeListener treeListener = new LVTreeListener();
    private LVKeyListener keyListener = new LVKeyListener();

    LVTree(Composite parent) {
        super(parent, 0);
        this.ATTRIBASSOC_IMAGE = this.createImage("images/attribassociation.gif");
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        ToolBar toolbar = new ToolBar((Composite)this, 0x800000);
        GuiUtil.createToolbarItem(toolbar, 32, new SortAction("\u30bd\u30fc\u30c8\u30e2\u30fc\u30c9", "images/sort.gif"), this.sort_);
        GuiUtil.createToolbarItem(toolbar, 8, new UpAction("\u4e0a\u3078", "images/up.gif"));
        GuiUtil.createToolbarItem(toolbar, 8, new DownAction("\u4e0b\u3078", "images/down.gif"));
        this.tree_ = new Tree((Composite)this, 0);
        GridLayout layout2 = new GridLayout();
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 1;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        this.tree_.setLayout((Layout)layout2);
        this.tree_.setLayoutData((Object)new GridData(1808));
        this.treeEditor_ = new TreeEditor(this.tree_);
        new DragSourceEnabler(this);
        this.createTreePopupMenu();
        this.enableUIListener(true);
    }

    public void init() {
        this.tree_.removeAll();
        LatteData latteData = Latte.getLatteData();
        Model model = latteData.getModel();
        this.rootModelTreeItem_ = new TreeItem(this.tree_, 0);
        this.rootModelTreeItem_.setText(model.getName());
        this.rootModelTreeItem_.setData(LATTE_DATA, (Object)model);
        this.rootModelTreeItem_.setImage(AllAction.ADD_PACKAGE.getImage());
        Diagram diagram = latteData.getDiagrams();
        this.rootDiagTreeItem_ = new TreeItem(this.tree_, 0);
        this.rootDiagTreeItem_.setText(diagram.getName());
        this.rootDiagTreeItem_.setData(LATTE_DATA, (Object)diagram);
        this.rootDiagTreeItem_.setImage(AllAction.ADD_PACKAGE.getImage());
        this.initState();
    }

    public void enableModelNotification(boolean enable) {
        this.modelNotification_ = enable;
    }

    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(String.valueOf(DebugUtil.getEventId((Object)this, notification)) + " ");
            System.out.print("LVTree notifyChanged:");
        }
        if (!this.modelNotification_) {
            if (Latte.TRACE_EVENT) {
                System.out.println("\u901a\u77e5\u7121\u52b9\u4e2d");
            }
            return;
        }
        if (Latte.TRACE_EVENT) {
            System.out.println(notification);
        }
        EObject notifier = (EObject)notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        Object feature = notification.getFeature();
        String name = feature instanceof EAttribute ? ((EAttribute)feature).getName() : null;
        boolean wasSet = notification.wasSet();
        block0 : switch (notification.getEventType()) {
            case 3: {
                this.doEventAdd(notifier, newValue);
                break;
            }
            case 1: {
                this.doEventSet(notifier, feature, newValue, name, wasSet);
                break;
            }
            case 4: {
                TreeItem removeTreeItem = null;
                block6 : switch (ModelUtil.getClassifierID(notifier)) {
                    case 10: 
                    case 16: 
                    case 60: 
                    case 84: {
                        switch (ModelUtil.getClassifierID(oldValue)) {
                            case 10: 
                            case 12: 
                            case 13: 
                            case 16: 
                            case 84: {
                                removeTreeItem = this.lookupTreeItem((EObject)oldValue);
                                removeTreeItem.dispose();
                                break block6;
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (ModelUtil.getClassifierID(oldValue) != 2) break block0;
                        removeTreeItem = this.lookupTreeItem((EObject)oldValue);
                        removeTreeItem.dispose();
                        break;
                    }
                    default: {
                        if (!Latte.TRACE_EVENT) break block0;
                        System.out.println("LVTree\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                        break;
                    }
                }
                break;
            }
            case 0: 
            case 8: {
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVTree\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            default: {
                throw new InternalLogicException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u901a\u77e5");
            }
        }
    }

    public TreeItem lookupTreeItem(EObject element) {
        TreeItem treeItem = null;
        if (this.rootModelTreeItem_.getData(LATTE_DATA) == element) {
            return this.rootModelTreeItem_;
        }
        if (this.rootDiagTreeItem_.getData(LATTE_DATA) == element) {
            return this.rootDiagTreeItem_;
        }
        treeItem = this.lookupTreeItemRecursive(this.rootModelTreeItem_.getItems(), element);
        if (treeItem != null) {
            return treeItem;
        }
        treeItem = this.lookupTreeItemRecursive(this.rootDiagTreeItem_.getItems(), element);
        if (treeItem != null) {
            return treeItem;
        }
        return null;
    }

    private void doEventAdd(EObject notifier, Object newValue) {
        int index = 0;
        TreeItem parentTreeitem = null;
        Object[] objs = null;
        block0 : switch (ModelUtil.getClassifierID(newValue)) {
            case 16: {
                Package p;
                parentTreeitem = this.lookupTreeItem((EObject)((Element)notifier));
                switch (ModelUtil.getClassifierID(notifier)) {
                    case 16: 
                    case 60: {
                        p = (Package)notifier;
                        objs = p.getOwnedMembers().toArray();
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                Package p;
                parentTreeitem = this.lookupTreeItem((EObject)((Element)notifier));
                switch (ModelUtil.getClassifierID(notifier)) {
                    case 16: 
                    case 60: {
                        p = (Package)notifier;
                        objs = p.getOwnedMembers().toArray();
                        break block0;
                    }
                    case 84: {
                        Interface i = (Interface)notifier;
                        objs = i.getNestedClassifiers().toArray();
                        break block0;
                    }
                    case 10: {
                        Class c = (Class)notifier;
                        objs = c.getNestedClassifiers().toArray();
                        break block0;
                    }
                }
                break;
            }
            case 84: {
                Package p;
                parentTreeitem = this.lookupTreeItem((EObject)((Element)notifier));
                switch (ModelUtil.getClassifierID(notifier)) {
                    case 16: 
                    case 60: {
                        p = (Package)notifier;
                        objs = p.getOwnedMembers().toArray();
                        break block0;
                    }
                    case 84: {
                        Interface i = (Interface)notifier;
                        objs = i.getNestedClassifiers().toArray();
                        break block0;
                    }
                    case 10: {
                        Class c = (Class)notifier;
                        objs = c.getNestedClassifiers().toArray();
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                Interface i;
                parentTreeitem = this.lookupTreeItem((EObject)((Element)notifier));
                switch (ModelUtil.getClassifierID(notifier)) {
                    case 84: {
                        i = (Interface)notifier;
                        index += i.getNestedClassifiers().size();
                        objs = i.getOwnedAttributes().toArray();
                        break block0;
                    }
                    case 10: {
                        Class c = (Class)notifier;
                        index += c.getNestedClassifiers().size();
                        objs = c.getOwnedAttributes().toArray();
                        break block0;
                    }
                    case 40: {
                        if (Latte.TRACE_EVENT) {
                            System.out.println("LVTree\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                        }
                        return;
                    }
                }
                break;
            }
            case 13: {
                Interface i;
                parentTreeitem = this.lookupTreeItem((EObject)((Element)notifier));
                switch (ModelUtil.getClassifierID(notifier)) {
                    case 84: {
                        i = (Interface)notifier;
                        index += i.getNestedClassifiers().size();
                        index += i.getOwnedAttributes().size();
                        objs = i.getOwnedOperations().toArray();
                        break block0;
                    }
                    case 10: {
                        Class c = (Class)notifier;
                        index += c.getNestedClassifiers().size();
                        index += c.getOwnedAttributes().size();
                        objs = c.getOwnedOperations().toArray();
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                parentTreeitem = this.rootDiagTreeItem_;
                objs = Latte.getLatteData().getDiagrams().getContained().toArray();
                break;
            }
            default: {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVTree\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
        }
        TreeItem newTreeItem = this.addItem(parentTreeitem, newValue, index += ModelUtil.getInsertIndex(objs, newValue, false) - 1);
        this.tree_.showItem(newTreeItem);
        this.setSelectionItem(newTreeItem);
        Latte.getMainForm().setSelectedModels((EObject)newValue);
        this.editItem(newTreeItem);
    }

    private void doEventSet(EObject notifier, Object feature, Object newValue, String name, boolean wasSet) {
        if (notifier instanceof Package || notifier instanceof Class || notifier instanceof Interface || notifier instanceof Property || notifier instanceof Operation || notifier instanceof Diagram) {
            if (!(feature instanceof EAttribute && name.equals("name") && wasSet)) {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVTree\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
        } else {
            if (Latte.TRACE_EVENT) {
                System.out.println("LVTree\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
            }
            return;
        }
        this.enableUIListener(false);
        TreeItem renamedTreeItem = this.lookupTreeItem(notifier);
        renamedTreeItem.setText((String)newValue);
        this.enableUIListener(true);
    }

    private TreeItem lookupTreeItemRecursive(TreeItem[] treeItems, EObject element) {
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i].getData(LATTE_DATA) == element) {
                return treeItems[i];
            }
            TreeItem treeItem = this.lookupTreeItemRecursive(treeItems[i].getItems(), element);
            if (treeItem != null) {
                return treeItem;
            }
            ++i;
        }
        return null;
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void syncTree() {
        this.init();
        this.createTree();
    }

    EObject getSelectedModels() {
        return (EObject)this.selectedItem_.getData(LATTE_DATA);
    }

    public void deselectAll() {
        this.tree_.deselectAll();
        this.selectedItem_ = null;
    }

    public void showItem(TreeItem item) {
        this.tree_.showItem(item);
    }

    Tree getTree() {
        return this.tree_;
    }

    public ItemEditor getItemEditor() {
        return this.itemEditor_;
    }

    public TreeItem getRootModelTreeItem() {
        return this.rootModelTreeItem_;
    }

    private void createTreePopupMenu() {
        Menu menu = new Menu((Control)this.tree_);
        this.tree_.setMenu(menu);
        GuiUtil.createMenuItem(menu, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createMenuItem(menu, AllAction.ADD_METHOD);
        GuiUtil.createMenuItem(menu, AllAction.ADD_CLASS);
        GuiUtil.createMenuItem(menu, AllAction.ADD_INTERFACE);
        GuiUtil.createMenuItem(menu, AllAction.ADD_PACKAGE);
        new MenuItem(menu, 2);
        GuiUtil.createMenuItem(menu, AllAction.ADD_CLASS_DIAGRAM);
        GuiUtil.createMenuItem(menu, AllAction.ADD_SEQUENCE_DIAGRAM);
        new MenuItem(menu, 2);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_REMOVE);
    }

    private void initState() {
    }

    public void setSelectionItem(TreeItem treeItem) {
        this.selectedItem_ = treeItem;
        this.tree_.setSelection(new TreeItem[]{treeItem});
    }

    private void sortTreeItems(TreeItem parent) {
        int TVM_SORTCHILDREN = 4371;
        TreeItem[] items = parent.getItems();
        int i = 0;
        while (i < items.length) {
            Object o = items[i].getData(LATTE_DATA);
            String pre = null;
            if (o instanceof Package) {
                pre = "0";
            } else if (o instanceof Interface) {
                pre = "1";
            } else if (o instanceof Class) {
                pre = "2";
            } else if (o instanceof Property) {
                pre = "3";
            } else if (o instanceof Operation) {
                pre = "4";
            } else if (o instanceof Diagram) {
                String diagType = ModelUtil.getDiagType((Diagram)o);
                if (diagType.equals("ClassDiagram")) {
                    pre = "5";
                } else if (diagType.equals("SequenceDiagram")) {
                    pre = "6";
                } else {
                    throw new InternalLogicException("\u30bd\u30fc\u30c8\u7528\u30d7\u30ec\u30d5\u30a3\u30c3\u30af\u30b9\u304c\u3064\u3044\u3066\u306a\u3044");
                }
                pre = "5";
            } else {
                throw new InternalLogicException("\u30bd\u30fc\u30c8\u7528\u30d7\u30ec\u30d5\u30a3\u30c3\u30af\u30b9\u304c\u3064\u3044\u3066\u306a\u3044");
            }
            items[i].setText(String.valueOf(pre) + items[i].getText());
            ++i;
        }
        OS.SendMessage((int)this.tree_.handle, (int)4371, (int)0, (int)parent.handle);
        items = parent.getItems();
        i = 0;
        while (i < items.length) {
            items[i].setText(items[i].getText().substring(1));
            ++i;
        }
    }

    private void unsortTreeItems(TreeItem parent) {
        int TVM_SORTCHILDREN = 4371;
        EObject parentEObject = (EObject)parent.getData(LATTE_DATA);
        BasicEList elist = new BasicEList();
        switch (ModelUtil.getClassifierID(parentEObject)) {
            case 16: 
            case 60: {
                Package p = (Package)parentEObject;
                elist.addAll((Collection)p.getOwnedMembers());
                break;
            }
            case 84: {
                Interface i = (Interface)parentEObject;
                elist.addAll((Collection)i.getNestedClassifiers());
                elist.addAll((Collection)i.getOwnedAttributes());
                elist.addAll((Collection)i.getOwnedOperations());
                break;
            }
            case 10: {
                Class c = (Class)parentEObject;
                elist.addAll((Collection)c.getNestedClassifiers());
                elist.addAll((Collection)c.getOwnedAttributes());
                elist.addAll((Collection)c.getOwnedOperations());
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                Diagram d = (Diagram)parentEObject;
                elist = d.getContained();
                break;
            }
            default: {
                throw new InternalLogicException("\u30bd\u30fc\u30c8\u89e3\u9664\u7528\u30d7\u30ec\u30d5\u30a3\u30c3\u30af\u30b9\u304c\u3064\u3044\u3066\u306a\u3044");
            }
        }
        TreeItem[] items = parent.getItems();
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        int i = 0;
        while (i < items.length) {
            Object o = items[i].getData(LATTE_DATA);
            int index = elist.indexOf(o);
            String pre = decimalFormat.format(index);
            items[i].setText(String.valueOf(pre) + items[i].getText());
            ++i;
        }
        OS.SendMessage((int)this.tree_.handle, (int)4371, (int)0, (int)parent.handle);
        items = parent.getItems();
        i = 0;
        while (i < items.length) {
            items[i].setText(items[i].getText().substring(4));
            ++i;
        }
    }

    private void enableUIListener(boolean enable) {
        if (enable) {
            this.tree_.addSelectionListener((SelectionListener)this.selectionListener);
            this.tree_.addTreeListener((TreeListener)this.treeListener);
            this.tree_.addKeyListener((KeyListener)this.keyListener);
        } else {
            this.tree_.removeSelectionListener((SelectionListener)this.selectionListener);
            this.tree_.removeTreeListener((TreeListener)this.treeListener);
            this.tree_.removeKeyListener((KeyListener)this.keyListener);
        }
    }

    private void createTree() {
        TreeItem treeItem = Latte.getMainForm().getTree().rootModelTreeItem_;
        Iterator i = Latte.getLatteData().getModel().getOwnedMembers().iterator();
        while (i.hasNext()) {
            this.createModelTree(treeItem, (EObject)i.next());
        }
        this.createDiagTree();
        this.initState();
    }

    private void createModelTree(TreeItem parentTreeItem, EObject eobject) {
        EList list = new ArrayList();
        ArrayList<Classifier> interfaceList = new ArrayList<Classifier>();
        ArrayList<Classifier> classList = new ArrayList<Classifier>();
        Iterator i = null;
        TreeItem newTreeItem = this.addItem(parentTreeItem, eobject, -1);
        if (newTreeItem == null) {
            return;
        }
        switch (ModelUtil.getClassifierID(eobject)) {
            case 16: {
                Package p = (Package)eobject;
                list = p.getOwnedMembers();
                break;
            }
            case 10: {
                Class c = (Class)eobject;
                i = c.getNestedClassifiers().iterator();
                while (i.hasNext()) {
                    Classifier nestedClassifier = (Classifier)i.next();
                    if (nestedClassifier instanceof Interface) {
                        interfaceList.add(nestedClassifier);
                        continue;
                    }
                    classList.add(nestedClassifier);
                }
                list.addAll(interfaceList);
                list.addAll(classList);
                list.addAll(c.getOwnedAttributes());
                list.addAll(c.getOwnedOperations());
                break;
            }
            case 84: {
                Interface intf = (Interface)eobject;
                i = intf.getNestedClassifiers().iterator();
                while (i.hasNext()) {
                    Classifier nestedClassifier = (Classifier)i.next();
                    if (nestedClassifier instanceof Interface) {
                        interfaceList.add(nestedClassifier);
                        continue;
                    }
                    classList.add(nestedClassifier);
                }
                list.addAll(interfaceList);
                list.addAll(classList);
                list.addAll(intf.getOwnedAttributes());
                list.addAll(intf.getOwnedOperations());
                break;
            }
            case 12: 
            case 13: 
            case 36: 
            case 40: 
            case 51: 
            case 85: {
                break;
            }
            default: {
                throw new InternalLogicException("TreeItem\u4f5c\u6210\u5931\u6557 : " + eobject);
            }
        }
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            this.createModelTree(newTreeItem, (EObject)ite.next());
        }
    }

    private void createDiagTree() {
        Diagram d = Latte.getLatteData().getDiagrams();
        EList el = d.getContained();
        Iterator i = el.iterator();
        while (i.hasNext()) {
            Diagram diag = (Diagram)i.next();
            TreeItem treeItem = this.addItem(this.rootDiagTreeItem_, diag, -1);
            treeItem.setText(diag.getName());
            treeItem.setData(LATTE_DATA, (Object)diag);
            String diagType = ModelUtil.getDiagType(diag);
            if (diagType.equals("ClassDiagram")) {
                treeItem.setImage(AllAction.ADD_CLASS_DIAGRAM.getImage());
                continue;
            }
            if (!diagType.equals("SequenceDiagram")) continue;
            treeItem.setImage(AllAction.ADD_SEQUENCE_DIAGRAM.getImage());
        }
    }

    private TreeItem addItem(TreeItem parentTreeItem, Object newDef, int index) {
        String name = null;
        Image image = null;
        switch (ModelUtil.getClassifierID(newDef)) {
            case 13: {
                name = ((Operation)newDef).getName();
                image = AllAction.SHOW_METHOD.getImage();
                break;
            }
            case 12: {
                Property p = (Property)newDef;
                name = p.getName();
                if (p.getAssociation() == null) {
                    image = AllAction.SHOW_ATTRIBUTE.getImage();
                    break;
                }
                image = this.ATTRIBASSOC_IMAGE;
                break;
            }
            case 10: {
                name = ((Class)newDef).getName();
                image = AllAction.ADD_CLASS.getImage();
                break;
            }
            case 84: {
                name = ((Interface)newDef).getName();
                image = AllAction.ADD_INTERFACE.getImage();
                break;
            }
            case 16: {
                name = ((Package)newDef).getName();
                image = AllAction.ADD_PACKAGE.getImage();
                break;
            }
            case 40: 
            case 51: {
                return null;
            }
            case 2: {
                Diagram d = (Diagram)newDef;
                name = d.getName();
                String diagType = ModelUtil.getDiagType(d);
                if (diagType.equals("ClassDiagram")) {
                    image = AllAction.ADD_CLASS_DIAGRAM.getImage();
                    break;
                }
                if (!diagType.equals("SequenceDiagram")) break;
                image = AllAction.ADD_SEQUENCE_DIAGRAM.getImage();
                break;
            }
            default: {
                throw new InternalLogicException("\u8003\u616e\u3082\u308c");
            }
        }
        TreeItem item = null;
        item = index >= 0 ? new TreeItem(parentTreeItem, 0, index) : new TreeItem(parentTreeItem, 0);
        item.setData(LATTE_DATA, newDef);
        item.setText(name);
        item.setImage(image);
        return item;
    }

    private void editItem(TreeItem item) {
        Control c = this.treeEditor_.getEditor();
        if (c != null) {
            c.dispose();
        }
        this.treeEditor_.horizontalAlignment = 16384;
        this.treeEditor_.grabHorizontal = true;
        this.treeEditor_.minimumWidth = 50;
        this.itemEditor_ = new ItemEditor(this, this.treeEditor_, item);
        this.treeEditor_.setEditor((Control)this.itemEditor_, item);
        this.itemEditor_.setFocus();
    }

    private Image createImage(String fileName) {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        return GuiUtil.createImage(is);
    }

    class ItemEditor
    extends Composite {
        LVTree latteTree_ = null;
        TreeItem treeItem_ = null;
        Text text_ = new Text((Composite)this, 0);

        ItemEditor(LVTree latteTree, TreeEditor treeEditor, TreeItem treeItem) {
            super((Composite)LVTree.this.tree_, 0);
            this.latteTree_ = latteTree;
            LVTree.this.treeEditor_ = treeEditor;
            this.treeItem_ = treeItem;
            this.text_.setText(this.treeItem_.getText());
            this.text_.selectAll();
            this.text_.addFocusListener(new FocusListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void focusLost(FocusEvent e) {
                    ItemEditor.access$0(this.this$1);
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.text_.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void keyTraversed(TraverseEvent te) {
                    switch (te.detail) {
                        case 2: {
                            this.this$1.roolback();
                            te.doit = false;
                            break;
                        }
                        case 4: {
                            ItemEditor.access$0(this.this$1);
                            te.doit = true;
                        }
                    }
                }
            });
            this.addListener(11, new Listener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void handleEvent(Event e) {
                    Rectangle rect = this.this$1.getClientArea();
                    this.this$1.text_.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                }
            });
            this.treeItem_.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.this$1.roolback();
                }
            });
        }

        private void commit() {
            String newName = this.text_.getText();
            Object o = this.treeItem_.getData(LVTree.LATTE_DATA);
            this.closeItemEditor();
            AllAction.EDIT_RENAME.execute(new Object[]{o, newName});
        }

        public void roolback() {
            this.closeItemEditor();
        }

        private void closeItemEditor() {
            this.dispose();
            LVTree.this.treeEditor_.setEditor(null);
        }

        static /* synthetic */ void access$0(ItemEditor itemEditor) {
            itemEditor.commit();
        }
    }

    class LVTreeSelectionListener
    implements SelectionListener {
        private long lastSelectTime_ = 0L;

        LVTreeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            long curTime = System.currentTimeMillis();
            if ((TreeItem)e.item == LVTree.this.selectedItem_ && curTime - this.lastSelectTime_ < 1000L) {
                LVTree.this.editItem(LVTree.this.selectedItem_);
            }
            LVTree.this.selectedItem_ = (TreeItem)e.item;
            EObject o = (EObject)LVTree.this.selectedItem_.getData(LVTree.LATTE_DATA);
            Latte.getMainForm().setSelectedModels(o);
            this.lastSelectTime_ = curTime;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            try {
                EObject o = LVTree.this.getSelectedModels();
                if (ModelUtil.getClassifierID(o) == 2 && o != Latte.getLatteData().getDiagrams()) {
                    Latte.getMainForm().getDiagFolder().showDiag((Diagram)o);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MsgUtil.showMsg("\u30a8\u30e9\u30fc\u767a\u751f\uff1a" + ex.getMessage());
            }
        }
    }

    class LVKeyListener
    implements KeyListener {
        LVKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x100000B && LVTree.this.selectedItem_ != null) {
                LVTree.this.editItem(LVTree.this.selectedItem_);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    class LVTreeListener
    implements TreeListener {
        LVTreeListener() {
        }

        public void treeCollapsed(TreeEvent e) {
        }

        public void treeExpanded(TreeEvent e) {
        }
    }

    class SortAction
    extends AbstractLatteAction {
        public SortAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            if (LVTree.this.sort_) {
                LVTree.this.sort_ = false;
            } else {
                LVTree.this.sort_ = true;
            }
            GuiUtil.setWaitMouseCursor();
            if (LVTree.this.sort_) {
                this.sortTreeItemRecursive(LVTree.this.rootModelTreeItem_);
                this.sortTreeItemRecursive(LVTree.this.rootDiagTreeItem_);
            } else {
                this.unsortTreeItemRecursive(LVTree.this.rootModelTreeItem_);
                this.unsortTreeItemRecursive(LVTree.this.rootDiagTreeItem_);
            }
            GuiUtil.setNormalMouseCursor();
        }

        private void sortTreeItemRecursive(TreeItem treeItem) {
            LVTree.this.sortTreeItems(treeItem);
            TreeItem[] treeItems = treeItem.getItems();
            int i = 0;
            while (i < treeItems.length) {
                this.sortTreeItemRecursive(treeItems[i]);
                ++i;
            }
        }

        private void unsortTreeItemRecursive(TreeItem treeItem) {
            LVTree.this.unsortTreeItems(treeItem);
            TreeItem[] treeItems = treeItem.getItems();
            int i = 0;
            while (i < treeItems.length) {
                this.unsortTreeItemRecursive(treeItems[i]);
                ++i;
            }
        }
    }

    class UpAction
    extends AbstractLatteAction {
        public UpAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            MsgUtil.showMsg("\u672a\u5b9f\u88c5");
        }
    }

    class DownAction
    extends AbstractLatteAction {
        public DownAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            MsgUtil.showMsg("\u672a\u5b9f\u88c5");
        }
    }
}

