/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.Diagram;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.ModelUtil;
import latte.view.DropTargetEnabler;
import latte.view.LVClassDiag;
import latte.view.LVDiag;
import latte.view.LVSeqDiag;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LVDiagFolder
implements CTabFolderListener,
Adapter {
    private CTabFolder tabFolder_ = null;
    public static final String LATTE_DATA = "LATTE_DATA";

    public LVDiagFolder(Composite parent) {
        this.tabFolder_ = new CTabFolder(parent, 0x800800);
        this.tabFolder_.addCTabFolderListener((CTabFolderListener)this);
        this.tabFolder_.setSelectionBackground(new Color[]{GuiUtil.getColor(31), GuiUtil.getColor(32), GuiUtil.getColor(22)}, new int[]{50, 100});
        this.tabFolder_.setSelectionForeground(GuiUtil.getColor(1));
        new DropTargetEnabler(this, (Control)this.tabFolder_);
    }

    public void init() {
        this.removeAllDiag();
    }

    public void showDiag(Diagram diag) {
        CTabItem item = this.lookupTabItem(diag);
        if (item != null) {
            this.tabFolder_.setSelection(item);
        } else {
            this.createDiag(diag);
        }
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder_;
    }

    public LVDiag getSelectedDiag() {
        CTabItem item = this.tabFolder_.getSelection();
        if (item == null) {
            return null;
        }
        return (LVDiag)((Object)item.getData(LATTE_DATA));
    }

    public void itemClosed(CTabFolderEvent event) {
    }

    public void notifyChanged(Notification notification) {
        LVDiag lvDiag;
        if (Latte.TRACE_EVENT) {
            System.out.print(String.valueOf(DebugUtil.getEventId(this, notification)) + " ");
            System.out.println("LVDiagFolder notifyChanged:" + notification);
        }
        if ((lvDiag = this.lookupLVDiag(notification)) == null) {
            if (Latte.TRACE_EVENT) {
                System.out.println("\u975e\u8868\u793a\u4e2d\u306a\u306e\u3067\u623b\u308b");
            }
            return;
        }
        Object feature = notification.getFeature();
        Object notifier = notification.getNotifier();
        String name = feature instanceof EAttribute ? ((EAttribute)feature).getName() : null;
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        boolean wasSet = notification.wasSet();
        switch (notification.getEventType()) {
            case 3: {
                if (!(newValue instanceof Diagram) && (newValue instanceof GraphNode || newValue instanceof GraphEdge)) {
                    if (Latte.TRACE_EVENT) {
                        System.out.println("LVDiagFolder\u304b\u3089\u8ee2\u9001\u3059\u308b");
                    }
                    lvDiag.notifyChanged(notification);
                    break;
                }
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolder\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 1: {
                if (notifier instanceof Diagram && feature instanceof EAttribute && name.equals("name") && wasSet) {
                    Diagram diagram = (Diagram)notifier;
                    CTabItem tabItem = this.lookupTabItem(diagram);
                    if (tabItem == null) break;
                    tabItem.setText(diagram.getName());
                    break;
                }
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolder\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 4: {
                if (notifier instanceof Diagram && oldValue instanceof Diagram) {
                    CTabItem cTabItem = this.lookupTabItem((Diagram)oldValue);
                    if (cTabItem == null) break;
                    cTabItem.getControl().dispose();
                    cTabItem.dispose();
                    break;
                }
                if (notifier instanceof Diagram && (oldValue instanceof GraphNode || oldValue instanceof GraphEdge)) {
                    if (Latte.TRACE_EVENT) {
                        System.out.println("LVDiagFolder\u304b\u3089\u8ee2\u9001\u3059\u308b");
                    }
                    lvDiag.notifyChanged(notification);
                    break;
                }
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolder\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 8: {
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVDiagFolder\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            default: {
                throw new InternalLogicException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u901a\u77e5");
            }
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    private void createDiag(Diagram diag) {
        LVDiag lvDiag = null;
        String diagType = ModelUtil.getDiagType(diag);
        if (diagType.equals("ClassDiagram")) {
            lvDiag = new LVClassDiag(diag);
        } else if (diagType.equals("SequenceDiagram")) {
            lvDiag = new LVSeqDiag(diag);
        } else {
            throw new IllegalStateException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u56f3\u3067\u3059\u3002\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        this.tabFolder_.setSelection(lvDiag.getTabItem());
    }

    private CTabItem lookupTabItem(Diagram diag) {
        CTabItem[] items = this.tabFolder_.getItems();
        int i = 0;
        while (i < items.length) {
            LVDiag lvDiag = (LVDiag)((Object)items[i].getData(LATTE_DATA));
            if (diag == lvDiag.getDiagram()) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private LVDiag lookupLVDiag(Notification notification) {
        LVDiag lvDiag = null;
        Object o = notification.getNotifier();
        block0 : switch (ModelUtil.getClassifierID(o)) {
            case 2: {
                Diagram diagram = (Diagram)o;
                CTabItem[] items = this.tabFolder_.getItems();
                int i = 0;
                while (i < items.length) {
                    LVDiag d = (LVDiag)((Object)items[i].getData(LATTE_DATA));
                    if (d.getDiagram() == diagram) {
                        lvDiag = d;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
        return lvDiag;
    }

    private void removeAllDiag() {
        CTabItem[] items = this.tabFolder_.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].getControl().dispose();
            items[i].dispose();
            ++i;
        }
    }
}

