/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.List;
import latte.InternalLogicException;
import latte.Latte;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.ModelUtil;
import latte.view.LVConst;
import latte.view.LVDiag;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public abstract class LVDiagFigure
extends Figure
implements Adapter {
    protected LVDiag lvDiag_ = null;
    protected GraphNode graphNode_ = null;
    protected static Font BOLD = GuiUtil.getBoldFont();
    protected static Font ITALICBOLD = GuiUtil.getItalicBoldFont();
    protected static Font ITALIC = GuiUtil.getItalicFont();

    public LVDiagFigure(LVDiag lvDiag, GraphNode graphNode) {
        this.lvDiag_ = lvDiag;
        this.graphNode_ = graphNode;
        SchemeBorder sb = new SchemeBorder(SchemeBorder.SCHEMES.ETCHED);
        this.setBorder((Border)sb);
        this.setOpaque(true);
        this.setForegroundColor(LVConst.ForeColor);
        this.setBackgroundColor(this.getBackgroundColor());
        this.setLocation(ModelUtil.getLocation(this.graphNode_, new Point(0, 0)));
    }

    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(String.valueOf(DebugUtil.getEventId((Object)this, notification)) + " ");
            System.out.println("LVDiagFigure notifyChanged:" + notification);
        }
        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 1: {
                if (notifier instanceof GraphNode && newValue instanceof latte.di.Point) {
                    Point p = ((Viewport)this.getParent().getParent()).getViewLocation();
                    this.setLocation(ModelUtil.getLocation(this.graphNode_, new Point(-p.x, -p.y)));
                    break;
                }
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 4: {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 0: 
            case 8: {
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVDiagFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            default: {
                throw new InternalLogicException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u901a\u77e5");
            }
        }
    }

    public void setSelectedBackgroundColor() {
        this.setBackgroundColor(LVConst.SelectedBackColor);
    }

    public void setNormalBackgroundColor() {
        this.setBackgroundColor(this.getBackgroundColor());
    }

    public void setConstraint() {
        Point p = this.getBounds().getLocation();
        Rectangle rect = new Rectangle(p.x, p.y, -1, -1);
        this.getParent().getLayoutManager().setConstraint((IFigure)this, (Object)rect);
    }

    public GraphNode getGraphNode() {
        return this.graphNode_;
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public Color getBackgroundColor() {
        return LVConst.ClassBackColor;
    }

    protected void setStereoType(String stereoType) {
        Object o;
        List l = this.getChildren();
        if (l.size() > 0 && (o = l.get(0)) instanceof StereoType) {
            this.remove((IFigure)((StereoType)((Object)o)));
        }
        StereoType streoType = new StereoType("<< " + stereoType + " >>");
        streoType.setFont(BOLD);
        this.add((IFigure)streoType, 0);
    }

    public LVDiag getLvDiag() {
        return this.lvDiag_;
    }

    class StereoType
    extends Label {
        StereoType(String s) {
            super(s);
        }
    }
}

