/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.Iterator;
import latte.InternalLogicException;
import latte.Latte;
import latte.di.Diagram;
import latte.di.GraphNode;
import latte.view.LVClassDiagFigure;
import latte.view.LVConst;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.SimpleLoweredBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class LVDiag
extends AdapterImpl {
    private Diagram diagram_ = null;
    private CTabItem tabItem_ = null;
    private Canvas swtView_ = null;
    private Figure draw2dView_ = null;
    public static final int MODE_SELECTION = 1;
    public static final int MODE_ASSOCIATION = 2;
    public static final int MODE_GENELIZATION = 3;
    public static final int MODE_IMPLEMENTATION = 4;
    public static final int MODE_DEPENDENCY = 5;
    public static final int MODE_NOTELINK = 6;
    private static final int SIZE_X = 2048;
    private static final int SIZE_Y = 2048;
    private int mode_ = 1;
    private static final int PAGE_DELTA = 50;
    public static final String TYPE_CLASS_DIAG = "ClassDiagram";
    public static final String TYPE_SEQ_DIAG = "SequenceDiagram";
    public static final String TOOL_NAME = "Latte ver1";

    protected LVDiag(Diagram diag) {
        this.diagram_ = diag;
        CTabFolder tabFolder = Latte.getMainForm().getDiagFolder().getTabFolder();
        this.tabItem_ = new CTabItem(tabFolder, 0);
        this.tabItem_.setText(diag.getName());
        this.tabItem_.setImage(this.getTabImage());
        this.tabItem_.setControl(this.createTabItemControl((Composite)tabFolder));
        this.tabItem_.setData("LATTE_DATA", (Object)this);
    }

    public LVDiagFigure lookupFigure(GraphNode graphNode) {
        Iterator i = this.getDraw2dView().getChildren().iterator();
        while (i.hasNext()) {
            LVClassDiagFigure f;
            GraphNode ge;
            Object o = i.next();
            if (!(o instanceof LVDiagFigure) || (ge = (f = (LVClassDiagFigure)((Object)o)).getGraphNode()) != graphNode) continue;
            return f;
        }
        throw new InternalLogicException("\u767a\u898b\u3067\u304d\u308b\u306f\u305a\u306a\u306e\u306b\u767a\u898b\u3067\u304d\u306a\u3044");
    }

    public int getMode() {
        return this.mode_;
    }

    public void setMode(int mode) {
        this.mode_ = mode;
    }

    public Diagram getDiagram() {
        return this.diagram_;
    }

    public CTabItem getTabItem() {
        return this.tabItem_;
    }

    public Figure getDraw2dView() {
        return this.draw2dView_;
    }

    public Canvas getSwtView() {
        return this.swtView_;
    }

    public abstract void notifyChanged(Notification var1);

    protected abstract Image getTabImage();

    protected abstract void createDiagModeBar(Composite var1);

    private Control createTabItemControl(Composite tabFolder) {
        Composite tabItemControl = new Composite(tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tabItemControl.setLayout((Layout)layout);
        this.createDiagModeBar(tabItemControl);
        this.createDiagContentBase(tabItemControl);
        return tabItemControl;
    }

    private void createDiagContentBase(Composite parent) {
        this.draw2dView_ = new Figure();
        this.draw2dView_.setBackgroundColor(LVConst.diagColor_);
        this.draw2dView_.setOpaque(true);
        this.draw2dView_.setPreferredSize(new Dimension(2048, 2048));
        this.draw2dView_.setLayoutManager((LayoutManager)new FreeformLayout());
        this.draw2dView_.setLayoutManager((LayoutManager)new LatteXYLayout());
        final ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContents((IFigure)this.draw2dView_);
        scrollPane.setBorder((Border)new SimpleLoweredBorder());
        LightweightSystem lws = new LightweightSystem();
        lws.setContents((IFigure)scrollPane);
        this.swtView_ = new Canvas(parent, 768);
        this.swtView_.getVerticalBar().setVisible(false);
        this.swtView_.getHorizontalBar().setVisible(false);
        this.swtView_.setLayoutData((Object)new GridData(1808));
        this.swtView_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                LVDiag.this.scrollVerticalDraw2dView(scrollPane, e.keyCode);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.swtView_.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LVDiag.this.scrollVerticalDraw2dView(scrollPane, e.detail);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.swtView_.getHorizontalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LVDiag.this.scrollHorizontalDraw2dView(scrollPane, e.detail);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        lws.setControl(this.swtView_);
    }

    private void scrollVerticalDraw2dView(ScrollPane scrollPane, int event) {
        switch (event) {
            case 0x1000001: 
            case 0x1000005: {
                int y = scrollPane.getViewport().getViewLocation().y - 50;
                scrollPane.scrollVerticalTo(y);
                break;
            }
            case 0x1000002: 
            case 0x1000006: {
                int y = scrollPane.getViewport().getViewLocation().y + 50;
                scrollPane.scrollVerticalTo(y);
            }
        }
    }

    private void scrollHorizontalDraw2dView(ScrollPane scrollPane, int event) {
        switch (event) {
            case 0x1000001: 
            case 0x1000005: {
                int x = scrollPane.getViewport().getViewLocation().x - 50;
                scrollPane.scrollHorizontalTo(x);
                break;
            }
            case 0x1000002: 
            case 0x1000006: {
                int x = scrollPane.getViewport().getViewLocation().x + 50;
                scrollPane.scrollHorizontalTo(x);
            }
        }
    }

    class LatteXYLayout
    extends XYLayout {
        LatteXYLayout() {
        }

        public Point getOrigin(IFigure parent) {
            return parent.getClientArea().getLocation().translate(-2, -2);
        }
    }
}

