/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.action.AllAction;
import latte.di.GraphNode;
import latte.util.ModelUtil;
import latte.view.LVClassDiag;
import latte.view.LVClassDiagCommentFigure;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.widgets.Menu;

public abstract class LVClassDiagFigure
extends LVDiagFigure {
    public LVClassDiagFigure(LVClassDiag lvClassDiag, GraphNode graphNode) {
        super(lvClassDiag, graphNode);
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.addMouseListener(new ClassDiagFigureMouseListener(this));
        this.addMouseMotionListener(new ClassDiagFigureMouseMotionListener(this));
    }

    protected static class CompartmentFigure
    extends Figure {
        public CompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout();
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(1);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new CompartmentFigureBorder());
        }

        public class CompartmentFigureBorder
        extends AbstractBorder {
            public Insets getInsets(IFigure figure) {
                return new Insets(1, 0, 1, 0);
            }

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                graphics.drawLine(AbstractBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), AbstractBorder.tempRect.getTopRight());
            }
        }
    }

    class ClassDiagFigureMouseListener
    implements MouseListener {
        private LVClassDiagFigure figure_ = null;

        ClassDiagFigureMouseListener(LVClassDiagFigure figure) {
            this.figure_ = figure;
        }

        public void mousePressed(MouseEvent me) {
            LVClassDiag lvClassDiag = (LVClassDiag)this.figure_.getLvDiag();
            GraphNode selectedGraphNode = this.figure_.getGraphNode();
            Menu menu = null;
            switch (ModelUtil.getClassifierID(ModelUtil.getElement(selectedGraphNode))) {
                case 10: 
                case 84: {
                    boolean attributeVisible = ModelUtil.isAttributeVisible(selectedGraphNode);
                    boolean methodVisible = ModelUtil.isMethodVisible(selectedGraphNode);
                    lvClassDiag.POPUPMENU_CLASS_FIG.showAttributeMenuItem_.setSelection(attributeVisible);
                    lvClassDiag.POPUPMENU_CLASS_FIG.showMethodMenuItem_.setSelection(methodVisible);
                    menu = lvClassDiag.POPUPMENU_CLASS_FIG.menu_;
                    break;
                }
                case 7: {
                    menu = lvClassDiag.POPUPMENU_COMMENT;
                    break;
                }
                default: {
                    menu = lvClassDiag.POPUPMENU_NORMAL;
                }
            }
            lvClassDiag.setPopupMenu(menu);
            this.figure_.getParent().handleMousePressed(me);
            this.figure_.setSelectedBackgroundColor();
            Latte.getMainForm().setSelectedModels(selectedGraphNode);
            switch (lvClassDiag.getMode()) {
                case 1: {
                    lvClassDiag.getDraw2dView().remove((IFigure)this.figure_);
                    lvClassDiag.getDraw2dView().add((IFigure)this.figure_);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ((LVClassDiag)LVClassDiagFigure.this.getLvDiag()).getAddingLine().start(this.figure_, me.getLocation());
                    break;
                }
                default: {
                    throw new InternalLogicException("mousePressed()\u8003\u616e\u6f0f\u308c");
                }
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.figure_.getParent().handleMouseReleased(me);
            ((LVClassDiag)LVClassDiagFigure.this.getLvDiag()).getAddingLine().end();
        }

        public void mouseDoubleClicked(MouseEvent me) {
            this.figure_.getParent().handleMouseDoubleClicked(me);
            if (me.getSource() instanceof LVClassDiagCommentFigure) {
                AllAction.EDIT_NOTE.execMain(null);
            }
        }
    }

    class ClassDiagFigureMouseMotionListener
    implements MouseMotionListener {
        private LVClassDiagFigure figure_ = null;

        ClassDiagFigureMouseMotionListener(LVClassDiagFigure figure) {
            this.figure_ = figure;
        }

        public void mouseDragged(MouseEvent me) {
            this.figure_.getParent().handleMouseDragged(me);
        }

        public void mouseMoved(MouseEvent me) {
            this.figure_.getParent().handleMouseMoved(me);
        }

        public void mouseEntered(MouseEvent me) {
            this.figure_.getParent().handleMouseEntered(me);
            if (((LVClassDiag)LVClassDiagFigure.this.getLvDiag()).getAddingLine().isToFigCandidate(this.figure_)) {
                ((LVClassDiag)LVClassDiagFigure.this.getLvDiag()).getAddingLine().setToFig(this.figure_);
                this.figure_.setSelectedBackgroundColor();
            }
        }

        public void mouseExited(MouseEvent me) {
            this.figure_.getParent().handleMouseExited(me);
            if (((LVClassDiag)LVClassDiagFigure.this.getLvDiag()).getAddingLine().isToFigCandidate(this.figure_)) {
                ((LVClassDiag)LVClassDiagFigure.this.getLvDiag()).getAddingLine().setToFig(null);
                this.figure_.setNormalBackgroundColor();
            }
        }

        public void mouseHover(MouseEvent me) {
            this.figure_.getParent().handleMouseHover(me);
        }
    }
}

