/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.view.LVClassDiag;
import latte.view.LVConst;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Element;

public abstract class LVClassDiagConnection
extends PolylineConnection
implements Adapter {
    protected LVClassDiag parent_ = null;
    private GraphEdge graphEdge_ = null;
    public static final int WIDTH_NORMAL = 1;
    public static final int WIDTH_SELECTED = 2;

    public LVClassDiagConnection(LVClassDiag parent, GraphEdge graphEdge) {
        this.parent_ = parent;
        this.graphEdge_ = graphEdge;
        this.setForegroundColor(LVConst.ForeColor);
        this.setupConnectionStyle();
        this.addMouseListener(new ClassDiagConnectionMouseListener(this));
        this.addMouseMotionListener(new ClassDiagConnectionMouseMotionListener(this));
    }

    ConnectionAnchor createSourceConnectionAnchor() {
        LVDiagFigure fig = this.getLVDiagFigure(ModelUtil.getFromGraphConnector(this.getGraphEdge()));
        if (fig == null) {
            throw new IllegalStateException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u7aef\u306f\u56f3\u306e\u8981\u7d20\u306b\u542b\u307e\u308c\u307e\u305b\u3093");
        }
        return new ChopboxAnchor((IFigure)fig);
    }

    ConnectionAnchor createTargetConnectionAnchor() {
        LVDiagFigure fig = this.getLVDiagFigure(ModelUtil.getToGraphConnector(this.getGraphEdge()));
        if (fig == null) {
            throw new IllegalStateException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u7aef\u306f\u56f3\u306e\u8981\u7d20\u306b\u542b\u307e\u308c\u307e\u305b\u3093");
        }
        return new ChopboxAnchor((IFigure)fig);
    }

    protected void setupConnectionStyle() {
        this.setSourceAnchor(this.createSourceConnectionAnchor());
        this.setTargetAnchor(this.createTargetConnectionAnchor());
        this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
    }

    public void createConstraint() {
    }

    public void updateConnection() {
        LogUtil.writeln("LVClassDiagConnection.updateConnection()");
        this.setupConnectionStyle();
        this.repaint();
    }

    public GraphEdge getGraphEdge() {
        return this.graphEdge_;
    }

    public Element getElement() {
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)this.graphEdge_.getSemanticModel();
        return b.getElement();
    }

    public LVDiagFigure getLVDiagFigure(GraphConnector graphConnector) {
        GraphNode graphNode = (GraphNode)graphConnector.getGraphElement();
        LVDiagFigure fig = this.parent_.lookupFigure(graphNode);
        return fig;
    }

    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(String.valueOf(DebugUtil.getEventId((Object)this, notification)) + " ");
            System.out.println("LVClassDiagConnection notifyChanged:" + notification);
        }
        int eventType = notification.getEventType();
        EObject notifier = (EObject)notification.getNotifier();
        switch (eventType) {
            case 1: {
                if (ModelUtil.getClassifierID(notifier) == 12) {
                    this.setupConnectionStyle();
                    break;
                }
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVClassDiagConnection\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            case 6: 
            case 8: {
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVClassDiag\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            default: {
                throw new InternalLogicException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u901a\u77e5");
            }
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    static class ClassDiagConnectionMouseListener
    implements MouseListener {
        private LVClassDiagConnection conn_ = null;

        ClassDiagConnectionMouseListener(LVClassDiagConnection conn) {
            this.conn_ = conn;
        }

        public void mousePressed(MouseEvent me) {
            LogUtil.writeln("ClassDiagConnectionMouseListener.mousePressed()");
            Menu menu = null;
            switch (ModelUtil.getClassifierID(this.conn_.getElement())) {
                case 40: {
                    GraphEdge graphEdge = this.conn_.getGraphEdge();
                    boolean navigable = ModelUtil.isNavigable(graphEdge);
                    this.conn_.parent_.POPUPMENU_ASSOCIATION.navigatableMenuItem_.setSelection(navigable);
                    this.conn_.parent_.POPUPMENU_ASSOCIATION.aggregationNone_.setSelection(false);
                    this.conn_.parent_.POPUPMENU_ASSOCIATION.aggregationShare_.setSelection(false);
                    this.conn_.parent_.POPUPMENU_ASSOCIATION.aggregationComposite_.setSelection(false);
                    AggregationKind ak = ModelUtil.getAggregationKind(graphEdge);
                    switch (ak.getValue()) {
                        case 0: {
                            this.conn_.parent_.POPUPMENU_ASSOCIATION.aggregationNone_.setSelection(true);
                            break;
                        }
                        case 1: {
                            this.conn_.parent_.POPUPMENU_ASSOCIATION.aggregationShare_.setSelection(true);
                            break;
                        }
                        case 2: {
                            this.conn_.parent_.POPUPMENU_ASSOCIATION.aggregationComposite_.setSelection(true);
                        }
                    }
                    menu = this.conn_.parent_.POPUPMENU_ASSOCIATION.menu_;
                    break;
                }
                case 7: {
                    menu = this.conn_.parent_.POPUPMENU_COMMENT;
                    break;
                }
                default: {
                    menu = this.conn_.parent_.POPUPMENU_NORMAL;
                }
            }
            this.conn_.parent_.setPopupMenu(menu);
            this.conn_.getParent().handleMousePressed(me);
            this.conn_.setLineWidth(2);
            Latte.getMainForm().setSelectedModels(this.conn_.getGraphEdge());
        }

        public void mouseReleased(MouseEvent me) {
            this.conn_.getParent().handleMouseReleased(me);
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    static class ClassDiagConnectionMouseMotionListener
    implements MouseMotionListener {
        private LVClassDiagConnection conn_ = null;

        ClassDiagConnectionMouseMotionListener(LVClassDiagConnection conn) {
            this.conn_ = conn;
        }

        public void mouseDragged(MouseEvent me) {
            this.conn_.getParent().handleMouseDragged(me);
        }

        public void mouseMoved(MouseEvent me) {
            this.conn_.getParent().handleMouseMoved(me);
        }

        public void mouseEntered(MouseEvent me) {
            this.conn_.getParent().handleMouseEntered(me);
        }

        public void mouseExited(MouseEvent me) {
            this.conn_.getParent().handleMouseExited(me);
        }

        public void mouseHover(MouseEvent me) {
            this.conn_.getParent().handleMouseHover(me);
        }
    }

    static class LineArrowDecoration
    extends PolylineDecoration {
        LineArrowDecoration() {
            this.setScale(8.0, 5.0);
        }
    }

    static class TriangleDecoration
    extends PolygonDecoration {
        TriangleDecoration() {
            this.setBackgroundColor(ColorConstants.white);
            this.setScale(8.0, 5.0);
        }
    }

    static class AggregationDecoration
    extends PolygonDecoration {
        static final PointList DIAMOND_TIP = new PointList();

        static {
            DIAMOND_TIP.addPoint(0, 0);
            DIAMOND_TIP.addPoint(-1, 1);
            DIAMOND_TIP.addPoint(-2, 0);
            DIAMOND_TIP.addPoint(-1, -1);
        }

        AggregationDecoration() {
            this.setTemplate(DIAMOND_TIP);
            this.setBackgroundColor(ColorConstants.white);
            this.setScale(6.0, 4.0);
        }
    }

    static class CompositionDecoration
    extends PolygonDecoration {
        static final PointList DIAMOND_TIP = new PointList();

        static {
            DIAMOND_TIP.addPoint(0, 0);
            DIAMOND_TIP.addPoint(-1, 1);
            DIAMOND_TIP.addPoint(-2, 0);
            DIAMOND_TIP.addPoint(-1, -1);
        }

        CompositionDecoration() {
            this.setTemplate(DIAMOND_TIP);
            this.setScale(6.0, 4.0);
        }
    }
}

