/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.GraphNode;
import latte.di.Point;
import latte.util.DebugUtil;
import latte.view.LVClassDiag;
import latte.view.LVClassDiagFigure;
import latte.view.LVConst;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.SimpleTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.Comment;

public class LVClassDiagCommentFigure
extends LVClassDiagFigure {
    TextFlow textFlow_ = new TextFlow();
    static final Border BORDER = new CompoundBorder((Border)new FoldedPageBorder(), (Border)new MarginBorder(2, 2, 2, 2));

    protected LVClassDiagCommentFigure(LVClassDiag parent, GraphNode graphNode) {
        super(parent, graphNode);
        this.setBorder(BORDER);
        this.textFlow_.setLayoutManager((LayoutManager)new SimpleTextLayout(this.textFlow_));
        BlockFlow flow = new BlockFlow();
        FlowPage page = new FlowPage();
        flow.add((IFigure)this.textFlow_);
        page.add((IFigure)flow);
        this.add((IFigure)page);
        this.createFigureContents();
    }

    public void createFigureContents() {
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)this.graphNode_.getSemanticModel();
        Comment comment = (Comment)b.getElement();
        this.textFlow_.setText(comment.getBody());
    }

    public void notifyChanged(Notification notification) {
        Object newValue;
        super.notifyChanged(notification);
        if (Latte.TRACE_EVENT) {
            System.out.print(String.valueOf(DebugUtil.getEventId((Object)this, notification)) + " ");
            System.out.println("LVClassDiagCommentFigure notifyChanged:" + notification);
        }
        if ((newValue = notification.getNewValue()) instanceof Point) {
            if (Latte.TRACE_EVENT) {
                System.out.println("LVClassDiagCommentFigure \u51e6\u7406\u3057\u306a\u3044");
            }
            return;
        }
        switch (notification.getEventType()) {
            case 1: {
                this.createFigureContents();
                this.setConstraint();
                this.setValid(false);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVClassDiagCommentFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            default: {
                throw new InternalLogicException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u901a\u77e5");
            }
        }
    }

    public Color getBackgroundColor() {
        return LVConst.diagColor_;
    }

    static class FoldedPageBorder
    extends AbstractBorder {
        static final Color corner1 = new Color(null, 200, 208, 223);
        static final Color corner2 = new Color(null, 160, 172, 200);
        static final Color blue = new Color(null, 152, 168, 200);
        static final Color shadow = new Color(null, 202, 202, 202);
        static final int CORNER_SIZE = 6;
        static final PointList CORNER_ERASE = new PointList(3);
        static final PointList CORNER_PAINT;
        static final Insets insets;

        static {
            CORNER_ERASE.addPoint(1, 0);
            CORNER_ERASE.addPoint(1, 7);
            CORNER_ERASE.addPoint(-6, 0);
            CORNER_PAINT = new PointList(3);
            CORNER_PAINT.addPoint(-6, 0);
            CORNER_PAINT.addPoint(0, 6);
            CORNER_PAINT.addPoint(-6, 6);
            insets = new Insets(6, 2, 4, 4);
        }

        FoldedPageBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return insets;
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            Rectangle r = AbstractBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
            g.setLineWidth(4);
            r.resize(-2, -2);
            g.setForegroundColor(shadow);
            g.drawLine(r.x + 3, r.bottom(), r.right() - 1, r.bottom());
            g.drawLine(r.right(), r.y + 3 + 6, r.right(), r.bottom() - 1);
            g.restoreState();
            r.resize(-1, -1);
            g.drawRectangle(r);
            g.setForegroundColor(blue);
            g.drawRectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
            g.translate(r.getTopRight());
            g.fillPolygon(CORNER_ERASE);
            g.setBackgroundColor(corner1);
            g.fillPolygon(CORNER_PAINT);
            g.setForegroundColor(figure.getForegroundColor());
            g.drawPolygon(CORNER_PAINT);
            g.restoreState();
            g.setForegroundColor(corner2);
            g.drawLine(r.right() - 6 + 1, r.y + 2, r.right() - 2, r.y + 6 - 1);
        }
    }
}

