/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.ArrayList;
import java.util.Iterator;
import latte.InternalLogicException;
import latte.Latte;
import latte.action.AllAction;
import latte.di.GraphNode;
import latte.di.Point;
import latte.util.DebugUtil;
import latte.util.ModelUtil;
import latte.view.LVClassDiag;
import latte.view.LVClassDiagFigure;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;

public class LVClassDiagClassFigure
extends LVClassDiagFigure {
    private Label name_ = new Label();
    private LVClassDiagFigure.CompartmentFigure attributeFigure_ = new LVClassDiagFigure.CompartmentFigure();
    private LVClassDiagFigure.CompartmentFigure methodFigure_ = new LVClassDiagFigure.CompartmentFigure();

    protected LVClassDiagClassFigure(LVClassDiag parent, GraphNode graphNode) {
        super(parent, graphNode);
        this.add((IFigure)this.name_);
        this.add((IFigure)this.attributeFigure_);
        this.add((IFigure)this.methodFigure_);
        this.createFigureContents();
    }

    private void createFigureContents() {
        Type t;
        String name;
        this.attributeFigure_.removeAll();
        this.methodFigure_.removeAll();
        Class cls = (Class)ModelUtil.getElement(this.graphNode_);
        this.name_.setText(cls.getName());
        this.name_.setIcon(AllAction.ADD_CLASS.getImage());
        if (cls.isAbstract()) {
            this.name_.setFont(LVDiagFigure.ITALICBOLD);
        } else {
            this.name_.setFont(LVDiagFigure.BOLD);
        }
        if (ModelUtil.isAttributeVisible(this.graphNode_)) {
            ArrayList al = new ArrayList(cls.getOwnedAttributes());
            Iterator ai = al.iterator();
            while (ai.hasNext()) {
                Property p = (Property)ai.next();
                if (p.getAssociation() != null) continue;
                name = null;
                switch (p.getVisibility().getValue()) {
                    case 0: {
                        name = "+";
                        break;
                    }
                    case 2: {
                        name = "#";
                        break;
                    }
                    case 3: {
                        name = "~";
                        break;
                    }
                    case 1: {
                        name = "-";
                    }
                }
                name = String.valueOf(name) + p.getName();
                t = p.getType();
                name = String.valueOf(name) + " : " + ModelUtil.getTypeName(t, false);
                Label l = new Label(name, AllAction.SHOW_ATTRIBUTE.getImage());
                this.attributeFigure_.add((IFigure)l);
            }
        }
        if (ModelUtil.isMethodVisible(this.graphNode_)) {
            ArrayList ol = new ArrayList(cls.getOwnedOperations());
            Iterator oi = ol.iterator();
            while (oi.hasNext()) {
                Operation o = (Operation)oi.next();
                name = null;
                switch (o.getVisibility().getValue()) {
                    case 0: {
                        name = "+";
                        break;
                    }
                    case 2: {
                        name = "#";
                        break;
                    }
                    case 3: {
                        name = "~";
                        break;
                    }
                    case 1: {
                        name = "-";
                    }
                }
                name = String.valueOf(name) + o.getName();
                name = String.valueOf(name) + "()";
                if (!o.getName().equals(cls.getName())) {
                    t = o.getType();
                    name = String.valueOf(name) + " : " + ModelUtil.getTypeName(t, false);
                }
                Label l = new Label(name, AllAction.SHOW_METHOD.getImage());
                if (o.isAbstract()) {
                    l.setFont(LVDiagFigure.ITALIC);
                }
                this.methodFigure_.add((IFigure)l);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (Latte.TRACE_EVENT) {
            System.out.print(String.valueOf(DebugUtil.getEventId((Object)this, notification)) + " ");
            System.out.println("LVClassDiagClassFigure notifyChanged:" + notification);
        }
        EObject notifier = (EObject)notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        Object feature = notification.getFeature();
        String name = feature instanceof EAttribute ? ((EAttribute)feature).getName() : null;
        boolean wasSet = notification.wasSet();
        if (newValue instanceof Point) {
            return;
        }
        switch (notification.getEventType()) {
            case 3: {
                if (notifier instanceof Class && (newValue instanceof Property || newValue instanceof Operation)) {
                    this.createFigureContents();
                    this.setConstraint();
                    this.setValid(false);
                    break;
                }
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagClassFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 1: {
                this.doSetEvent(notifier, feature, name, wasSet);
                break;
            }
            case 4: {
                if (notifier instanceof Class && (oldValue instanceof Property || oldValue instanceof Operation)) {
                    this.createFigureContents();
                    this.setConstraint();
                    this.setValid(false);
                    break;
                }
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagClassFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 0: 
            case 8: {
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVClassDiagClassFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            default: {
                throw new InternalLogicException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u901a\u77e5");
            }
        }
    }

    private void doSetEvent(EObject notifier, Object feature, String name, boolean wasSet) {
        switch (ModelUtil.getClassifierID(notifier)) {
            case 10: 
            case 12: 
            case 13: {
                if (feature instanceof EAttribute && name.equals("name") && wasSet) break;
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagClassFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            case 8: {
                if (feature instanceof EAttribute && name.equals("visible")) break;
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagClassFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
            default: {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagClassFigure\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                }
                return;
            }
        }
        this.createFigureContents();
        this.setConstraint();
        this.setValid(false);
    }
}

