/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.di.GraphEdge;
import latte.util.ModelUtil;
import latte.view.LVClassDiag;
import latte.view.LVClassDiagConnection;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Property;

public class LVClassDiagAssociationConnection
extends LVClassDiagConnection {
    private Label roleLabel_;

    protected LVClassDiagAssociationConnection(LVClassDiag parent, GraphEdge graphEdge) {
        super(parent, graphEdge);
    }

    protected void setupConnectionStyle() {
        super.setupConnectionStyle();
        this.setLineStyle(1);
        Object sourceDeco = null;
        Object targetDeco = null;
        Property fromProperty = ModelUtil.getFromProperty(this.getGraphEdge());
        Property toProperty = ModelUtil.getToProperty(this.getGraphEdge());
        if (fromProperty != null && fromProperty.isNavigable()) {
            targetDeco = new LVClassDiagConnection.LineArrowDecoration();
        }
        if (toProperty != null && toProperty.isNavigable()) {
            sourceDeco = new LVClassDiagConnection.LineArrowDecoration();
        }
        AggregationKind fromAgg = fromProperty.getAggregation();
        switch (fromAgg.getValue()) {
            case 1: {
                sourceDeco = new LVClassDiagConnection.AggregationDecoration();
                break;
            }
            case 2: {
                sourceDeco = new LVClassDiagConnection.CompositionDecoration();
            }
        }
        AggregationKind toAgg = toProperty.getAggregation();
        switch (toAgg.getValue()) {
            case 1: {
                targetDeco = new LVClassDiagConnection.AggregationDecoration();
                break;
            }
            case 2: {
                targetDeco = new LVClassDiagConnection.CompositionDecoration();
            }
        }
        this.setSourceDecoration((RotatableDecoration)sourceDeco);
        this.setTargetDecoration((RotatableDecoration)targetDeco);
        if (this.roleLabel_ == null) {
            ConnectionEndpointLocator relationshipLocator = new ConnectionEndpointLocator((Connection)this, true);
            relationshipLocator.setUDistance(5);
            relationshipLocator.setVDistance(-5);
            this.roleLabel_ = new Label();
            this.add((IFigure)this.roleLabel_, relationshipLocator);
        }
        String roleName = "";
        if (ModelUtil.getClassifierID(fromProperty.getOwner()) == 10) {
            roleName = fromProperty.getName();
        }
        this.roleLabel_.setText(roleName);
    }

    ConnectionAnchor createSourceConnectionAnchor() {
        LVDiagFigure fig = this.getLVDiagFigure(ModelUtil.getFromGraphConnector(this.getGraphEdge()));
        if (fig == null) {
            throw new IllegalStateException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u7aef\u306f\u56f3\u306e\u8981\u7d20\u306b\u542b\u307e\u308c\u307e\u305b\u3093");
        }
        return new ChopboxAnchor((IFigure)fig);
    }

    ConnectionAnchor createTargetConnectionAnchor() {
        LVDiagFigure fig = this.getLVDiagFigure(ModelUtil.getToGraphConnector(this.getGraphEdge()));
        if (fig == null) {
            throw new IllegalStateException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u7aef\u306f\u56f3\u306e\u8981\u7d20\u306b\u542b\u307e\u308c\u307e\u305b\u3093");
        }
        return new ChopboxAnchor((IFigure)fig);
    }
}

