/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import latte.InternalLogicException;
import latte.Latte;
import latte.action.AbstractLatteAction;
import latte.action.AllAction;
import latte.di.Diagram;
import latte.di.GraphEdge;
import latte.di.GraphElement;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.view.LVClassDiagAssociationConnection;
import latte.view.LVClassDiagClassFigure;
import latte.view.LVClassDiagCommentConnection;
import latte.view.LVClassDiagCommentFigure;
import latte.view.LVClassDiagConnection;
import latte.view.LVClassDiagDependencyConnection;
import latte.view.LVClassDiagFigure;
import latte.view.LVClassDiagGeneralizationConnection;
import latte.view.LVClassDiagImplementaionConnection;
import latte.view.LVClassDiagInterfaceFigure;
import latte.view.LVConst;
import latte.view.LVDiag;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Property;

public class LVClassDiag
extends LVDiag {
    public final Menu POPUPMENU_NONE = null;
    public final ClassFigureMenu POPUPMENU_CLASS_FIG = this.createClassFigurePopupMenu();
    public final Menu POPUPMENU_NORMAL = this.createNormalPopupMenu();
    public final AssociationConnectionMenu POPUPMENU_ASSOCIATION = this.createAssociationPopupMenu();
    public final Menu POPUPMENU_COMMENT = this.createCommentPopupMenu();
    AbstractLatteAction MODE_SELECTION_ACTION;
    AbstractLatteAction MODE_ASSOCIATION_ACTION;
    AbstractLatteAction MODE_GENELIZATION_ACTION;
    AbstractLatteAction MODE_DEPENDENCY_ACTION;
    AbstractLatteAction MODE_IMPLEMENTATION_ACTION;
    AbstractLatteAction MODE_NOTELINK_ACTION;
    private AddingLine addingLine_ = new AddingLine();

    public LVClassDiag(Diagram diag) {
        super(diag);
        this.createDiagContent();
        new LVClassDiagListener();
    }

    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(String.valueOf(DebugUtil.getEventId((Object)this, notification)) + " ");
            System.out.println("LVClassDiag notifyChanged:" + notification);
        }
        GraphElement newValue = (GraphElement)notification.getNewValue();
        GraphElement oldValue = (GraphElement)notification.getOldValue();
        block0 : switch (notification.getEventType()) {
            case 3: {
                switch (ModelUtil.getClassifierID(newValue)) {
                    case 8: {
                        this.addFigure((GraphNode)newValue);
                        break block0;
                    }
                    case 6: {
                        this.addConnection((GraphEdge)newValue);
                        break block0;
                    }
                }
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVClassDiag\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            case 4: {
                switch (ModelUtil.getClassifierID(oldValue)) {
                    case 8: {
                        LVDiagFigure f = this.lookupFigure((GraphNode)oldValue);
                        this.removeFigure((LVClassDiagFigure)f);
                        break block0;
                    }
                    case 6: {
                        LVClassDiagConnection c = this.lookupConnection((GraphEdge)oldValue);
                        this.removeConnection(c);
                        break block0;
                    }
                }
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVClassDiag\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            case 8: {
                if (!Latte.TRACE_EVENT) break;
                System.out.println("LVClassDiag\u3067\u51e6\u7406\u3057\u306a\u3044\u30a4\u30d9\u30f3\u30c8\u306a\u306e\u3067\u623b\u308b");
                break;
            }
            default: {
                throw new InternalLogicException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u901a\u77e5");
            }
        }
    }

    public List getDiagConnectionList() {
        List l = this.getDraw2dView().getChildren();
        ArrayList l2 = new ArrayList();
        Iterator ite = l.iterator();
        while (ite.hasNext()) {
            Object o = ite.next();
            if (!(o instanceof LVClassDiagConnection)) continue;
            l2.add(o);
        }
        return l2;
    }

    AddingLine getAddingLine() {
        return this.addingLine_;
    }

    private LVClassDiagConnection lookupConnection(GraphEdge graphEdge) {
        Iterator i = this.getDraw2dView().getChildren().iterator();
        while (i.hasNext()) {
            LVClassDiagConnection c;
            GraphEdge ge;
            Object o = i.next();
            if (!(o instanceof LVClassDiagConnection) || (ge = (c = (LVClassDiagConnection)((Object)o)).getGraphEdge()) != graphEdge) continue;
            return c;
        }
        throw new InternalLogicException("\u767a\u898b\u3067\u304d\u308b\u306f\u305a\u306a\u306e\u306b\u767a\u898b\u3067\u304d\u306a\u3044");
    }

    public void setPopupMenu(Menu menu) {
        this.getSwtView().setMenu(menu);
    }

    protected void createDiagModeBar(Composite parent) {
        this.MODE_SELECTION_ACTION = new ModeSelectionAction("\u9078\u629e\u30e2\u30fc\u30c9", "images/selection.gif");
        this.MODE_ASSOCIATION_ACTION = new ModeAssociationAction("\u95a2\u9023\u4f5c\u6210\u30e2\u30fc\u30c9", "images/association.gif");
        this.MODE_GENELIZATION_ACTION = new ModeGenelizationAction("\u6c4e\u5316\u4f5c\u6210\u30e2\u30fc\u30c9", "images/generalization.gif");
        this.MODE_DEPENDENCY_ACTION = new ModeDependencyAction("\u4f9d\u5b58\u4f5c\u6210\u30e2\u30fc\u30c9", "images/dependency.gif");
        this.MODE_IMPLEMENTATION_ACTION = new ModeImplementationAction("\u5b9f\u88c5\u4f5c\u6210\u30e2\u30fc\u30c9", "images/implementation.gif");
        this.MODE_NOTELINK_ACTION = new ModeNotelinkAction("\u30ce\u30fc\u30c8\u30ea\u30f3\u30af\u4f5c\u6210\u30e2\u30fc\u30c9", "images/notelink.gif");
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        GuiUtil.createToolbarItem(toolbar, 16, this.MODE_SELECTION_ACTION, true);
        GuiUtil.createToolbarItem(toolbar, 16, this.MODE_ASSOCIATION_ACTION);
        GuiUtil.createToolbarItem(toolbar, 16, this.MODE_GENELIZATION_ACTION);
        GuiUtil.createToolbarItem(toolbar, 16, this.MODE_DEPENDENCY_ACTION);
        GuiUtil.createToolbarItem(toolbar, 16, this.MODE_IMPLEMENTATION_ACTION);
        new ToolItem(toolbar, 2);
        GuiUtil.createToolbarItem(toolbar, 16, this.MODE_NOTELINK_ACTION);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_NOTE);
    }

    protected Image getTabImage() {
        return AllAction.ADD_CLASS_DIAGRAM.getImage();
    }

    private void initMode() {
        this.setMode(1);
        this.MODE_SELECTION_ACTION.setSelected(true);
        this.MODE_ASSOCIATION_ACTION.setSelected(false);
        this.MODE_GENELIZATION_ACTION.setSelected(false);
        this.MODE_DEPENDENCY_ACTION.setSelected(false);
        this.MODE_IMPLEMENTATION_ACTION.setSelected(false);
        this.MODE_NOTELINK_ACTION.setSelected(false);
    }

    private void createDiagContent() {
        LogUtil.writeln("<!-- <<<<<<<<  \u30af\u30e9\u30b9\u56f3\u30b3\u30f3\u30c6\u30f3\u30c4\u4f5c\u6210 >>>>>>> -->");
        Iterator i = this.getDiagram().getContained().iterator();
        while (i.hasNext()) {
            GraphElement graphElement = (GraphElement)i.next();
            switch (ModelUtil.getClassifierID(graphElement)) {
                case 8: {
                    this.addFigure((GraphNode)graphElement);
                    break;
                }
                case 6: {
                    this.addConnection((GraphEdge)graphElement);
                    break;
                }
                default: {
                    throw new InternalLogicException("\u60f3\u5b9a\u5916\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8");
                }
            }
        }
    }

    private void addFigure(GraphNode graphNode) {
        Element element = ModelUtil.getElement(graphNode);
        try {
            LVClassDiagFigure lvClassDiagFigure = null;
            switch (ModelUtil.getClassifierID(element)) {
                case 10: {
                    lvClassDiagFigure = new LVClassDiagClassFigure(this, graphNode);
                    break;
                }
                case 84: {
                    lvClassDiagFigure = new LVClassDiagInterfaceFigure(this, graphNode);
                    break;
                }
                case 7: {
                    lvClassDiagFigure = new LVClassDiagCommentFigure(this, graphNode);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("addFigure()\u3067\u304d\u307e\u305b\u3093");
                }
            }
            this.addFigureListener(lvClassDiagFigure, graphNode);
            this.getDraw2dView().add((IFigure)lvClassDiagFigure);
            lvClassDiagFigure.setConstraint();
            this.getDraw2dView().setValid(false);
            LogUtil.writeln("\u6210\u529f\uff01");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.getMessage());
        }
    }

    private void addConnection(GraphEdge graphEdge) {
        Element element = ModelUtil.getElement(graphEdge);
        try {
            LVClassDiagConnection lvClassDiagConnection = null;
            switch (ModelUtil.getClassifierID(element)) {
                case 40: {
                    lvClassDiagConnection = new LVClassDiagAssociationConnection(this, graphEdge);
                    break;
                }
                case 51: {
                    lvClassDiagConnection = new LVClassDiagDependencyConnection(this, graphEdge);
                    break;
                }
                case 85: {
                    lvClassDiagConnection = new LVClassDiagImplementaionConnection(this, graphEdge);
                    break;
                }
                case 36: {
                    lvClassDiagConnection = new LVClassDiagGeneralizationConnection(this, graphEdge);
                    break;
                }
                case 7: {
                    lvClassDiagConnection = new LVClassDiagCommentConnection(this, graphEdge);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("addConnection()\u3067\u304d\u307e\u305b\u3093");
                }
            }
            this.addConnectionListener(lvClassDiagConnection, graphEdge);
            this.getDraw2dView().add((IFigure)lvClassDiagConnection);
            this.getDraw2dView().setValid(false);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.getMessage());
        }
    }

    private void removeFigure(LVClassDiagFigure lvFig) {
        this.removeFigureListener(lvFig);
        this.getDraw2dView().remove((IFigure)lvFig);
        lvFig.erase();
    }

    private void removeConnection(LVClassDiagConnection lvConn) {
        this.removeConnectionListener(lvConn);
        this.getDraw2dView().remove((IFigure)lvConn);
        lvConn.erase();
    }

    private void addFigureListener(LVClassDiagFigure lvClassDiagFigure, GraphNode graphNode) {
        graphNode.eAdapters().add((Object)lvClassDiagFigure);
        Element element = ModelUtil.getElement(graphNode);
        element.eAdapters().add((Object)lvClassDiagFigure);
        Iterator i = element.getOwnedElements().iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            e.eAdapters().add((Object)lvClassDiagFigure);
        }
        if (ModelUtil.isExistAttributeGraphNode(graphNode)) {
            GraphNode attributeGraphNode = ModelUtil.getAttributeGraphNode(graphNode);
            attributeGraphNode.eAdapters().add((Object)lvClassDiagFigure);
        }
        if (ModelUtil.isExistMethodGraphNode(graphNode)) {
            GraphNode methodGraphNode = ModelUtil.getMethodGraphNode(graphNode);
            methodGraphNode.eAdapters().add((Object)lvClassDiagFigure);
        }
    }

    private void addConnectionListener(LVClassDiagConnection lvClassDiagConnection, GraphEdge graphEdge) {
        graphEdge.eAdapters().add((Object)lvClassDiagConnection);
        Element element = ModelUtil.getElement(graphEdge);
        switch (ModelUtil.getClassifierID(element)) {
            case 40: {
                Property prop = ModelUtil.getFromProperty(graphEdge);
                prop.eAdapters().add((Object)lvClassDiagConnection);
                break;
            }
        }
    }

    private void removeFigureListener(LVClassDiagFigure lvClassDiagFigure) {
        GraphNode graphElement = lvClassDiagFigure.getGraphNode();
        graphElement.eAdapters().remove((Object)lvClassDiagFigure);
        Element element = ModelUtil.getElement(graphElement);
        element.eAdapters().remove((Object)lvClassDiagFigure);
        Iterator i = element.getOwnedElements().iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            e.eAdapters().remove((Object)lvClassDiagFigure);
        }
    }

    private void removeConnectionListener(LVClassDiagConnection lvClassDiagConnection) {
        GraphEdge graphElement = lvClassDiagConnection.getGraphEdge();
        graphElement.eAdapters().remove((Object)lvClassDiagConnection);
        Element element = ModelUtil.getElement(graphElement);
        element.eAdapters().remove((Object)lvClassDiagConnection);
    }

    private Menu createNormalPopupMenu() {
        Menu menu = new Menu((Control)this.getSwtView());
        GuiUtil.createMenuItem(menu, AllAction.EDIT_REMOVE);
        GuiUtil.createMenuItem(menu, AllAction.REMOVE_MODEL);
        return menu;
    }

    private ClassFigureMenu createClassFigurePopupMenu() {
        ClassFigureMenu classFigureMenu = new ClassFigureMenu((Control)this.getSwtView());
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.ADD_METHOD);
        new MenuItem(classFigureMenu.menu_, 2);
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.EDIT_REMOVE);
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.REMOVE_MODEL);
        new MenuItem(classFigureMenu.menu_, 2);
        classFigureMenu.showAttributeMenuItem_ = GuiUtil.createCheckMenuItem(classFigureMenu.menu_, AllAction.SHOW_ATTRIBUTE, false);
        classFigureMenu.showMethodMenuItem_ = GuiUtil.createCheckMenuItem(classFigureMenu.menu_, AllAction.SHOW_METHOD, false);
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.SHOW_DEF);
        return classFigureMenu;
    }

    private AssociationConnectionMenu createAssociationPopupMenu() {
        AssociationConnectionMenu associationConnectionMenu = new AssociationConnectionMenu((Control)this.getSwtView());
        associationConnectionMenu.navigatableMenuItem_ = GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.NAVIGATABLE, false);
        new MenuItem(associationConnectionMenu.menu_, 2);
        associationConnectionMenu.aggregationNone_ = GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.CONTAINER_NONE, false);
        associationConnectionMenu.aggregationShare_ = GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.CONTAINER_AGGREGATION, false);
        associationConnectionMenu.aggregationComposite_ = GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.CONTAINER_COMPOSITION, false);
        new MenuItem(associationConnectionMenu.menu_, 2);
        GuiUtil.createMenuItem(associationConnectionMenu.menu_, AllAction.EDIT_REMOVE);
        GuiUtil.createMenuItem(associationConnectionMenu.menu_, AllAction.REMOVE_MODEL);
        return associationConnectionMenu;
    }

    private Menu createCommentPopupMenu() {
        Menu menu = new Menu((Control)this.getSwtView());
        GuiUtil.createMenuItem(menu, AllAction.EDIT_REMOVE);
        return menu;
    }

    class LVClassDiagListener
    implements MouseListener,
    MouseMotionListener {
        private Point last_ = new Point(0, 0);

        public LVClassDiagListener() {
            LVClassDiag.this.getDraw2dView().addMouseListener((MouseListener)this);
            LVClassDiag.this.getDraw2dView().addMouseMotionListener((MouseMotionListener)this);
        }

        public void mousePressed(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mousePressed(" + me.x + "," + me.y + ")" + " button=" + me.button);
            Latte.getMainForm().getTree().deselectAll();
            if (LVClassDiag.this.getMode() == 1) {
                Latte.getMainForm().setSelectedModels(null);
                Iterator i = LVClassDiag.this.getDraw2dView().getChildren().iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (o instanceof LVClassDiagFigure) {
                        LVClassDiagFigure f = (LVClassDiagFigure)((Object)o);
                        f.setNormalBackgroundColor();
                        continue;
                    }
                    if (!(o instanceof LVClassDiagConnection)) continue;
                    LVClassDiagConnection conn = (LVClassDiagConnection)((Object)o);
                    conn.setLineWidth(1);
                }
                Viewport viewport = (Viewport)LVClassDiag.this.getDraw2dView().getParent();
                this.last_ = me.getLocation().translate(viewport.getViewLocation());
            }
        }

        public void mouseReleased(MouseEvent me) {
            LVClassDiag.this.getAddingLine().end();
            LVClassDiag.this.setPopupMenu(LVClassDiag.this.POPUPMENU_NONE);
            LVClassDiag.this.initMode();
        }

        public void mouseDragged(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mouseDragged(" + me.x + "," + me.y + ")" + " button=" + me.button);
            switch (LVClassDiag.this.getMode()) {
                case 1: {
                    EObject selectedElement = Latte.getMainForm().getSelectedModels();
                    if (!(selectedElement instanceof GraphElement)) {
                        return;
                    }
                    GraphElement graphElement = (GraphElement)selectedElement;
                    Viewport viewport = (Viewport)LVClassDiag.this.getDraw2dView().getParent();
                    Point now = me.getLocation().translate(viewport.getViewLocation());
                    Dimension delta = now.getDifference(this.last_);
                    if (graphElement instanceof GraphNode) {
                        LogUtil.writeln("delta=" + delta);
                        AllAction.FIGURE_MOVE.execute(new Object[]{graphElement, delta});
                    }
                    this.last_ = now;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    LVClassDiag.this.getAddingLine().move(me.getLocation());
                    break;
                }
                default: {
                    throw new InternalLogicException("mouseDragged()\u8003\u616e\u6f0f\u308c");
                }
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mouseDoubleClicked(" + me.x + "," + me.y + ")" + " button=" + me.button);
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }
    }

    class AddingLine
    extends PolylineConnection {
        IFigure parent_ = null;
        private LVClassDiagFigure fromFig_ = null;
        private LVClassDiagFigure toFig_ = null;

        AddingLine() {
            this.setForegroundColor(LVConst.ForeColor);
        }

        public void start(LVClassDiagFigure figure, Point p) {
            this.parent_ = figure.getParent();
            this.fromFig_ = figure;
            this.toFig_ = null;
            this.setStart(p);
            this.setEnd(p);
            this.parent_.add((IFigure)this, 0);
        }

        public void move(Point p) {
            if (this.fromFig_ != null) {
                this.setEnd(p);
            }
        }

        public void end() {
            if (this.fromFig_ != null) {
                this.parent_.remove((IFigure)this);
                if (this.toFig_ != null) {
                    String mode = Integer.toString(LVClassDiag.this.getMode());
                    AllAction.ADD_RELATION.execute(new Object[]{mode, this.fromFig_.getGraphNode(), this.toFig_.getGraphNode()});
                }
                this.fromFig_ = null;
                this.toFig_ = null;
            }
        }

        public boolean isToFigCandidate(LVClassDiagFigure toFig) {
            return this.fromFig_ != null && this.fromFig_ != toFig;
        }

        public void setToFig(LVClassDiagFigure figure) {
            this.toFig_ = figure;
        }
    }

    class ModeSelectionAction
    extends AbstractLatteAction {
        public ModeSelectionAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            LVClassDiag.this.setMode(1);
        }
    }

    class ModeAssociationAction
    extends AbstractLatteAction {
        public ModeAssociationAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            LVClassDiag.this.setMode(2);
        }
    }

    class ModeDependencyAction
    extends AbstractLatteAction {
        public ModeDependencyAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            LVClassDiag.this.setMode(5);
        }
    }

    class ModeGenelizationAction
    extends AbstractLatteAction {
        public ModeGenelizationAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            LVClassDiag.this.setMode(3);
        }
    }

    class ModeImplementationAction
    extends AbstractLatteAction {
        public ModeImplementationAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            LVClassDiag.this.setMode(4);
        }
    }

    class ModeNotelinkAction
    extends AbstractLatteAction {
        public ModeNotelinkAction(String title, String imageFile) {
            super(title, imageFile);
        }

        public void execMain(Object param) {
            LVClassDiag.this.setMode(6);
        }
    }

    class AssociationConnectionMenu {
        Menu menu_ = null;
        MenuItem navigatableMenuItem_ = null;
        MenuItem aggregationNone_ = null;
        MenuItem aggregationShare_ = null;
        MenuItem aggregationComposite_ = null;

        public AssociationConnectionMenu(Control parent) {
            this.menu_ = new Menu(parent);
        }
    }

    class ClassFigureMenu {
        Menu menu_ = null;
        MenuItem showAttributeMenuItem_ = null;
        MenuItem showMethodMenuItem_ = null;

        public ClassFigureMenu(Control parent) {
            this.menu_ = new Menu(parent);
        }
    }
}

