/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.Iterator;
import latte.Latte;
import latte.action.AllAction;
import latte.di.CoreSemanticModelBridge;
import latte.di.Diagram;
import latte.di.GraphElement;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.view.LVDiag;
import latte.view.LVDiagFolder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

public class DropTargetEnabler
implements DropTargetListener {
    private LVDiagFolder latteDiagFolder_ = null;
    private static Transfer[] TYPE = new Transfer[]{TextTransfer.getInstance()};
    private static int OPERATION = 7;

    public DropTargetEnabler(LVDiagFolder folder, Control control) {
        this.latteDiagFolder_ = folder;
        DropTarget target = new DropTarget(control, OPERATION);
        target.setTransfer(TYPE);
        target.addDropListener((DropTargetListener)this);
    }

    public void drop(DropTargetEvent event) {
        LogUtil.write("DropTarget.drop():");
        if (event.data == null) {
            event.detail = 0;
            LogUtil.writeln("none");
            return;
        }
        Viewport viewport = (Viewport)GuiUtil.getSelectedLVDiag().getDraw2dView().getParent();
        Point offset = viewport.getViewLocation();
        Canvas c = GuiUtil.getSelectedLVDiag().getSwtView();
        org.eclipse.swt.graphics.Point p = c.toControl(new org.eclipse.swt.graphics.Point(event.x + offset.x, event.y + offset.y));
        Point droppedPoint = new Point(p.x, p.y);
        LogUtil.writeln("dropped on " + droppedPoint);
        AllAction.ADD_FIGURE.execute(droppedPoint);
    }

    public void dragEnter(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragEnter()");
        LVDiag lvDiag = GuiUtil.getSelectedLVDiag();
        if (lvDiag == null) {
            event.detail = 0;
            return;
        }
        EObject selectedModel = Latte.getMainForm().getTree().getSelectedModels();
        Diagram diagram = lvDiag.getDiagram();
        Iterator i = diagram.getContained().iterator();
        while (i.hasNext()) {
            GraphElement graphElement = (GraphElement)i.next();
            CoreSemanticModelBridge uml2ModelBridge = (CoreSemanticModelBridge)graphElement.getSemanticModel();
            if (uml2ModelBridge.getElement() != selectedModel) continue;
            event.detail = 0;
            return;
        }
    }

    public void dragLeave(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragLeave()");
    }

    public void dragOperationChanged(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragOperationChanged()");
        if (event.detail == 16) {
            event.detail = 4;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dropAccept()");
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 25;
    }
}

