/*
 * Decompiled with CFR 0.152.
 */
package latte.util;

import com.sun.javadoc.Doc;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import latte.InternalLogicException;
import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.DIFactory;
import latte.di.Diagram;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphElement;
import latte.di.GraphNode;
import latte.di.SimpleSemanticModelElement;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Dependency;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Implementation;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Factory;

public class ModelUtil {
    public static UML2Factory Uml2Factory = UML2Factory.eINSTANCE;
    public static DIFactory DiFactory = DIFactory.eINSTANCE;
    private static Comparator uml2Comparator_ = new Uml2Comparator();
    private static Comparator docComparator_ = new DocComparator();

    public static int getClassifierID(Object object) {
        if (object == null || !(object instanceof EObject)) {
            return -1;
        }
        EObject eo = (EObject)object;
        EClass eclass = eo.eClass();
        return eclass.getClassifierID();
    }

    public static int getInsertIndex(Object[] defs, Object newDef, boolean sort) {
        int i = 0;
        switch (ModelUtil.getClassifierID(newDef)) {
            case 16: {
                Package newPkg = (Package)newDef;
                i = 0;
                while (i < defs.length) {
                    Package pkg;
                    if (defs[i] instanceof Class || defs[i] instanceof Interface) {
                        return i;
                    }
                    if (sort && (pkg = (Package)defs[i]).getName().compareTo(newPkg.getName()) > 0) {
                        return i;
                    }
                    ++i;
                }
                break;
            }
            case 84: {
                Interface newIf = (Interface)newDef;
                i = 0;
                while (i < defs.length) {
                    if (!(defs[i] instanceof Package)) {
                        Interface interf;
                        if (defs[i] instanceof Class) {
                            return i;
                        }
                        if (defs[i] instanceof Property || defs[i] instanceof Operation) {
                            return i;
                        }
                        if (sort && (interf = (Interface)defs[i]).getName().compareTo(newIf.getName()) > 0) {
                            return i;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 10: {
                Class newClass = (Class)newDef;
                i = 0;
                while (i < defs.length) {
                    if (!(defs[i] instanceof Package) && !(defs[i] instanceof Interface)) {
                        Class c;
                        if (defs[i] instanceof Property || defs[i] instanceof Operation || defs[i] instanceof Association) {
                            return i;
                        }
                        if (sort && (c = (Class)defs[i]).getName().compareTo(newClass.getName()) > 0) {
                            return i;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 12: {
                Property newAttr = (Property)newDef;
                i = 0;
                while (i < defs.length) {
                    if (!(defs[i] instanceof Class) && !(defs[i] instanceof Interface)) {
                        Property attr;
                        if (defs[i] instanceof Operation) {
                            return i;
                        }
                        if (sort && (attr = (Property)defs[i]).getName().compareTo(newAttr.getName()) > 0) {
                            return i;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 13: {
                Operation newMethod = (Operation)newDef;
                i = 0;
                while (i < defs.length) {
                    Operation method;
                    if (!(defs[i] instanceof Class) && !(defs[i] instanceof Interface) && !(defs[i] instanceof Property) && sort && (method = (Operation)defs[i]).getName().compareTo(newMethod.getName()) > 0) {
                        return i;
                    }
                    ++i;
                }
                break;
            }
            case 40: {
                i = 0;
                while (i < defs.length) {
                    ++i;
                }
                break;
            }
            case 2: {
                Diagram newDiag = (Diagram)newDef;
                String newDiagType = ModelUtil.getDiagType(newDiag);
                if (newDiagType.equals("ClassDiagram")) {
                    i = 0;
                    while (i < defs.length) {
                        Diagram diag = (Diagram)defs[i];
                        String diagType = ModelUtil.getDiagType(diag);
                        if (!diagType.equals("ClassDiagram")) {
                            return i;
                        }
                        if (sort && diag.getName().compareTo(newDiag.getName()) > 0) {
                            return i;
                        }
                        ++i;
                    }
                } else {
                    if (!newDiagType.equals("SequenceDiagram")) break;
                    i = 0;
                    while (i < defs.length) {
                        Diagram diag = (Diagram)defs[i];
                        String diagType = ModelUtil.getDiagType(diag);
                        if (diagType.equals("ClassDiagram") && sort && diag.getName().compareTo(newDiag.getName()) > 0) {
                            return i;
                        }
                        ++i;
                    }
                }
                break;
            }
            default: {
                throw new InternalLogicException("\u60f3\u5b9a\u5916\u306e\u65b0\u30aa\u30d6\u30b8\u30a7\u30af\u30c8");
            }
        }
        return i;
    }

    public static Point getLocation(GraphElement graphElement, Point offset) {
        int x = graphElement.getPosition().getX();
        int y = graphElement.getPosition().getY();
        Point p = new Point(x, y);
        p = p.translate(offset);
        return p;
    }

    public static void setNeedSaving() {
        Latte.getLatteData().setNeedSaving();
    }

    public static String getDiagType(Diagram diag) {
        SimpleSemanticModelElement element = (SimpleSemanticModelElement)diag.getNamespace();
        return element.getTypeInfo();
    }

    public static Element getElement(GraphElement graphElement) {
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)graphElement.getSemanticModel();
        return b.getElement();
    }

    public static void removeGraphNode(Element element) {
        Iterator i = Latte.getLatteData().getDiagrams().getContained().iterator();
        while (i.hasNext()) {
            Diagram diagram = (Diagram)i.next();
            ModelUtil.removeGraphNodeFromDiagram(diagram, element);
        }
    }

    public static void removeGraphNodeFromDiagram(Diagram diagram, Element removeElement) {
        ArrayList list = new ArrayList();
        list.addAll(diagram.getContained());
        Iterator i = list.iterator();
        block8: while (i.hasNext()) {
            GraphElement graphElement = (GraphElement)i.next();
            Element element = ModelUtil.getElement(graphElement);
            block0 : switch (ModelUtil.getClassifierID(element)) {
                case 10: 
                case 84: {
                    if (removeElement != element) break;
                    diagram.getContained().remove((Object)graphElement);
                    break;
                }
                case 7: {
                    if (removeElement == element) {
                        diagram.getContained().remove((Object)graphElement);
                    }
                    if (ModelUtil.getClassifierID(graphElement) != 6) break;
                    GraphEdge graphEdge = (GraphEdge)graphElement;
                    Iterator j = graphEdge.getAnchor().iterator();
                    while (j.hasNext()) {
                        GraphConnector graphConnector = (GraphConnector)j.next();
                        Element e = ModelUtil.getElement(graphConnector.getGraphElement());
                        if (e != removeElement) continue;
                        ModelUtil.removeGraphEdgeFromDiagram(diagram, graphEdge);
                        break block0;
                    }
                    continue block8;
                }
                case 40: {
                    Association ass = (Association)element;
                    Iterator j = ass.getMemberEnds().iterator();
                    while (j.hasNext()) {
                        Property p = (Property)j.next();
                        if (p.getType() != removeElement) continue;
                        ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                    }
                    continue block8;
                }
                case 51: {
                    Dependency dep = (Dependency)element;
                    if (!dep.getSuppliers().contains((Object)removeElement) && !dep.getClients().contains((Object)removeElement)) continue block8;
                    ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                    break;
                }
                case 36: {
                    Generalization gen = (Generalization)element;
                    if (gen.getGeneral() != removeElement && gen.getSpecific() != removeElement) continue block8;
                    ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                    break;
                }
                case 85: {
                    Implementation imp = (Implementation)element;
                    if (imp.getImplementingClassifier() != removeElement && imp.getContract() != removeElement) continue block8;
                    ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                }
            }
        }
    }

    public static void removeGraphEdgeFromDiagram(Diagram diagram, GraphEdge graphEdge) {
        graphEdge.getAnchor().clear();
        diagram.getContained().remove((Object)graphEdge);
    }

    public static Property getProperty(Association ass, GraphConnector graphConnector) {
        GraphNode graphNode = (GraphNode)graphConnector.getGraphElement();
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)graphNode.getSemanticModel();
        Element element = b.getElement();
        Iterator i = null;
        switch (ModelUtil.getClassifierID(element)) {
            case 10: {
                Class c = (Class)element;
                i = c.getOwnedAttributes().iterator();
                break;
            }
            case 84: {
                Interface in = (Interface)element;
                i = in.getOwnedAttributes().iterator();
            }
        }
        Property p = null;
        while (i.hasNext()) {
            p = (Property)i.next();
            if (p.getAssociation() != ass) continue;
            return p;
        }
        return null;
    }

    public static Property getFromProperty(GraphEdge graphEdge) {
        Element element = ModelUtil.getElement(graphEdge);
        switch (ModelUtil.getClassifierID(element)) {
            case 40: {
                break;
            }
            default: {
                throw new InternalLogicException("association\u3067\u3042\u308a\u307e\u305b\u3093");
            }
        }
        Association association = (Association)element;
        Property p = (Property)association.getMemberEnds().get(0);
        return p;
    }

    public static Property getToProperty(GraphEdge graphEdge) {
        Element element = ModelUtil.getElement(graphEdge);
        switch (ModelUtil.getClassifierID(element)) {
            case 40: {
                break;
            }
            default: {
                throw new InternalLogicException("association\u3067\u3042\u308a\u307e\u305b\u3093");
            }
        }
        Association association = (Association)element;
        Property p = (Property)association.getMemberEnds().get(1);
        return p;
    }

    public static String getTypeName(Type t, boolean withNamespace) {
        String name = null;
        if (t != null) {
            switch (ModelUtil.getClassifierID(t)) {
                case 17: {
                    String n = t.getName();
                    n = n.substring(n.lastIndexOf(".") + 1);
                    name = "(" + n + ")";
                    break;
                }
                default: {
                    name = t.getName();
                }
            }
        }
        return name;
    }

    public static boolean isExistAttributeGraphNode(GraphNode classGraphNode) {
        if (classGraphNode.getContained().size() < 1) {
            return false;
        }
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        return attributeGraphNode != null;
    }

    public static boolean isExistMethodGraphNode(GraphNode classGraphNode) {
        if (classGraphNode.getContained().size() < 2) {
            return false;
        }
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        return attributeGraphNode != null;
    }

    public static GraphNode getAttributeGraphNode(GraphNode classGraphNode) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        return attributeGraphNode;
    }

    public static GraphNode getMethodGraphNode(GraphNode classGraphNode) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        return attributeGraphNode;
    }

    public static boolean isAttributeVisible(GraphNode classGraphNode) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        return attributeGraphNode.isVisible();
    }

    public static boolean isMethodVisible(GraphNode classGraphNode) {
        GraphNode methodGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        return methodGraphNode.isVisible();
    }

    public static void setAttributeVisible(GraphNode classGraphNode, boolean b) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        attributeGraphNode.setVisible(b);
    }

    public static void setMethodVisible(GraphNode classGraphNode, boolean b) {
        GraphNode methodGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        methodGraphNode.setVisible(b);
    }

    public static Comparator getUml2Comparator() {
        return uml2Comparator_;
    }

    public static Comparator getDocComparator() {
        return docComparator_;
    }

    public static GraphConnector getFromGraphConnector(GraphEdge graphEdge) {
        return (GraphConnector)graphEdge.getAnchor().get(0);
    }

    public static GraphConnector getToGraphConnector(GraphEdge graphEdge) {
        return (GraphConnector)graphEdge.getAnchor().get(1);
    }

    public static boolean isNavigable(GraphEdge graphEdge) {
        Property property = ModelUtil.getFromProperty(graphEdge);
        return property.isNavigable();
    }

    public static AggregationKind getAggregationKind(GraphEdge graphEdge) {
        Property property = ModelUtil.getFromProperty(graphEdge);
        if (property != null) {
            return property.getAggregation();
        }
        return null;
    }

    public static abstract class ModelVisitor {
        public void visit(Element element) {
            this.operation(element);
            EList list = new ArrayList();
            ArrayList<Classifier> interfaceList = new ArrayList<Classifier>();
            ArrayList<Classifier> classList = new ArrayList<Classifier>();
            switch (ModelUtil.getClassifierID(element)) {
                case 60: {
                    Model m = (Model)element;
                    list = m.getOwnedMembers();
                    break;
                }
                case 16: {
                    Package p = (Package)element;
                    list = p.getOwnedMembers();
                    break;
                }
                case 10: {
                    Class c = (Class)element;
                    Iterator i = c.getNestedClassifiers().iterator();
                    while (i.hasNext()) {
                        Classifier nestedClassifier = (Classifier)i.next();
                        if (nestedClassifier instanceof Interface) {
                            interfaceList.add(nestedClassifier);
                            continue;
                        }
                        classList.add(nestedClassifier);
                    }
                    list.addAll(interfaceList);
                    list.addAll(classList);
                    list.addAll(c.getOwnedAttributes());
                    list.addAll(c.getOwnedOperations());
                    list.addAll(c.getImplementations());
                    list.addAll(c.getGeneralizations());
                    break;
                }
                case 84: {
                    Interface intf = (Interface)element;
                    Iterator i = intf.getNestedClassifiers().iterator();
                    while (i.hasNext()) {
                        Classifier nestedClassifier = (Classifier)i.next();
                        if (nestedClassifier instanceof Interface) {
                            interfaceList.add(nestedClassifier);
                            continue;
                        }
                        classList.add(nestedClassifier);
                    }
                    list.addAll(interfaceList);
                    list.addAll(classList);
                    list.addAll(intf.getOwnedAttributes());
                    list.addAll(intf.getOwnedOperations());
                    list.addAll(intf.getGeneralizations());
                    break;
                }
                case 12: 
                case 13: 
                case 36: 
                case 40: 
                case 51: 
                case 85: {
                    break;
                }
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.visit((Element)i.next());
            }
        }

        public abstract void operation(Element var1);
    }

    static class Uml2Comparator
    implements Comparator {
        Uml2Comparator() {
        }

        public int compare(Object o1, Object o2) {
            NamedElement e1 = (NamedElement)o1;
            NamedElement e2 = (NamedElement)o2;
            return e1.getName().compareTo(e2.getName());
        }
    }

    static class DocComparator
    implements Comparator {
        DocComparator() {
        }

        public int compare(Object o1, Object o2) {
            Doc d1 = (Doc)o1;
            Doc d2 = (Doc)o2;
            return d1.name().compareTo(d2.name());
        }
    }
}

