/*
 * Decompiled with CFR 0.152.
 */
package latte.util;

import java.io.InputStream;
import latte.Latte;
import latte.action.AbstractLatteAction;
import latte.view.LVDiag;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class GuiUtil {
    public static final String[] LATTE_EXTENTION = new String[]{"*.lat", "*.*"};
    public static final String[] XMI_EXTENTION = new String[]{"*.xml", "*.xmi", "*.*"};
    public static final String[] RXP_EXTENTION = new String[]{"*.rxp", "*.*"};
    private static Display display_ = null;
    private static Shell shell_ = null;

    public static void syncExce(Runnable runnable) {
        display_.syncExec(runnable);
    }

    public static String showNoteDialog(String initNote) {
        final String[] note = new String[1];
        final Shell dialog = GuiUtil.createDialog(400, 300, "\u30ce\u30fc\u30c8\u5165\u529b");
        final Text noteTxt = GuiUtil.createMultilineTextInForm(dialog, 0, 0, 350, 180);
        noteTxt.setText(initNote);
        SelectionAdapter ok = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                note[0] = noteTxt.getText();
                dialog.close();
            }
        };
        SelectionAdapter cancel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                dialog.close();
            }
        };
        GuiUtil.createButtonInForm(dialog, "OK", 100, 260, 90, 30, (SelectionListener)ok);
        GuiUtil.createButtonInForm(dialog, "\u30ad\u30e3\u30f3\u30bb\u30eb", 210, 260, 90, 30, (SelectionListener)cancel);
        dialog.open();
        while (!dialog.isDisposed()) {
            if (display_.readAndDispatch()) continue;
            display_.sleep();
        }
        return note[0];
    }

    public static void setWaitMouseCursor() {
        display_.syncExec(new Runnable(){

            public void run() {
                shell_.setCursor(new Cursor((Device)display_, 1));
            }
        });
    }

    public static void setNormalMouseCursor() {
        display_.syncExec(new Runnable(){

            public void run() {
                shell_.setCursor(null);
            }
        });
    }

    public static Button createButtonInForm(Shell dialog, String text, int x, int y, int width, int height, SelectionListener listener) {
        Button b = new Button((Composite)dialog, 0);
        b.setText(text);
        GuiUtil.setBoundInForm(dialog, (Control)b, x, y, width, height);
        if (listener != null) {
            b.addSelectionListener(listener);
        }
        return b;
    }

    public static Label createLabelInForm(Shell dialog, String text, int x, int y, int width, int height) {
        Label l = new Label((Composite)dialog, 0);
        l.setText(text);
        GuiUtil.setBoundInForm(dialog, (Control)l, x, y, width, height);
        return l;
    }

    public static Text createTextInForm(Shell dialog, int x, int y, int width, int height) {
        Text t = new Text((Composite)dialog, 2052);
        GuiUtil.setBoundInForm(dialog, (Control)t, x, y, width, height);
        return t;
    }

    public static Text createMultilineTextInForm(Shell dialog, int x, int y, int width, int height) {
        Text t = new Text((Composite)dialog, 2818);
        GuiUtil.setBoundInForm(dialog, (Control)t, x, y, width, height);
        return t;
    }

    public static void setBoundInForm(Shell dialog, Control c, int x, int y, int width, int height) {
        FormData fd = new FormData(width, height);
        fd.left = new FormAttachment(x, dialog.getSize().x, 0);
        fd.top = new FormAttachment(y, dialog.getSize().y, 0);
        c.setLayoutData((Object)fd);
    }

    public static Shell createDialog(int width, int height, String title) {
        Shell dialog = new Shell(shell_, 67680);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialog.setLayout((Layout)layout);
        dialog.setSize(width, height);
        Rectangle diagRect = dialog.getBounds();
        Rectangle dispRect = display_.getBounds();
        int x = (dispRect.width - diagRect.width) / 2;
        int y = (dispRect.height - diagRect.height) / 2;
        dialog.setLocation(x, y);
        dialog.setText(title);
        return dialog;
    }

    public static Color getColor(int color) {
        Display d = shell_.getDisplay();
        return d.getSystemColor(color);
    }

    public static void createMenuItem(Menu menu, AbstractLatteAction laction) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(laction.getTitle());
        menuItem.setImage(laction.getImage());
        menuItem.addSelectionListener((SelectionListener)laction);
        laction.addListener((Item)menuItem);
    }

    public static MenuItem createCheckMenuItem(Menu menu, AbstractLatteAction laction, boolean b) {
        MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setSelection(b);
        menuItem.setText(laction.getTitle());
        menuItem.setImage(laction.getImage());
        menuItem.addSelectionListener((SelectionListener)laction);
        laction.addListener((Item)menuItem);
        return menuItem;
    }

    public static Menu createMenu(Menu menuBar, String title) {
        MenuItem menuItem = new MenuItem(menuBar, 64);
        menuItem.setText(title);
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        return menu;
    }

    public static void createCoolItem(CoolBar coolbar, Control control) {
        CoolItem coolItem = new CoolItem(coolbar, 8);
        coolItem.setControl(control);
        Point pt = control.computeSize(-1, -1);
        pt = coolItem.computeSize(pt.x, pt.y);
        coolItem.setSize(pt);
    }

    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction, boolean selected) {
        ToolItem item = new ToolItem(toolBar, style);
        item.setImage(laction.getImage());
        item.setToolTipText(laction.getTitle());
        item.addSelectionListener((SelectionListener)laction);
        item.setSelection(selected);
        laction.addListener((Item)item);
    }

    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction) {
        GuiUtil.createToolbarItem(toolBar, style, laction, false);
    }

    public static Image createImage(InputStream is) {
        Image image = new Image((Device)shell_.getDisplay(), is);
        ImageData mask = image.getImageData().getTransparencyMask();
        return new Image((Device)shell_.getDisplay(), image.getImageData(), mask);
    }

    public static String openFileDialog(int mode, String[] extention) {
        FileDialog dialog = new FileDialog(shell_, mode);
        dialog.setFilterExtensions(extention);
        return dialog.open();
    }

    public static String openFileDialog(int mode) {
        return GuiUtil.openFileDialog(mode, LATTE_EXTENTION);
    }

    public static String openDirectoryDialog(String msg) {
        DirectoryDialog dialog = new DirectoryDialog(shell_);
        dialog.setMessage(msg);
        return dialog.open();
    }

    public static PrinterData openPrintDialog() {
        PrintDialog dialog = new PrintDialog(shell_);
        return dialog.open();
    }

    public static void init(Display display, Shell shell) {
        display_ = display;
        shell_ = shell;
    }

    public static Font getBoldFont() {
        Font f = shell_.getFont();
        FontData[] fds = f.getFontData();
        fds[0].setStyle(1);
        return new Font(null, fds[0]);
    }

    public static Font getItalicBoldFont() {
        Font f = shell_.getFont();
        FontData[] fds = f.getFontData();
        fds[0].setStyle(3);
        return new Font(null, fds[0]);
    }

    public static Font getItalicFont() {
        Font f = shell_.getFont();
        FontData[] fds = f.getFontData();
        fds[0].setStyle(2);
        return new Font(null, fds[0]);
    }

    public static LVDiag getSelectedLVDiag() {
        return Latte.getMainForm().getDiagFolder().getSelectedDiag();
    }

    public static int stringExtent(String s) {
        GC gc = new GC((Drawable)shell_);
        int x = gc.stringExtent((String)s).x;
        gc.dispose();
        return x;
    }
}

