/*
 * Decompiled with CFR 0.152.
 */
package latte.action;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import latte.Latte;
import latte.action.AbstractLatteAction;
import latte.util.GuiUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ToolRoseImportAction
extends AbstractLatteAction {
    private static String WITHID = " with id ";
    private static String NOTEVIEW = " NoteView @ ";
    private static int RATE = 4;
    private Shell dialog_ = null;
    private Text xmiFileTxt_ = null;
    private Text rxpFileTxt_ = null;

    public ToolRoseImportAction(String title, String imageFile) {
        super(title, imageFile);
    }

    public void execMain(Object param) {
        try {
            Latte.getLatteData().checkSaving();
            this.showDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDialog() {
        this.dialog_ = GuiUtil.createDialog(600, 200, this.getTitle());
        GuiUtil.createLabelInForm(this.dialog_, "XMI\u30d5\u30a1\u30a4\u30eb", 20, 22, 60, 13);
        this.xmiFileTxt_ = GuiUtil.createTextInForm(this.dialog_, 85, 20, 400, 13);
        GuiUtil.createButtonInForm(this.dialog_, "\u53c2\u7167", 515, 20, 40, 20, (SelectionListener)new XmiFileDiagSelection());
        GuiUtil.createLabelInForm(this.dialog_, "RXP\u30d5\u30a1\u30a4\u30eb", 20, 52, 60, 13);
        this.rxpFileTxt_ = GuiUtil.createTextInForm(this.dialog_, 85, 50, 400, 13);
        GuiUtil.createButtonInForm(this.dialog_, "\u53c2\u7167", 515, 50, 40, 20, (SelectionListener)new RxpFileDiagSelection());
        GuiUtil.createLabelInForm(this.dialog_, "RXP\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3059\u308b\u3068\u65e5\u672c\u8a9e\u306e\u6587\u5b57\u5316\u3051\u304c\u89e3\u6d88\u3055\u308c\u307e\u3059", 85, 80, 400, 30);
        GuiUtil.createButtonInForm(this.dialog_, "IMPORT", 200, 140, 90, 30, (SelectionListener)new ImportSelection());
        GuiUtil.createButtonInForm(this.dialog_, "\u30ad\u30e3\u30f3\u30bb\u30eb", 310, 140, 90, 30, (SelectionListener)new CancelSelection());
        this.dialog_.open();
    }

    private Map readRxpFile(String file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        int index = -1;
        String key = null;
        String value = null;
        while ((line = reader.readLine()) != null) {
            index = line.lastIndexOf(WITHID);
            if (index != -1) {
                key = line.substring(index + WITHID.length());
                value = line.split("'")[1];
                map.put(key, value);
                continue;
            }
            index = line.lastIndexOf(NOTEVIEW);
            if (index == -1) continue;
            key = line.substring(index + NOTEVIEW.length());
            value = reader.readLine().substring(7);
            map.put(key, value);
        }
        return map;
    }

    private void changeRose2Latte() {
    }

    private String convGeometry(String roseGeo) {
        String[] s = roseGeo.split(",");
        int x = Integer.parseInt(s[0].trim()) / RATE;
        int y = Integer.parseInt(s[1].trim()) / RATE;
        int w = Integer.parseInt(s[2].trim()) / RATE;
        int h = Integer.parseInt(s[3].trim()) / RATE;
        String latteGeo = String.valueOf(x) + ", " + y + ", " + w + ", " + h;
        return latteGeo;
    }

    private void reflectSymbol(Map symbol) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
    }

    class ImportSelection
    extends SelectionAdapter {
        ImportSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
        }
    }

    class CancelSelection
    extends SelectionAdapter {
        CancelSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
            ToolRoseImportAction.this.dialog_.close();
        }
    }

    class XmiFileDiagSelection
    extends SelectionAdapter {
        XmiFileDiagSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
            String openFile = GuiUtil.openFileDialog(4096, GuiUtil.XMI_EXTENTION);
            if (openFile == null) {
                return;
            }
            ToolRoseImportAction.this.xmiFileTxt_.setText(openFile);
        }
    }

    class RxpFileDiagSelection
    extends SelectionAdapter {
        RxpFileDiagSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
            String openFile = GuiUtil.openFileDialog(4096, GuiUtil.RXP_EXTENTION);
            if (openFile == null) {
                return;
            }
            ToolRoseImportAction.this.rxpFileTxt_.setText(openFile);
        }
    }
}

