/*
 * Decompiled with CFR 0.152.
 */
package latte.action;

import latte.InternalLogicException;
import latte.Latte;
import latte.action.AbstractLatteAction;
import latte.action.mm.AllManip;
import latte.di.CoreSemanticModelBridge;
import latte.di.Diagram;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Artifact;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.BehavioredClassifier;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Comment;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.Dependency;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Implementation;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Signal;
import org.eclipse.uml2.StructuredClassifier;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.internal.operation.ClassifierOperations;
import org.eclipse.uml2.util.UML2Switch;

public class AddRelationAction
extends AbstractLatteAction {
    public AddRelationAction(String title, String imageFile) {
        super(title, imageFile);
    }

    public void execMain(Object param) {
        try {
            int mode = Integer.parseInt((String)((Object[])param)[0]);
            GraphNode fromGraphNode = (GraphNode)((Object[])param)[1];
            GraphNode toGraphNode = (GraphNode)((Object[])param)[2];
            this.check(mode, fromGraphNode, toGraphNode);
            switch (mode) {
                case 2: {
                    this.createAssociation(fromGraphNode, toGraphNode);
                    break;
                }
                case 5: {
                    this.createDependency(fromGraphNode, toGraphNode);
                    break;
                }
                case 3: {
                    this.createGenelization(fromGraphNode, toGraphNode);
                    break;
                }
                case 4: {
                    this.createImplementation(fromGraphNode, toGraphNode);
                    break;
                }
                case 6: {
                    this.createNotelink(fromGraphNode, toGraphNode);
                    break;
                }
                default: {
                    throw new InternalLogicException("\u4e0d\u6b63\u306a\u30e2\u30fc\u30c9");
                }
            }
            ModelUtil.setNeedSaving();
        }
        catch (IllegalArgumentException e) {
            LogUtil.write("\u30e2\u30c7\u30eb\u4f5c\u6210\u5931\u6557", e);
            MsgUtil.showMsg(e.getMessage());
        }
        catch (Exception e) {
            LogUtil.write("\u95a2\u4fc2\u4f5c\u6210\u5931\u6557", e);
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u767a\u751f\uff1a" + e.getMessage());
        }
    }

    private void check(int mode, GraphNode fromNode, GraphNode toNode) {
        Element fromDef = ModelUtil.getElement(fromNode);
        Element toDef = ModelUtil.getElement(toNode);
        switch (mode) {
            case 2: {
                if (ModelUtil.getClassifierID(fromDef) == 7 || ModelUtil.getClassifierID(toDef) == 7) {
                    throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30ce\u30fc\u30c8\u306b\u95a2\u9023\u4ed8\u3051\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059");
                }
                if (ModelUtil.getClassifierID(fromDef) != 84) break;
                throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30a4\u30b9\u306b\u95a2\u9023\u3092\u6301\u305f\u305b\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059");
            }
            case 5: {
                if (ModelUtil.getClassifierID(fromDef) != 7 && ModelUtil.getClassifierID(toDef) != 7) break;
                throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30ce\u30fc\u30c8\u306b\u4f9d\u5b58\u3055\u305b\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059");
            }
            case 3: {
                if (ModelUtil.getClassifierID(fromDef) == 7 || ModelUtil.getClassifierID(toDef) == 7) {
                    throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30ce\u30fc\u30c8\u306b\u6c4e\u5316\u3055\u305b\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059");
                }
                if (ModelUtil.getClassifierID(fromDef) == 84 && ModelUtil.getClassifierID(toDef) != 84 || ModelUtil.getClassifierID(toDef) == 84 && ModelUtil.getClassifierID(fromDef) != 84) {
                    throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30a4\u30b9\u3068\u5225\u306e\u578b\u3092\u6c4e\u5316\u3055\u305b\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059");
                }
                if ((ModelUtil.getClassifierID(fromDef) != 10 || ModelUtil.getClassifierID(toDef) == 10) && (ModelUtil.getClassifierID(toDef) != 10 || ModelUtil.getClassifierID(fromDef) == 10)) break;
                throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30af\u30e9\u30b9\u3068\u5225\u306e\u578b\u3092\u6c4e\u5316\u3055\u305b\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059");
            }
            case 4: {
                if (ModelUtil.getClassifierID(fromDef) == 10 && ModelUtil.getClassifierID(toDef) == 84) break;
                throw new IllegalArgumentException("\u7121\u52b9\uff1a\u5b9f\u88c5\u95a2\u4fc2\u304c\u4e0d\u6b63\u3067\u3059");
            }
            case 6: {
                if (ModelUtil.getClassifierID(fromDef) != 7 && ModelUtil.getClassifierID(toDef) != 7) {
                    throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30ce\u30fc\u30c8\u30ea\u30f3\u30af\u304c\u4e0d\u6b63\u3067\u3059");
                }
                if (ModelUtil.getClassifierID(fromDef) != 7 || ModelUtil.getClassifierID(toDef) != 7) break;
                throw new IllegalArgumentException("\u7121\u52b9\uff1a\u30ce\u30fc\u30c8\u30ea\u30f3\u30af\u304c\u4e0d\u6b63\u3067\u3059");
            }
            default: {
                throw new InternalLogicException("\u4e0d\u6b63\u306a\u30e2\u30fc\u30c9");
            }
        }
    }

    private void createAssociation(GraphNode fromGraphNode, GraphNode toGraphNode) {
        Class fromElement = (Class)ModelUtil.getElement(fromGraphNode);
        String fromName = fromElement.getName();
        int fromLower = 0;
        int fromUpper = 1;
        Classifier toElement = (Classifier)ModelUtil.getElement(toGraphNode);
        String toName = toElement.getName();
        int toLower = 0;
        int toUpper = 1;
        AggregationKind AK = AggregationKind.NONE_LITERAL;
        Association ass = this.createAssociation((Type)fromElement, true, AK, fromName, fromLower, fromUpper, (Type)toElement, false, AK, toName, toLower, toUpper);
        Property fromProperty = this.createAssociationEnd(ass, (Type)fromElement, true, AK, fromName, fromLower, fromUpper, (Type)toElement);
        this.createAssociationEnd(ass, (Type)toElement, false, AK, toName, toLower, toUpper, (Type)fromElement);
        this.createAndAddGraphEdge(fromGraphNode, toGraphNode, (Element)ass);
    }

    private void createGenelization(GraphNode fromGraphNode, GraphNode toGraphNode) {
        Classifier specificClassifier = (Classifier)ModelUtil.getElement(fromGraphNode);
        Classifier generalClassifier = (Classifier)ModelUtil.getElement(toGraphNode);
        Generalization gen = ClassifierOperations.createGeneralization((Classifier)specificClassifier, (Classifier)generalClassifier);
        this.createAndAddGraphEdge(fromGraphNode, toGraphNode, (Element)gen);
    }

    private void createDependency(GraphNode fromGraphNode, GraphNode toGraphNode) {
        NamedElement clientElement = (NamedElement)ModelUtil.getElement(fromGraphNode);
        NamedElement supplierElement = (NamedElement)ModelUtil.getElement(toGraphNode);
        Dependency dep = ModelUtil.Uml2Factory.createDependency();
        dep.getSuppliers().add((Object)supplierElement);
        dep.getClients().add((Object)clientElement);
        Classifier clientClassifier = (Classifier)clientElement;
        clientClassifier.getPackage().getOwnedMembers().add((Object)dep);
        this.createAndAddGraphEdge(fromGraphNode, toGraphNode, (Element)dep);
    }

    private void createImplementation(GraphNode fromGraphNode, GraphNode toGraphNode) {
        BehavioredClassifier behavioredClassifier = (BehavioredClassifier)ModelUtil.getElement(fromGraphNode);
        Interface inter = (Interface)ModelUtil.getElement(toGraphNode);
        Implementation imp = ModelUtil.Uml2Factory.createImplementation();
        imp.setContract(inter);
        imp.setImplementingClassifier(behavioredClassifier);
        this.createAndAddGraphEdge(fromGraphNode, toGraphNode, (Element)imp);
    }

    private void createNotelink(GraphNode fromGraphNode, GraphNode toGraphNode) {
        Element element = null;
        Comment comment = null;
        Element fromElement = ModelUtil.getElement(fromGraphNode);
        Element toElement = ModelUtil.getElement(toGraphNode);
        switch (ModelUtil.getClassifierID(fromElement)) {
            case 7: {
                comment = (Comment)fromElement;
                element = toElement;
                break;
            }
            default: {
                comment = (Comment)toElement;
                element = fromElement;
            }
        }
        comment.getAnnotatedElements().add((Object)element);
        this.createAndAddGraphEdge(fromGraphNode, toGraphNode, (Element)comment);
    }

    private void createAndAddGraphEdge(GraphNode fromGraphNode, GraphNode toGraphNode, Element element) {
        GraphEdge graphEdge = ModelUtil.DiFactory.createGraphEdge();
        CoreSemanticModelBridge uml2ModelBridge = ModelUtil.DiFactory.createCoreSemanticModelBridge();
        uml2ModelBridge.setElement(element);
        graphEdge.setSemanticModel(uml2ModelBridge);
        GraphConnector fromGraphConnector = ModelUtil.DiFactory.createGraphConnector();
        GraphConnector toGraphConnector = ModelUtil.DiFactory.createGraphConnector();
        fromGraphConnector.setGraphElement(fromGraphNode);
        toGraphConnector.setGraphElement(toGraphNode);
        graphEdge.getAnchor().add((Object)fromGraphConnector);
        graphEdge.getAnchor().add((Object)toGraphConnector);
        Diagram diagram = GuiUtil.getSelectedLVDiag().getDiagram();
        diagram.getContained().add((Object)graphEdge);
    }

    private Association createAssociation(Type type1, boolean end1IsNavigable, AggregationKind end1Aggregation, String end1Name, int end1LowerBound, int end1UpperBound, Type type2, boolean end2IsNavigable, AggregationKind end2Aggregation, String end2Name, int end2LowerBound, int end2UpperBound) {
        if (type1 == null || type1.getPackage() == null) {
            throw new IllegalArgumentException(String.valueOf(type1));
        }
        if (end1IsNavigable && this.getOwnedAttributes(type1) == null) {
            throw new IllegalArgumentException(String.valueOf(type1));
        }
        if (end1Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf(end1Aggregation));
        }
        if (end1LowerBound < 0) {
            throw new IllegalArgumentException(String.valueOf(end1LowerBound));
        }
        if (-1 != end1UpperBound && (end1UpperBound == 0 || end1LowerBound > end1UpperBound)) {
            throw new IllegalArgumentException(String.valueOf(end1UpperBound));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.valueOf(type2));
        }
        if (end2IsNavigable && this.getOwnedAttributes(type2) == null) {
            throw new IllegalArgumentException(String.valueOf(type2));
        }
        if (end2Aggregation == null) {
            throw new IllegalArgumentException(String.valueOf(end2Aggregation));
        }
        if (end2LowerBound < 0) {
            throw new IllegalArgumentException(String.valueOf(end2LowerBound));
        }
        if (-1 != end2UpperBound && (end2UpperBound == 0 || end2LowerBound > end2UpperBound)) {
            throw new IllegalArgumentException(String.valueOf(end2UpperBound));
        }
        Association association = (Association)type1.getPackage().createOwnedMember(UML2Package.eINSTANCE.getAssociation());
        return association;
    }

    private EList getOwnedAttributes(Type type) {
        if (type == null) {
            return null;
        }
        return (EList)new UML2Switch(){

            public Object caseArtifact(Artifact object) {
                return object.getOwnedAttributes();
            }

            public Object caseDataType(DataType object) {
                return object.getOwnedAttributes();
            }

            public Object caseInterface(Interface object) {
                return object.getOwnedAttributes();
            }

            public Object caseSignal(Signal object) {
                return object.getOwnedAttributes();
            }

            public Object caseStructuredClassifier(StructuredClassifier object) {
                return object.getOwnedAttributes();
            }
        }.doSwitch((EObject)type);
    }

    private Property createAssociationEnd(Association association, Type type, boolean isNavigable, AggregationKind aggregation, String name, int lowerBound, int upperBound, Type otherEndType) {
        Property associationEnd = null;
        associationEnd = isNavigable ? ModelUtil.Uml2Factory.createProperty() : association.createOwnedEnd(UML2Package.eINSTANCE.getProperty());
        associationEnd.setType(otherEndType);
        associationEnd.setAggregation(aggregation);
        associationEnd.setName(String.valueOf(otherEndType.getName()) + "\u30ed\u30fc\u30eb");
        associationEnd.setUpperBound(upperBound);
        associationEnd.setLowerBound(lowerBound);
        if (isNavigable) {
            associationEnd.eAdapters().add((Object)Latte.getMainForm().getTree());
            association.getMemberEnds().add((Object)associationEnd);
            AllManip.ATTRIBUTE.addDef((EObject)type, (EObject)associationEnd);
        }
        return associationEnd;
    }
}

