/*
 * Decompiled with CFR 0.152.
 */
package latte;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import latte.InternalLogicException;
import latte.action.ActionCancelException;
import latte.action.AllAction;
import latte.di.Diagram;
import latte.di.impl.DIFactoryImpl;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PrimitiveType;

public class LatteData {
    private boolean isNeedSaving_ = false;
    private File file_ = null;
    private Model model_ = null;
    private Diagram diagrams_ = null;
    private Package primitiveTypes_ = null;
    private Package enumerationTypes_ = null;
    private Package trashType_ = null;
    private String NAME_MODEL = "\u30e2\u30c7\u30eb";
    private String NAME_DIAGRAM = "\u30c0\u30a4\u30a2\u30b0\u30e9\u30e0";
    private String NAME_PRIMITIVE = "\u30d7\u30ea\u30df\u30c6\u30a3\u30d6\u578b";
    private String NAME_ENUMERATION = "\u5217\u6319\u578b";
    private String NAME_TRASH = "\u524a\u9664\u3055\u308c\u305f\u578b";
    private HashMap qualifiedName2ElementMapping_ = new HashMap();
    private static final String ENCODING = "Shift_JIS";

    public LatteData() {
        LogUtil.writeln("LatteData.LatteData() start");
        this.model_ = ModelUtil.Uml2Factory.createModel();
        this.model_.setName(this.NAME_MODEL);
        this.diagrams_ = DIFactoryImpl.eINSTANCE.createDiagram();
        this.diagrams_.setName(this.NAME_DIAGRAM);
        this.primitiveTypes_ = ModelUtil.Uml2Factory.createPackage();
        this.primitiveTypes_.setName(this.NAME_PRIMITIVE);
        this.createAndAddPrimitiveTypes();
        this.enumerationTypes_ = ModelUtil.Uml2Factory.createPackage();
        this.enumerationTypes_.setName(this.NAME_ENUMERATION);
        this.trashType_ = ModelUtil.Uml2Factory.createPackage();
        this.trashType_.setName(this.NAME_TRASH);
        LogUtil.writeln("LatteData.LatteData() end");
    }

    public void checkSaving() throws ActionCancelException, IOException {
        if (!this.isNeedSaving_) {
            return;
        }
        int ret = MsgUtil.showYesNoCancelMsg("\u30c7\u30fc\u30bf\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f");
        switch (ret) {
            case 64: {
                break;
            }
            case 128: {
                return;
            }
            case 256: {
                throw new ActionCancelException();
            }
        }
        AllAction.FILE_SAVE.execute(null);
    }

    public void destroy() throws ActionCancelException, IOException {
    }

    public void load() throws Exception {
        if (this.file_ == null) {
            throw new IllegalStateException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource res = resSet.getResource(URI.createURI((String)("file:///" + this.file_.getAbsolutePath())), true);
        EList eList = res.getContents();
        Iterator ite = eList.iterator();
        while (ite.hasNext()) {
            Object o = ite.next();
            if (o instanceof Model) {
                this.model_ = (Model)o;
                continue;
            }
            if (o instanceof Diagram) {
                this.diagrams_ = (Diagram)o;
                continue;
            }
            if (!(o instanceof Package)) continue;
            Package p = (Package)o;
            if (p.getName().equals(this.NAME_PRIMITIVE)) {
                this.primitiveTypes_ = p;
                continue;
            }
            if (p.getName().equals(this.NAME_ENUMERATION)) {
                this.enumerationTypes_ = p;
                continue;
            }
            if (!p.getName().equals(this.NAME_TRASH)) continue;
            this.trashType_ = p;
        }
        this.qualifiedName2ElementMapping_.clear();
        Iterator i = this.model_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            this.addAllElementByQualifiedName((Element)i.next());
        }
        i = this.primitiveTypes_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            PrimitiveType pt = (PrimitiveType)i.next();
            this.addElementByQualifiedName(pt.getName(), (Element)pt);
        }
        i = this.enumerationTypes_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            this.addElementByQualifiedName((NamedElement)((Enumeration)i.next()));
        }
        i = this.trashType_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            this.addElementByQualifiedName((NamedElement)i.next());
        }
        this.isNeedSaving_ = false;
    }

    private void addAllElementByQualifiedName(Element element) {
        EList list = new ArrayList();
        ArrayList<Classifier> interfaceList = new ArrayList<Classifier>();
        ArrayList<Classifier> classList = new ArrayList<Classifier>();
        switch (ModelUtil.getClassifierID(element)) {
            case 16: {
                Package p = (Package)element;
                list = p.getOwnedMembers();
                break;
            }
            case 10: {
                Class c = (Class)element;
                this.addElementByQualifiedName((NamedElement)c);
                Iterator i = c.getNestedClassifiers().iterator();
                while (i.hasNext()) {
                    Classifier nestedClassifier = (Classifier)i.next();
                    if (nestedClassifier instanceof Interface) {
                        interfaceList.add(nestedClassifier);
                        continue;
                    }
                    classList.add(nestedClassifier);
                }
                list.addAll(interfaceList);
                list.addAll(classList);
                list.addAll(c.getOwnedAttributes());
                list.addAll(c.getOwnedOperations());
                break;
            }
            case 84: {
                Interface intf = (Interface)element;
                this.addElementByQualifiedName((NamedElement)intf);
                Iterator i = intf.getNestedClassifiers().iterator();
                while (i.hasNext()) {
                    Classifier nestedClassifier = (Classifier)i.next();
                    if (nestedClassifier instanceof Interface) {
                        interfaceList.add(nestedClassifier);
                        continue;
                    }
                    classList.add(nestedClassifier);
                }
                list.addAll(interfaceList);
                list.addAll(classList);
                list.addAll(intf.getOwnedAttributes());
                list.addAll(intf.getOwnedOperations());
                break;
            }
            case 12: 
            case 13: 
            case 36: 
            case 40: 
            case 51: 
            case 85: {
                break;
            }
            default: {
                throw new InternalLogicException("TreeItem\u4f5c\u6210\u5931\u6557 : " + element);
            }
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.addAllElementByQualifiedName((Element)i.next());
        }
    }

    public void setNeedSaving() {
        this.isNeedSaving_ = true;
    }

    public void save() throws IllegalStateException, IOException {
        if (this.file_ == null) {
            throw new IllegalStateException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        ResourceSetImpl resSet = new ResourceSetImpl();
        XMIResource res = (XMIResource)resSet.createResource(URI.createURI((String)("file:///" + this.file_.getAbsolutePath())));
        res.getContents().add((Object)this.model_);
        res.getContents().add((Object)this.diagrams_);
        res.getContents().add((Object)this.primitiveTypes_);
        res.getContents().add((Object)this.enumerationTypes_);
        res.getContents().add((Object)this.trashType_);
        res.setEncoding(ENCODING);
        res.save(null);
        this.isNeedSaving_ = false;
    }

    public void addElementByQualifiedName(NamedElement ne) {
        String qname = ne.qualifiedName().replaceFirst("^\u30e2\u30c7\u30eb::", "").replaceAll("::", ".");
        this.addElementByQualifiedName(qname, (Element)ne);
    }

    public void moveToTrash(NamedElement ne) {
        Element owner = ne.getOwner();
        switch (ModelUtil.getClassifierID(owner)) {
            case 60: {
                Model m = (Model)owner;
                m.getOwnedMembers().remove((Object)ne);
                break;
            }
        }
        this.trashType_.getOwnedMembers().add((Object)ne);
    }

    public void addElementByQualifiedName(String qualifiedName, Element element) {
        LogUtil.writeln("LatteData.addElementByQualifiedName(" + qualifiedName + ")");
        this.qualifiedName2ElementMapping_.put(qualifiedName, element);
    }

    public Element lookupElementByQualifiedName(String qualifiedName) {
        return (Element)this.qualifiedName2ElementMapping_.get(qualifiedName);
    }

    public File getFile() {
        return this.file_;
    }

    public void setFile(File file) {
        this.file_ = file;
    }

    public Diagram getDiagrams() {
        return this.diagrams_;
    }

    public Model getModel() {
        return this.model_;
    }

    public Package getPrimitiveTypes() {
        return this.primitiveTypes_;
    }

    public PrimitiveType lookupPrimitiveTypes(String name) {
        Iterator i = this.primitiveTypes_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            PrimitiveType pt = (PrimitiveType)i.next();
            if (!pt.getName().equals(name)) continue;
            return pt;
        }
        return null;
    }

    private void createAndAddPrimitiveTypes() {
        this.createAndAddPrimitiveType("void");
        this.createAndAddPrimitiveType("boolean");
        this.createAndAddPrimitiveType("char");
        this.createAndAddPrimitiveType("byte");
        this.createAndAddPrimitiveType("short");
        this.createAndAddPrimitiveType("int");
        this.createAndAddPrimitiveType("long");
        this.createAndAddPrimitiveType("float");
        this.createAndAddPrimitiveType("double");
    }

    private void createAndAddPrimitiveType(String name) {
        LogUtil.writeln("LatteData.createAndAddPrimitiveType(" + name + ")");
        PrimitiveType pt = ModelUtil.Uml2Factory.createPrimitiveType();
        pt.setName(name);
        LogUtil.writeln("  ->" + pt);
        this.primitiveTypes_.getOwnedMembers().add((Object)pt);
        this.addElementByQualifiedName(pt.getName(), (Element)pt);
    }

    public Enumeration createAndAddEnumerationType(String name) {
        LogUtil.writeln("LatteData.createAndAddEnumerationType(" + name + ")");
        Enumeration e = ModelUtil.Uml2Factory.createEnumeration();
        e.setName(name);
        this.enumerationTypes_.getOwnedMembers().add((Object)e);
        this.addElementByQualifiedName((NamedElement)e);
        return e;
    }

    public Enumeration lookupEnumeraion(String name) {
        Iterator i = this.enumerationTypes_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            Enumeration e = (Enumeration)i.next();
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public void removeEnumeraion(String name) {
        Enumeration e = this.lookupEnumeraion(name);
        if (e != null) {
            this.enumerationTypes_.getOwnedMembers().remove((Object)e);
        }
    }
}

