/*
 * Decompiled with CFR 0.152.
 */
package latte;

import latte.LatteData;
import latte.action.AllAction;
import latte.di.CoreSemanticModelBridge;
import latte.di.DIFactory;
import latte.di.Diagram;
import latte.di.GraphNode;
import latte.di.SimpleSemanticModelElement;
import latte.di.impl.DIPackageImpl;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.view.MainForm;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.impl.UML2PackageImpl;
import org.eclipse.uml2.internal.util.UML2ResourceFactoryImpl;

public class Latte {
    private static MainForm mainForm_ = null;
    private static LatteData latteData_ = null;
    public static boolean TRACE_EVENT = false;
    public static boolean LOG_FLUSH = true;
    public static boolean LOG_STDOUT = false;

    public static void main(String[] args) {
        Latte.writeStartLog();
        new Latte();
    }

    private static void writeStartLog() {
        LogUtil.writeln("Latte start!");
        LogUtil.writeln("java.home=" + System.getProperty("java.home"));
        LogUtil.writeln("java.vendor=" + System.getProperty("java.vendor"));
        LogUtil.writeln("java.version=" + System.getProperty("java.version"));
        LogUtil.writeln("java.class.version=" + System.getProperty("java.class.version"));
        LogUtil.writeln("java.class.path=" + System.getProperty("java.class.path"));
        LogUtil.writeln("java.library.path=" + System.getProperty("java.library.path"));
    }

    Latte() {
        this.initLib();
        mainForm_ = new MainForm();
        AllAction.FILE_NEW.execute(null);
        mainForm_.run();
    }

    public static MainForm getMainForm() {
        return mainForm_;
    }

    public static LatteData getLatteData() {
        return latteData_;
    }

    public static void setLatteData(LatteData latteData) {
        latteData_ = latteData;
    }

    private void initLib() {
        UML2PackageImpl.init();
        DIPackageImpl.init();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/uml2/1.0.0/UML", (Object)UML2Package.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("lat", new UML2ResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    class TestAdapter
    extends AdapterImpl {
        TestAdapter() {
        }

        public void notifyChanged(Notification msg) {
            System.out.println("notifyChanged:" + msg);
        }
    }

    class TestModel {
        UML2Factory uml2Factory_ = UML2Factory.eINSTANCE;
        DIFactory diFactory_ = DIFactory.eINSTANCE;
        Model rootModel_ = null;
        Diagram rootDiagram_ = null;
        GraphNode gn;

        TestModel() {
            this.testNavigable();
        }

        private void testNavigable() {
            Model model = UML2Factory.eINSTANCE.createModel();
            Package pkg = (Package)model.createOwnedMember(UML2Package.eINSTANCE.getPackage());
            Class cls1 = (Class)pkg.createOwnedMember(UML2Package.eINSTANCE.getClass_());
            Class cls2 = (Class)pkg.createOwnedMember(UML2Package.eINSTANCE.getClass_());
            cls2.createAssociation(true, AggregationKind.COMPOSITE_LITERAL, "theClass1", 0, -1, (Type)cls1, false, AggregationKind.NONE_LITERAL, "", 1, 1);
            Property prop = (Property)cls2.getOwnedAttributes().get(0);
            System.out.println(prop);
            System.out.println();
            System.out.println("-------1-------");
            this.print(cls1, cls2);
            prop.setNavigable(false);
            System.out.println("-------2-------");
            this.print(cls1, cls2);
            prop.setNavigable(true);
            System.out.println("-------3-------");
            this.print(cls1, cls2);
        }

        private void print(Class cls1, Class cls2) {
            int i = 0;
            while (i < cls1.getOwnedAttributes().size()) {
                System.out.println("cls1 " + i + ":" + cls1.getOwnedAttributes().get(i));
                ++i;
            }
            i = 0;
            while (i < cls2.getOwnedAttributes().size()) {
                System.out.println("cls2 " + i + ":" + cls2.getOwnedAttributes().get(i));
                ++i;
            }
        }

        private void makeTestModel() {
            this.rootModel_ = this.uml2Factory_.createModel();
            this.rootModel_.eAdapters().add((Object)new TestAdapter());
            this.rootModel_.setName("Library\u30e2\u30c7\u30eb");
            Package myPackage = this.uml2Factory_.createPackage();
            myPackage.setName("\u30d1\u30c3\u30b1\u30fc\u30b8");
            this.rootModel_.getOwnedMembers().add((Object)myPackage);
            Class myClass = this.uml2Factory_.createClass();
            myClass.setName("\u30af\u30e9\u30b9");
            myPackage.getOwnedMembers().add((Object)myClass);
            Class myClass2 = this.uml2Factory_.createClass();
            myClass2.setName("\u30af\u30e9\u30b92");
            myPackage.getOwnedMembers().add((Object)myClass2);
            myClass2.createGeneralization((Classifier)myClass);
            myClass2.createAssociation(true, AggregationKind.COMPOSITE_LITERAL, "c1", 0, -1, (Type)myClass, false, AggregationKind.NONE_LITERAL, null, 0, 1);
            this.rootDiagram_ = this.diFactory_.createDiagram();
            this.rootDiagram_.setVisible(true);
            this.rootDiagram_.eAdapters().add((Object)new TestAdapter());
            SimpleSemanticModelElement e1 = this.diFactory_.createSimpleSemanticModelElement();
            this.rootDiagram_.setSemanticModel(e1);
            CoreSemanticModelBridge c1 = this.diFactory_.createCoreSemanticModelBridge();
            c1.setElement((Element)myPackage);
            this.gn = this.diFactory_.createGraphNode();
            this.gn.setSemanticModel(c1);
            this.rootDiagram_.getContained().add((Object)this.gn);
            Class o = this.uml2Factory_.createClass();
            long l3 = System.currentTimeMillis();
            int i = 0;
            while (i < 1000) {
                if (o instanceof Class) {
                    System.out.print("");
                }
                ++i;
            }
            long l4 = System.currentTimeMillis();
            System.out.println("instanceof\u51e6\u7406\u6642\u9593=" + (l4 - l3));
            long l1 = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < 1000) {
                ModelUtil.getClassifierID((EObject)o);
                ++i2;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("ModelUtil.getClassifierID()\u51e6\u7406\u6642\u9593=" + (l2 - l1));
        }

        void saveTestModel() {
            ResourceSetImpl resSet = new ResourceSetImpl();
            XMIResource res = (XMIResource)resSet.createResource(URI.createURI((String)"samples/test.lat"));
            res.getContents().add((Object)this.rootModel_);
            res.getContents().add((Object)this.rootDiagram_);
            try {
                res.setEncoding("Shift_JIS");
                res.save(null);
                System.out.println("Model saved successfully!");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Model save FAILED");
            }
        }
    }
}

