/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public final class CCombo
extends Composite {
    static final int ITEMS_SHOWING = 5;
    Text text;
    List list;
    Shell popup;
    Button arrow;
    boolean hasFocus;

    public CCombo(Composite parent, int style) {
        super(parent, CCombo.checkStyle(style));
        style = this.getStyle();
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.text = new Text(this, textStyle);
        this.popup = new Shell(this.getShell(), 8);
        int listStyle = 516;
        if ((style & 0x800000) != 0) {
            listStyle |= 0x800000;
        }
        this.list = new List(this.popup, listStyle);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button(this, arrowStyle);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (CCombo.this.popup == event.widget) {
                    CCombo.this.popupEvent(event);
                    return;
                }
                if (CCombo.this.text == event.widget) {
                    CCombo.this.textEvent(event);
                    return;
                }
                if (CCombo.this.list == event.widget) {
                    CCombo.this.listEvent(event);
                    return;
                }
                if (CCombo.this.arrow == event.widget) {
                    CCombo.this.arrowEvent(event);
                    return;
                }
                if (CCombo.this == event.widget) {
                    CCombo.this.comboEvent(event);
                    return;
                }
            }
        };
        int[] comboEvents = new int[]{12, 10, 11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], listener);
            ++i;
        }
        int[] popupEvents = new int[]{21, 9, 27};
        int i2 = 0;
        while (i2 < popupEvents.length) {
            this.popup.addListener(popupEvents[i2], listener);
            ++i2;
        }
        int[] textEvents = new int[]{1, 2, 24, 3, 4, 31, 15, 16};
        int i3 = 0;
        while (i3 < textEvents.length) {
            this.text.addListener(textEvents[i3], listener);
            ++i3;
        }
        int[] listEvents = new int[]{4, 13, 31, 1, 2, 15, 16};
        int i4 = 0;
        while (i4 < listEvents.length) {
            this.list.addListener(listEvents[i4], listener);
            ++i4;
        }
        int[] arrowEvents = new int[]{13, 15, 16};
        int i5 = 0;
        while (i5 < arrowEvents.length) {
            this.arrow.addListener(arrowEvents[i5], listener);
            ++i5;
        }
        this.initAccessible();
    }

    static int checkStyle(int style) {
        int mask = 0x800808;
        return style & mask;
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.add(string);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.add(string, index);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (CCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = CCombo.this.getDisplay().getFocusControl();
                        if (focusControl == CCombo.this.list || focusControl == CCombo.this.text) {
                            return;
                        }
                        CCombo.this.hasFocus = false;
                        Event e = new Event();
                        CCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.list.deselectAll();
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                this.popup = null;
                this.text = null;
                this.list = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout();
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        Point textSize = this.text.computeSize(wHint, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        Point listSize = this.list.computeSize(wHint, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(textSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(wHint, Math.max(textSize.x + arrowSize.x + 2 * borderWidth, listSize.x + 2));
        return new Point(width, height);
    }

    public void deselect(int index) {
        this.checkWidget();
        this.list.deselect(index);
    }

    public void deselectAll() {
        this.checkWidget();
        this.list.deselectAll();
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            this.text.setFocus();
            return;
        }
        int index = this.list.getSelectionIndex();
        if (index != -1) {
            this.list.setTopIndex(index);
        }
        Rectangle listRect = this.list.getBounds();
        Point point = this.getParent().toDisplay(this.getLocation());
        Point comboSize = this.getSize();
        int width = Math.max(comboSize.x, listRect.width + 2);
        this.popup.setBounds(point.x, point.y + comboSize.y, width, listRect.height + 2);
        this.popup.setVisible(true);
        this.list.setFocus();
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    boolean getEditable() {
        return this.text.getEditable();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.list.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.list.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.list.getItemHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        return this.list.getItems();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.list.getSelectionIndex();
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.list.indexOf(string);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.list.indexOf(string, start);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = CCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CCombo.this.toControl(new Point(e.x, e.y));
                if (CCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = CCombo.this.getBounds();
                Point pt = CCombo.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = CCombo.this.getText();
            }
        });
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.list.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout() {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height);
        this.text.setBounds(0, 0, width - arrowSize.x, height);
        this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
        Point size = this.getSize();
        int itemHeight = this.list.getItemHeight() * 5;
        Point listSize = this.list.computeSize(-1, itemHeight);
        this.list.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (CCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = CCombo.this.getDisplay().getFocusControl();
                        if (focusControl == CCombo.this.text || focusControl == CCombo.this.arrow) {
                            return;
                        }
                        CCombo.this.hasFocus = false;
                        Event e = new Event();
                        CCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(14, e);
                break;
            }
            case 13: {
                int index = this.list.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.text.setText(this.list.getItem(index));
                this.text.selectAll();
                this.list.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r' || event.character == '\t') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.list.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
            }
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (!all) {
            return;
        }
        Point location = this.text.getLocation();
        this.text.redraw(x - location.x, y - location.y, width, height, all);
        location = this.list.getLocation();
        this.list.redraw(x - location.x, y - location.y, width, height, all);
        if (this.arrow != null) {
            location = this.arrow.getLocation();
            this.arrow.redraw(x - location.x, y - location.y, width, height, all);
        }
    }

    public void remove(int index) {
        this.checkWidget();
        this.list.remove(index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        this.list.remove(start, end);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.text.setText("");
        this.list.removeAll();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.list.deselectAll();
            this.text.setText("");
            return;
        }
        if (index >= 0 && index < this.list.getItemCount() && index != this.getSelectionIndex()) {
            this.text.setText(this.list.getItem(index));
            this.text.selectAll();
            this.list.select(index);
            this.list.showSelection();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.list != null) {
            this.list.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
        this.list.setFont(font);
        this.internalLayout();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.list != null) {
            this.list.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.list.setItem(index, string);
    }

    public void setItems(String[] items) {
        int style;
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
        }
        if (((style = this.getStyle()) & 8) != 0) {
            this.text.setText("");
        }
        this.list.setItems(items);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if ((index = this.list.indexOf(string)) == -1) {
            this.list.deselectAll();
            this.text.setText(string);
            return;
        }
        this.text.setText(string);
        this.text.selectAll();
        this.list.setSelection(index);
        this.list.showSelection();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (CCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = CCombo.this.getDisplay().getFocusControl();
                        if (focusControl == CCombo.this.list || focusControl == CCombo.this.arrow) {
                            return;
                        }
                        CCombo.this.hasFocus = false;
                        Event e = new Event();
                        CCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    int oldIndex = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(oldIndex - 1, 0));
                    } else {
                        this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                    }
                    if (oldIndex != this.getSelectionIndex()) {
                        Event e = new Event();
                        e.time = event.time;
                        e.stateMask = event.stateMask;
                        this.notifyListeners(13, e);
                    }
                    if (this.isDisposed()) break;
                }
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                this.list.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.text.selectAll();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
            }
        }
    }
}

