package jp.sourceforge.larch.core.command
{
    import mx.controls.Alert;
    import mx.rpc.AsyncToken;
    import mx.rpc.IResponder;
    import mx.rpc.events.ResultEvent;

    /**
     * リモートサービス呼び出しコマンド基底クラス
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class RemotingCommand extends Command implements IResponder
    {
        /**
         * コンストラクタ
         * @param aTarget 結果の設定先
         * @param aTargetProperty 結果の設定先のプロパティ名
         */
        public function RemotingCommand(aTarget:Object = null, aTargetProperty:String = null)
        {
            super(aTarget, aTargetProperty);
        }

        /**
         * サブクラスのコマンド処理を実行します。
         */
        override public function execute():void
        {
            doExecute().addResponder(this);
        }

        /**
         * コマンドの処理を実行します。
         * サブクラスにて実装してください。
         * @return 非同期処理のトークン
         */
        protected function doExecute():AsyncToken
        {
            throw new Error("オーバーライド実装してください。");
        }

        /**
         * 非同期処理の正常終了処理です。
         * サブクラスの正常終了処理を実行後、次のコマンドを実行します。
         * @param data 処理結果
         */
        public function result(data:Object):void
        {
            doResult(ResultEvent(data));
            if(nextCommand)
                nextCommand.execute();
        }

        /**
         * 正常終了処理を実行します。
         * サブクラスにて実装してください。
         * @param data 処理結果
         */
        protected function doResult(data:ResultEvent):void
        {
            throw new Error("オーバーライド実装してください。");
        }

        /**
         * 非同期処理の異常終了処理です。
         * 警告を表示します。
         * @param data 処理結果
         */
        public function fault(data:Object):void
        {
            Alert.show(data.toString());
        }
    }
}