<?php
/*!
  \file
  \brief LangUpload 饹

  \author Satofumi KAMIMURA

  $Id$

  \todo ̤顢doxygen оݤ includes/*.php ˤ
*/


/*!
  \brief 桼饹
*/
class UserAuthorize {
  var $reload_action;		//!< ڡɤɬפп
  var $login_fail;		//!< ǧڤ˼Ԥ˿

  // 虜虜ѿˤɬפϡϤʤ
  var $readonly_user;		//!< ѥ桼

  /*!
    \brief 󥹥ȥ饯
  */
  function UserAuthorize() {
    $this->reload_action = false;
    $this->login_fail = false;

    // 桼꤬ʤСѿ򤢤ʤ()˽
    require('config.php');
    $this->readonly_user = isset($readonly_user) ? $readonly_user : array();

    // å򳫻Ϥμ
    session_name('LANGUPLOADSID');
    session_start();

    // Ƚ
    if (isset($_GET['logout_submit'])) {
      $this->logout();
      return;
    }

    // 
    $users = $this->getUserNames();
    if ((isset($_POST['login_submit']) && isset($_POST['login_name'])) &&
	(isset($_POST['login_password']) ||
	 $_POST['login_name'] == $this->readonly_user)) {
      $login_name = $_POST['login_name'];
      if (! $this->login($login_name, $_POST['login_password'])) {
	return;
      }
      // 
      if ($this->isProjectUser()) {
	$_SESSION['brows_name'] = $_SESSION['login_name'];
      } else {
	// 桼ϿκǽΥ桼Ȥ
	$_SESSION['brows_name'] = (count($users) > 0) ?
	  array_shift($users) : '';
      }
    }

    // 桼ѹ
    if (isset($_GET['brows_name'])) {
      // ¸ߤ桼ǧ
      if (in_array($_GET['brows_name'], $users)) {
	$_SESSION['brows_name'] = $_GET['brows_name'];
      }
    }
  }


  // ץȤΥ桼Ƚꤹ
  function isProjectUser() {
    return in_array($_SESSION['login_name'], $this->getUserNames()) ?
      true : false;
  }


  /*!
    \brief 
  */
  function login($name, $password) {

    if (preg_match('/[^A-Za-z0-9_]/', $name)) {
      $this->login_fail = true;
      return false;
    }

    if ($name == $this->readonly_user) {
      $_SESSION['login_name'] = $name;
      $this->reload_action = true;
      $this->login_fail = false;
      return true;
    }

    // ե뤫ѥʸ
    $this->login_fail = true;
    $fp = @fopen($_SESSION['users_file'], 'r');
    if ($fp != false) {
      flock($fp, LOCK_SH);
      while (! feof($fp)) {
	$line = fgets($fp);
	$user = strtok($line, "\n\t ");
	$recorded_password = strtok("\n\t ");
	if ($user == $name) {
	  if (crypt($password, $recorded_password) == $recorded_password) {
	    $_SESSION['login_name'] = $name;
	    $this->reload_action = true;
	    $this->login_fail = false;
	    break;
	  }
	}
      }
      fclose($fp);
    } else {
      // 桼ե뤬¸ߤʤ硢admin ѥɤɲä
      $fp = fopen($_SESSION['users_file'], 'w');
      if ($fp != false) {
	flock($fp, LOCK_EX);
	$line = "admin\t". crypt('admin'). "\n";
	fwrite($fp, $line);
	fclose($fp);
	$_SESSION['login_name'] = 'admin';
	$this->reload_acton = true;
	$this->login_fail = false;
      }
    }
    return ! $this->login_fail;
  }


  /*!
    \brief Ƚ
  */
  function logout() {

    // å˴
    $_SESSION = array();
    if (isset($_COOKIE[session_name()])) {
      setcookie(session_name(), '', time()-42000, '/');
    }
    session_destroy();
    $this->reload_action = true;
  }


  /*!
    \brief 󤷤Ƥп֤
  */
  function isLogin() {
    return isset($_SESSION['login_name']) ? true : false;
  }


  /*!
    \brief ľΥ˼ԤƤп֤
  */
  function loginFail() {
    return $this->login_fail;
  }


  /*!
    \brief ׵᤬п֤
  */
  function requireReload() {
    return $this->reload_action;
  }


  /*!
    \brief ̾μ
  */
  function getLoginName() {
    return ($this->isLogin() ? $_SESSION['login_name'] : "");
  }


  /*!
    \brief 桼̾μ
  */
  function getBrowsName() {
    return $_SESSION['brows_name'];
  }


  /*!
    \brief ¸ߤ桼̾μ
  */
  function getUserNames() {

    $users = array();
    $fp = @fopen($_SESSION['users_file'], 'r');
    if ($fp != false) {
      flock($fp, LOCK_SH);
      while (! feof($fp)) {
	$line = fgets($fp);
	$user = strtok($line, "\n\t ");
	if (strlen($user) && ($user != 'admin')) {
	  array_push($users, $user);
	}
      }
      fclose($fp);
    }
    return $users;
  }
};


/*!
  \brief ڡδ饹

  \todo ;ϤСˤĤƤ doxygen Ԥ
*/
class LangUpload {
  var $programs_exist;		//!< ¸ߤ
  var $programs_mtime;
  var $comments_exist;		//!< Ȥ¸ߤ
  var $comments_mtime;
  var $send_comment;
  var $program_updated;
  var $rev_max;			//!< ӥֹκ
  var $rev;			//!< ӥֹ
  var $key;			//!< ɽؼ
  var $read_mtime;		//!< ɻ
  var $unread_pages;		//!< ̤ɥե


  /*!
    \brief 󥹥ȥ饯

    \attention UserAuthorize ѤߤȤ
    \todo PHP Сƥεˡɤľ
  */
  function LangUpload() {

    // ե뤫νͤɤ߽Ф
    if (! isset($_SESSION['admin_mail_address'])) {
      require('config.php');

      $_SESSION['admin_mail_address'] =
	isset($admin_mail_address) ? $admin_mail_address : "no mail address";
      $_SESSION['users_file'] =
	isset($users_file) ? $users_file : 'data/users.txt';
      $_SESSION['project_title'] =
	isset($project_title) ? $project_title : 'Lang Upload';
      $_SESSION['problems_num'] =
	isset($problems_num) ? $problems_num : array();
      $_SESSION['enscript_bin'] =
	isset($enscript_bin) ? $enscript_bin : '';
      $_SESSION['admins'] = isset($admins) ? $admins : array();
    }
    $this->programs_exist = array();
    $this->programs_mtime = array();
    $this->comments_exist = array();
    $this->comments_mtime = array();
    $this->send_comment = false;
    $this->program_updated = false;
    $this->read_mtime = array();
    $this->unread_pages = array();

    // եι
    if (isset($_SESSION['brows_name'])) {
      $this->createFilesHash($_SESSION['brows_name']);
    }

    // ڡѹ
    if (isset($_GET['chapter'])) {
      // ¸ߤϤǧ
      $chapter = intval($_GET['chapter']);
      if (($chapter > 0) && ($chapter <= count($_SESSION['problems_num']))) {
	$_SESSION['chapter'] = $chapter;
      }
    }
    if (isset($_GET['no'])) {
      // ¸ߤֹ椫ǧ
      $no = intval($_GET['no']);
      if (($no > 0) &&
	  ($no <= $_SESSION['problems_num'][$_SESSION['chapter'] -1])) {
	$_SESSION['no'] = intval($_GET['no']);
      }
    }

    // key η׻
    $this->key = (isset($_SESSION['chapter']) && isset($_SESSION['no'])) ?
      $_SESSION['chapter']. '-'. $_SESSION['no'] : '0-0';

    // ɽΥӥֹ
    $this->rev_max = isset($this->programs_exist[$this->key]) ?
      $this->programs_exist[$this->key] : 0;
    $this->rev = $this->rev_max;
    if (isset($_GET['rev'])) {
      $rev = intval($_GET['rev']);
      if (($rev >= 0) && ($rev <= $this->rev_max)) {
	$this->rev = $rev;
      }
    }

    // åץɥեν
    if (isset($_FILES) && isset($_FILES['userfile']['tmp_name'])) {
      $this->uploadProgram($_FILES['userfile']['tmp_name'],
			   $_FILES['userfile']['name']);
    }

    // ɤδ򹹿
    $this->selectUnreadPage();
  }


  function programUpdated() {
    return $this->program_updated;
  }


  function sendComment() {
    return $this->send_comment;
  }


  /*!
    \brief Сɽ
  */
  function printVersionInfo() {
    $out = '';
    $out .= '<table class=main border=0 cellspacing=3 width=500 cellpadding=3>'
      .'<tr><td><h2>LangUpload ChangeLog</h2><div class="frame">';

    $fp = fopen('version.txt', 'r');
    if ($fp == false) {
      $out .= 'no file: version.txt';
    } else {
      flock($fp, LOCK_SH);
      while (! feof($fp)) {
	$line = fgets($fp);
	if (preg_match('/(\d\d\d\d\/\d\d\/\d\d)/', $line)) {
	  $out .= '<h3>'. $line. '</h3>';
	} else if (preg_match('/---/', $line)) {
	  continue;
	} else {
	  $replaced = htmlspecialchars($line);
	  $out .= preg_replace('/\n/', '<br>', $replaced);
	}
      }
      fclose($fp);
    }

    $out .= '</td></tr></table>';
    return $out;
  }


  /*!
    \brief ԤǤп֤
  */
  function isManager() {
    if (in_array($_SESSION['login_name'], $_SESSION['admins']) ||
	($_SESSION['login_name'] == 'admin')) {
      return true;
    } else {
      return false;
    }
  }


  /*!
    \brief եΥåץɽ
  */
  function uploadProgram($uploaded_file, $file_name) {

    $next_rev = $this->rev + 1;
    $file = 'p'. $this->key. '-'. $next_rev. '.txt';

    $uploaddir = 'data/'. $_SESSION['login_name']. '/';
    $to_file = $uploaddir. $file;
    if (! move_uploaded_file($uploaded_file, $to_file)) {
      // print "Possible file upload attack!\n";
      // !!! ȤΤ˻Ĥ
    } else {
      // åץɻΥե̾Ͽ
      $fp = fopen($uploaddir. 'programs.txt', 'a');
      if ($fp != false) {
	flock($fp, LOCK_EX);
	$line = $file. "\t". $file_name. "\n";
	fwrite($fp, $line);
	fclose($fp);
      }
      $this->program_updated = true;
    }
  }


  /*!
    \brief ץȥȥμ
  */
  function getTitle() {
    return $_SESSION['project_title'];
  }


  /*!
    \brief ԤΥ᡼륢ɥ쥹
  */
  function getAdminMailAddress() {
    return $_SESSION['admin_mail_address'];
  }


  /*!
    \brief ֹμ
  */
  function getChapter() {
    return $_SESSION['chapter'];
  }


  /*!
    \brief ֹμ
  */
  function getNo() {
    return $_SESSION['no'];
  }


  /*!
    \brief ֹ󥯤κ
  */
  function createNoLink($chapter, $no_label = '%d-%d') {
    $out = '';

    $n = $_SESSION['problems_num'][$chapter -1];
    $no = $this->getNo();
    $chapter = $this->getChapter();
    $no_title = sprintf($no_label, $chapter, $no);
    $out .= '<table border=1><tr><th colspan='. $n. ' align=left>&nbsp;'. $this->createPrevNoLink(). '&nbsp;'. $no_title. '&nbsp;'. $this->createNextNoLink(). '</th></tr><tr>';

    for ($i = 0; $i < $n; ++$i) {
      $index = $i + 1;
      $key = $chapter. '-'. $index;
      $back_color = (isset($this->programs_exist[$key]) ||
		     isset($this->comments_exist[$key])) ? 'white' : '#d0d0d0';

      if ($index == $no) {
	$out .= '<td bgcolor='. $back_color. '><strong>&nbsp;'. $index. '</strong></a></td>';
      } else {
	$out .= '<td bgcolor='. $back_color. '><a href=?no='. $index. '><strong>&nbsp;'. $index. '</strong></a></td>';
      }
    }
    $out .= '</tr></table>';
    return $out;
  }


  /*!
    \brief ᥤڡѤΥơ֥

    \todo Ȥͽ꤬ʤС

    \todo Smarty ΰ̣礤̵...Ĥ
  */
  function createChapterTable($brows_name,
			      $chapter_view = 'Chapter. %d',
			      $total_tag = 'Total') {
    $ret = '';

    // Ľμ
    $exists = $this->getProgramExists($brows_name);

    $ret .= '<table border=1><tr><th></th><th>Ľ</th></tr>';

    $total_exists = 0;
    $total_problems = 0;
    $chapter_no = 1;
    foreach ($_SESSION['problems_num'] as $chapter_array) {
      // 󥯺
      $ret .= '<tr height=28><td>&nbsp;';
      $ret .= '<a href=chapterView.php?chapter='. $chapter_no. '><strong>'.
	sprintf($chapter_view, $chapter_no). '</strong></a>';

      // Ľκ
      $exists_num = $exists[0][$chapter_no -1];
      $total_num = $exists[1][$chapter_no -1];
      $progress = (int)(100.0 * $exists_num / $total_num);
      $images = '&nbsp;';
      $line = sprintf(" (%d/%d)</td><td width=255>%3d%% ",
		      $exists_num, $total_num, $progress);
      $ret .= preg_replace('/ /', '&nbsp;', $line);
      $ret .=
	sprintf('<img src=bar.png height=14 width=%d>',
		2 * $progress);
      $total_exists += $exists_num;
      $total_problems += $total_num;

      $ret .= '</td></tr>';
      ++$chapter_no;
    }

    // ΤοĽɽ
    $progress = (int)(100.0 * $total_exists / $total_problems);
    $ret .= '<tr height=28><td>&nbsp;'. $total_tag;
    $ret .= sprintf(' (%d/%d)</td><td width=255>&nbsp;%3d%% ',
		    $total_exists, $total_problems, $progress);
    $ret .= sprintf('<img src=bar.png height=16 width=%d>',
		    2 * $progress);
    $ret .= '</td></tr>';

    $ret .= '</table>';

    return $ret;
  }


  /*!
    \brief ץΥ˥塼ɽ

    \todo Τ⡢Smarty 褦˽
    \todo ̤ɤꡢɽʸǶĴɽ
  */
  function createProgramsTable($brows_name) {

    $chapter = $this->getChapter();
    if (! isset($_SESSION['problems_num'][$chapter - 1])) {
      // !!! ꤷֹ꤬ʤ
      // !!! åϤ٤
      // !!! ˽񤭹٤
      return;
    }

    $out = '';
    $out .= '<table border=1>';
    $out .= '<tr><th>No.</th><th width=110>Program</th><th width=110>Comment</th></tr>';

    for ($i = 0; $i < $_SESSION['problems_num'][$chapter - 1]; ++$i) {
      $no = $i + 1;
      $ref_front = '<a href=programView.php?chapter='. $chapter. '&no='. $no;
      $out .= '<tr><td align=center>'. $ref_front. '><strong>&nbsp;'. $chapter. '-'. $no. '&nbsp;</strong></a></td>';
      $key = $chapter. '-'. ($i + 1);

      // ץ¸ɽ
      $out .= '<td align=center>';
      if (isset($this->programs_exist[$key])) {
	$rev = $this->programs_exist[$key];
	$mtime = $this->programs_mtime[$key. '-'. $rev];
	$out .= $ref_front. '><strong>&nbsp;'. date('Y-m-d', $mtime). '&nbsp;</strong></a>';
      } else {
	$out .= '&nbsp;';
      }
      $out .= '</td>';

      // Ȥ¸ɽ
      $out .= '<td align=center>';
      if (isset($this->comments_exist[$key])) {
	$rev = $this->comments_exist[$key];
	$mtime = $this->comments_mtime[$key. '-'. $rev];
	$out .= $ref_front. '#comment><strong>&nbsp;'. date('Y-m-d', $mtime). '&nbsp;</strong></a>';
      } else {
	$out .= '&nbsp;';
      }
      $out .= '</td></tr>';
    }
    $out .= '</table>';
    return $out;
  }


  /*!
    \brief Ĥ줿ץɽμ

    \todo ؿ̾ѹꡢȤ
    \todo ե뤬ʤȤνˤĤˤ
  */
  function createProgramView($brows_name,
			     $no_program_message = 'No Program.') {

    $out = '';
    if (! isset($this->programs_exist[$this->key])) {
      // ե뤬ʤν
      $out .= $no_program_message;
      return $out;
    }
    $rev = $this->rev;
    $key_rev = $this->key. '-'. $rev;

    // !!! path ä̾ѹ롢
    $path = 'data/'. $brows_name. '/p'. $key_rev. '.txt';

    // ϿγĥҤ
    // !!! PEAR::Text_Highlighter Ȥ٤
    $programs = $this->getProgramsInfo('data/'. $brows_name. '/programs.txt');
    $suffix = strtolower($programs[$key_rev]['suffix']);
    switch ($ext) {
    default:
      $enscript_suffix = 'cpp';
      break;
    }

    if ($suffix == 'php') {
      // !!! EUC-JP ʳн褹٤ʤ...
      highlight_string(join(file($path)));
    } else {
      // !!! enscript ʤȤե⡼ɤΤȤб
      $cmd = $_SESSION['enscript_bin'].
	' --highlight='. $enscript_suffix. ' --color --language html --toc --output - '. $path;
      $stdout = @shell_exec($cmd);
      if (isset($programs[$key_rev]['code'])) {
	$code = $programs[$key_rev]['code'];
      } else {
	$code = mb_detect_encoding($stdout, "auto", true);
	$programs[$key_rev]['code'] = $code;

	// programs.txt ι
	$this->updateProgramsList($programs);
      }

      $converted = ($code != false) ?
	mb_convert_encoding($stdout, 'EUC-JP', $code) : $stdout;

      // !!! preg_match ֤
      if (ereg('(<PRE>.+</PRE>)', $converted, $prog)) {
	$out .= $prog[1];
      } else {
	$lines = @file($path);
	if (is_array($lines)) {
	  $out .= '<pre>'. join($lines). '</pre>';
	} else {
	  $out .= $no_program_message;
	}
      }
    }
    return $out;
  }


  /*!
    \brief ץΥåץɥե

    \todo Ͽνڡ򵭽Ҥ
  */
  function createUploadForm($message = 'Upload Program: ', $page) {

    return '<form enctype="multipart/form-data" action="'. $page. '" method="POST"><input type="hidden" name="MAX_FILE_SIZE" value="10000" />'. $message. '<input name="userfile" type="file" /><input type="submit" value="Send File" /></form>';
  }


  /*!
    \brief եδ򹹿

    \todo private ؿʤΤǡ̾ϽƤɽƤƤ褤Ȥˤ
    \todo 졢updateProgramsHash() ˤǤ̾
    \todo ȴ⤷Ƥ뤳ȤθƲ̾
  */
  function createFilesHash($brows_name) {

    $dir_name = 'data/'. $brows_name;
    @$dp = opendir($dir_name);
    if ($dp == false) {
      // !!! ǥ쥯ȥ꤬¸ߤʤ硣
      // !!! ȤΥåϤ٤
      // !!! षؿƤ֤٤
      return;
    }

    clearstatcache();
    while (($file = readdir($dp)) !== false) {
      if (preg_match('/p([\d]+-[\d]+)-([\d]+)\.txt/', $file, $matches)) {
	// pX-X-X.txt Ȥե뤬п
	$key = $matches[1];
	$rev = intval($matches[2]);
	$this->programs_mtime[$key. '-'. $rev] =
	  filemtime($dir_name. '/'. $file);

	// ץ
	if (isset($this->programs_exist[$key])) {
	  $current_rev = $this->programs_exist[$key];
	  if ($rev > $current_rev) {
	    $this->programs_exist[$key] = $rev;
	  }
	} else {
	  $this->programs_exist[$key] = $rev;
	}
      }

      if (preg_match('/c([\d]+-[\d]+)-([\d]+)\.txt/', $file, $matches)) {
	// cX-X-X.txt Ȥե뤬п
	$key = $matches[1];
	$rev = intval($matches[2]);
	$this->comments_mtime[$key. '-'. $rev] =
	  filemtime($dir_name. '/'. $file);

	// ȴ
	if (isset($this->comments_exist[$key])) {
	  $current_rev = $this->comments_exist[$key];
	  if ($rev > $current_rev) {
	    $this->comments_exist[$key] = $rev;
	  }
	} else {
	  $this->comments_exist[$key] = $rev;
	}
      }
    }
    closedir($dp);
  }


  /*!
    \brief ץϿ

    \todo Ƥȴؿ̾פƤʤΤ
  */
  function getProgramExists($brows_name) {

    $exists = array();
    $index = 1;
    foreach ($_SESSION['problems_num'] as $chapter_problems) {
      $chapter_programs = 0;
      for ($i = 1; $i <= $chapter_problems; ++$i) {
	$key = $index. '-'. $i;
	if (isset($this->programs_exist[$key])) {
	  ++$chapter_programs;
	}
      }
      array_push($exists, $chapter_programs);
      ++$index;
    }
    return array($exists, $_SESSION['problems_num']);
  }


  /*!
    \brief ưѤΥ󥯤
  */
  function createInternalLink($chapter, $no) {
    $out = '<a href=main.php><strong>Main Page</strong></a>';
    if (($chapter > 0) && ($no <= 0)) {
      $out .= ' <font size=-1><strong>&gt;&gt;</strong></font> <strong>Chapter Page</strong>';
    }
    if (($chapter > 0) && ($no > 0)) {
      $out .= ' <font size=-1><strong>&gt;&gt;</strong></font> <a href=chapterView.php?chapter='. $chapter.
	'><strong>Chapter Page</strong></a> <font size=-1><strong>&gt;&gt;</strong></font> <strong>Program Page</strong>';
    }
    return $out;
  }


  /*!
    \brief 桼󥯤κ

    \todo Ϥơtpl ǥ󥯺褦˽롣Ĥ
  */
  function createUsersLink($user) {

    $users = $user->getUserNames();

    $out = '';
    $out .= '<table class=users width=100%><tr><td>&nbsp;</td>';
    foreach ($users as $each_name) {
      if ($_SESSION['brows_name'] == $each_name) {
	$out .= '<td class=users><img src=front_left.png></td><td background=front_middle.png><strong>'. $each_name.
	  '</strong></td><td class=users><img src=front_right.png></td>';
      } else {
	$out .= '<td class=users><img src=back_left.png></td><td background=back_middle.png><a class=users href=?brows_name='.
	  $each_name. '><strong>'. $each_name. '</strong></a></td><td class=users><img src=back_right.png></td>';
      }
    }
    $out .= '<td width=100%></td></tr><tr><td><img src=dot.png width=100% height=2</td>';
    foreach ($users as $each_name) {
      if ($_SESSION['brows_name'] == $each_name) {
	$out .= '<td></td><td></td><td></td>';
      } else {
	$out .= '<td class=users><img src=dot.png width=100% height=2></td><td class=users><img src=dot.png width=100% height=2></td><td class=users><img src=dot.png width=100% height=2></td>';
      }
    }

    $out .= '<td class=users><img src=dot.png width=100% height=2></td><tr></table>';
    return $out;
  }


  // 桼Υե
  function createUsersSelectForm($user, $add_users = array()) {

    $out = '';
    $users = array_merge($user->getUserNames(), $add_users);
    foreach ($users as $login_name) {
      $out .= '<option value="'. $login_name. '"';
      if ($login_name == $_SESSION['brows_name']) {
	$out .= ' selected';
      }
      $out .= '>'. $login_name. '</option>';
    }
    return $out;
  }


  //桼ɲåե
  function addUserForm() {
    $out = '<form method=POST><input type=text name=add_user size=13>'.
      '&nbsp;<input type=submit name=add_user_submit value=Add></formt>';
    return $out;
  }


  // ѥѹե
  function changePasswordForm($user) {
    $out = '';
    $out .= '<form method=POST><select name=change_user>';

    $out .= $this->createUsersSelectForm($user, array('admin'));

    $out .= '</select><br>'.
      '<input type=password name=change_password size=13>'.
      '&nbsp;<input type=submit name=change_password_submit value=Change>'.
      '</form>';
    return $out;
  }


  // 桼ե
  function delUserForm($user) {
    $out = '';
    $out .= '<form method=POST><select name=del_user>';

    $out .= $this->createUsersSelectForm($user);

    $out .= '</select>'.
      '&nbsp;<input type=submit name=del_user_submit value=Delete></formt>';
    return $out;


    $out .= '</form>';
    return $out;
  }


  // ꥯȤν
  function handleAdminRequest() {

    // 桼ɲ
    if (isset($_POST['add_user_submit'])) {
      $name = $_POST['add_user'];

      // ̾ιʸå
      if (preg_match('/[^A-Za-z0-9_]/', $name)) {
	// !!! [A-Za-z0-9_] ˤơȤɽ桼󼨤
	return;
      }
      // ǥ쥯ȥκ
      // !!! Apache 桼äʬʬäʤΤǡѡߥå
      if (! @mkdir('data/'. $name, 0777)) {
	return;
      }
      @chmod('data/'. $name, 0777);

      // users_file ˥桼ɲ
      $fp = fopen($_SESSION['users_file'], 'a');
      if ($fp != false) {
	flock($fp, LOCK_EX);
	$line = $name. "\tdummy_password\n";
	fwrite($fp, $line);
	fclose($fp);
      }
    }

    // ѥѹ
    if (isset($_POST['change_password_submit'])) {
      // ɤǡ桼ʬΥѥɤΤѹơ񤭹
      if (! isset($_POST['change_user'])) {
	print 'no change_user<br>';
	return;
      }
      $change_user = $_POST['change_user'];

      $replace_file = '';
      $fp = fopen($_SESSION['users_file'], 'r');
      if ($fp != false) {
	flock($fp, LOCK_SH);
	while (! feof($fp)) {
	  $line = fgets($fp);
	  $name = strtok($line, "\n\t ");
	  if ($name == $change_user) {
	    $line = $name. "\t". crypt($_POST['change_password']). "\n";
	  }
	  $replace_file .= $line;
	}
	fclose($fp);
      }
      $fp = fopen($_SESSION['users_file'], 'w');
      if ($fp != false) {
	flock($fp, LOCK_EX);
	fwrite($fp, $replace_file);
	fclose($fp);
      }
    }

    // 桼
    if (isset($_POST['del_user_submit'])) {
    }
  }


  // ɽ
  function createCommentView() {
    $out = '';
    $out .= '<table border=1 width=80%><tr><th align=left>&nbsp;&nbsp;Comment</th></tr>';

    // !!! Ͽץ¸νȽʣʤΤޤȤ
    $file = 'data/'. $_SESSION['brows_name']. '/c'.
      $this->key. '-'. $this->rev. '.txt';

    $fp = @fopen($file, 'r');
    if ($fp == false) {
      $out .= '<tr><td>&nbsp;No Comments.</td></tr>';
    } else {
      flock($fp, LOCK_SH);
      $header = true;
      while (! feof($fp)) {
	$line = fgets($fp);
	if ($line == '') {
	  // EOF
	  break;
	}
	if ($line == "\n") {
	  // Ȥζڤ
	  $header = true;
	  $out .= '</td></tr>';

	} else if ($header == true) {
	  // ȥåΥإå
	  $out .= '<tr><td class=cmt>';

	  $header = false;
	  $name = strtok($line, "\t ");
	  $mtime = intval(strtok("\t "));
	  $out .= '<h3>&nbsp;'. date('Y-m-d H:i', $mtime).
	    '&nbsp; '. $name. '</h3>';

	} else {
	  // Ȥɽ
	  //$code = mb_detect_encoding($line, "auto", true);
	  //$converted = mb_convert_encoding($line, 'EUC-JP', $code);
	  $converted = $line;
	  $converted = htmlspecialchars($converted). '<br>';
	  $out .= preg_replace('/ /', '&nbsp;', $converted);
	}
      }
      fclose($fp);
    }
    $out .= '</table>';
    return $out;
  }


  // ȥեκ
  function createCommentForm() {
    $out = '';

    if ($this->rev_max != $this->rev) {
      // ӥ󤬺ǿǤʤС
      $out .= 'There is not comment form.<br>Please comment on the latest program.<br>';
      return $out;
    }

    $out .= '<form method=POST>';

    $out .= '<textarea name=comment_msg cols=40 rows=4 wrap=soft></textarea>';
    $out .= '<input type=submit value=Send>';

    $out .= '</form>';
    return $out;
  }


  // ȤϿ
  function handleCommentRequest($user) {

    // 桼ɲ
    if (isset($_POST['comment_msg'])) {
      // ץΥӥƱˤ
      $file = 'data/'. $_SESSION['brows_name']. '/c'.
	$this->key. '-'. $this->rev. '.txt';
      $fp = fopen($file, 'a');
      if ($fp != false) {
	$comment_data = $_SESSION['login_name']. "\t". time(). "\n";

	// ĤΥȤνüϡԣ
	$comment_data .= rtrim($_POST['comment_msg']). "\n\n";
	flock($fp, LOCK_EX);
	fwrite($fp, $comment_data);
	fclose($fp);
	$this->send_comment = true;
      }
    }
  }


  // ξϤؤΥ󥯤
  function createPrevChapterLink() {
    $out = '';
    $prev_chapter = $this->getChapter() - 1;
    if ($prev_chapter <= 0) {
      $out .= '<s>&lt;&lt;</s>';
    } else {
      $out .= '<a href=?chapter='. $prev_chapter. '>&lt;&lt</a>';
    }
    return $out;
  }


  // ξϤؤΥ󥯤
  function createNextChapterLink() {
    $out = '';
    $next_chapter = $this->getChapter() + 1;
    if ($next_chapter > count($_SESSION['problems_num'])) {
      $out .= '<s>&gt;&gt;</s>';
    } else {
      $out .= '<a href=?chapter='. $next_chapter. '>&gt;&gt</a>';
    }
    return $out;
  }


  // ؤΥ󥯤
  function createPrevNoLink() {
    $out = '';
    $prev_no = $this->getNo() - 1;
    if ($prev_no <= 0) {
      $out .= '<s>&lt;&lt;</s>';
    } else {
      $out .= '<a href=?no='. $prev_no. '>&lt;&lt</a>';
    }
    return $out;
  }


  // ؤΥ󥯤
  function createNextNoLink() {
    $out = '';
    $next_no = $this->getNo() + 1;
    if ($next_no > $_SESSION['problems_num'][$this->getChapter() -1]) {
      $out .= '<s>&gt;&gt;</s>';
    } else {
      $out .= '<a href=?no='. $next_no. '>&gt;&gt</a>';
    }
    return $out;
  }


  // ӥΥ󥯤
  function createRevLink() {

    $out = '';

    if ($this->rev_max == 0) {
      return $out;
    }
    $out .= '<table border=1><tr><th>&nbsp;'. $this->key. '&nbsp;';

    $first_index = (isset($this->comments_exist[$this->key. '-0'])) ? 0 : 1;
    if ($first_index != $this->rev_max) {
      $out .= 'Rev';
    }
    $out .= '</th>';

    if ($first_index != $this->rev_max) {
      // rev:0 ΥȤСǥå 0 鳫Ϥ
      for ($i = $first_index; $i <= $this->rev_max; ++$i) {
	if ($i == $this->rev) {
	  $out .= '<td><strong>&nbsp;'. $i. '</strong></td>';
	} else {
	  $out .= '<td><strong><a href=?rev='. $i. '>&nbsp;'. $i. '</strong></a></td>';
	}
      }
    }
    $out .= '</tr></table>';
    return $out;
  }


  // ɻ֡ե빹μ
  function selectUnreadPage() {
    if (! isset($_SESSION['brows_name'])) {
      // 桼λ꤬ɬפʤڡǤϡʤ
      return;
    }

    // ɻ֤ɤ߽Ф
    $login_name = $_SESSION['login_name'];
    $brows_name = $_SESSION['brows_name'];
    $dir_name = 'data/'. $login_name;

    // ɻ: data/. $login_name. '/'. $brows_name. '-read.txt'
    $file = $dir_name. '/'. $brows_name. '-read.txt';

    $fp = @fopen($file, 'r');
    if ($fp != false) {
      flock($fp, LOCK_SH);
      while (! feof($fp)) {
	// : $key. "\t". $mtime
	$line = fgets($fp);
	$key = strtok($line, "\t ");
	$mtime = intval(strtok("\t "));
	if ($mtime != 0) {
	  $this->read_mtime[$key] = $mtime;
	}
      }
      fclose($fp);
    }

    // ե빹μ
    $dir_name = 'data/'. $brows_name;
    @$dp = opendir($dir_name);
    if ($dp == false) {
      return;
    }

    $files_mtime = array();
    clearstatcache();
    while (($file = readdir($dp)) !== false) {
      // [pc]X-X-X.txt Ȥե
      if (preg_match('/[pc]([\d]+-[\d]+-[\d]+)\.txt/', $file, $matches)) {

	$key = $matches[1];
	$mtime = filemtime($dir_name. '/'. $file);

	if (! isset($files_mtime[$key])) {
	  $files_mtime[$key] = $mtime;
	} else {
	  $time = $files_mtime[$key];
	  if ($time < $mtime) {
	    $files_mtime[$key] = $mtime;
	  }
	}
      }
    }
    closedir($dp);

    // ߱Υڡɰˤ
    if (isset($_SESSION['no'])) {
      $now_chapter = $this->getChapter();
      $now_no = $this->getNo();
      $now_rev = $this->rev;
      $now_key = $now_chapter. '-'. $now_no. '-'. $now_rev;
    } else {
      $now_key = 'dummy_key';
    }

    // եι郎ɤ⿷Τʤ
    foreach ($files_mtime as $key => $value) {
      if ($key == $now_key) {
	continue;
      }
      if (! isset($this->read_mtime[$key])) {
	array_push($this->unread_pages, $key);
      } else {
	if ($this->read_mtime[$key] < $value) {
	  array_push($this->unread_pages, $key);
	}
      }
    }
    sort($this->unread_pages);
  }


  /*!
    \brief ̤ɥ󥯤ɤ
  */
  function createUnreadLink($message = 'Jump to unread page.') {
    $out = '';

    if (count($this->unread_pages) <= 0) {
      // ̤ɥڡʤ
      return $out;
    }

    // ̤ɥڡؤΥ󥯤
    $key = array_shift($this->unread_pages);
    if (preg_match('/([\d]+)-([\d]+)-([\d]+)/', $key, $matches)) {
      $chapter = intval($matches[1]);
      $no = intval($matches[2]);
      $rev = intval($matches[3]);
      $out .= '<a href=programView.php?chapter='. $chapter. '&no='. $no. '&rev='. $rev .'>'. $message. '</a>';
    }
    return $out. '<br>';
  }


  // ɻ֤ι
  // ɺѤˡ߱Ƥڡʬ򹹿Ƥ顢񤭹
  function updateReadTime() {

    // 
    $now = time() + 1;
    $now_chapter = $this->getChapter();
    $now_no = $this->getNo();
    $now_rev = $this->rev;
    $key = $now_chapter. '-'. $now_no. '-'. $now_rev;
    $this->read_mtime[$key] = $now;

    // 񤭹
    $login_name = $_SESSION['login_name'];
    $brows_name = $_SESSION['brows_name'];
    $dir_name = 'data/'. $login_name;
    $file = $dir_name. '/'. $brows_name. '-read.txt';

    $fp = @fopen($file, 'w');
    if ($fp != false) {
      flock($fp, LOCK_EX);
      foreach ($this->read_mtime as $key => $value) {
	// : $key. "\t". $mtime
	$line = $key. "\t". $value. "\n";
	fwrite($fp, $line);
      }
      fclose($fp);
    }
  }


  // ץγĥҤ
  function getProgramsInfo($file) {

    $programs = array();

    $fp = @fopen($file, 'r');
    if ($fp == false) {
      return $programs;
    }
    flock($fp, LOCK_SH);
    while (! feof($fp)) {
      $line = fgets($fp);
      if (preg_match("/p([\d]+-[\d]+-[\d]+)\.txt[ \t]+(.+)/",
		     $line, $matches)) {
	$key = $matches[1];
	$original = $matches[2];
	$program_name = strtok($original, "\t ");
	$jp_code = strtok("\t\n ");
	if (preg_match("/.+?\.(.+)/", $program_name, $matches)) {
	  $suffix = $matches[1];
	} else {
	  $suffix = 'txt';
	}
	$programs[$key]['name'] = $program_name;
	$programs[$key]['suffix'] = $suffix;

	if ($jp_code != '') {
	  $programs[$key]['code'] = $jp_code;
	}
      }
    }
    fclose($fp);

    return $programs;
  }


  // ץեι
  function updateProgramsList($programs) {
    $dir = 'data/'. $_SESSION['login_name']. '/';
    $fp = fopen($dir. 'programs.txt', 'w');
    if ($fp != false) {
      flock($fp, LOCK_EX);
      foreach ($programs as $key => $value) {

	$line = 'p'. $key. '.txt'. "\t". $value['name'];
	if (isset($value['code'])) {
	  $line .= "\t". $value['code'];
	}
	fwrite($fp, $line. "\n");
      }
      fclose($fp);
    }
  }
};
?>
