//this file is part of notepad++
//Copyright (C)2003 Don HO <donho@altern.org>
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "dllmain.h"
#include "NppHorizontalRuler.h"

const WCHAR * const NPP_PLUGIN_NAME = L"Ruler";	//+[JOJO]
const int nbFunc = MENUCOUNT;
FuncItem funcItem[nbFunc];
NppData nppData;

HINSTANCE g_DllhInst;

BOOL APIENTRY DllMain(HANDLE hModule, DWORD  reasonForCall, LPVOID /*lpReserved*/)
{
    ////////////////////////////////////////////////////////////
    // [JOJO]
#if 0 /*#DEBUG#*/
	setlocale(LC_ALL, "");	// "C" --> "Japanese_Japan.932"
#pragma warning(push)
#pragma warning(disable:4996)
	freopen("C:/Npp_vs2015/mine/NppHorizontalRuler/_NppHorizontalRuler.log", "a", stdout);
#pragma warning(pop)
	setvbuf(stdout, NULL, _IONBF, 0);
	*stderr = *stdout;
	SetStdHandle(STD_ERROR_HANDLE, GetStdHandle(STD_OUTPUT_HANDLE)); // POSIX: dup2(1, 2)
	//
	SYSTEMTIME t; GetLocalTime(&t);
	printf("%s(%d) %s(%p,%X,%p):\n", __FILE__, __LINE__, __FUNCTION__, hModule, reasonForCall, lpReserved);
	printf("\t""locale   : %s\n", setlocale(LC_ALL, NULL));
	printf("\t""now      : %04d/%02d/%02d %02d:%02d:%02d.%03d\n", t.wYear, t.wMonth, t.wDay, t.wHour, t.wMinute, t.wSecond, t.wMilliseconds);
	printf("\t""modify   : %s\n", __TIMESTAMP__);
	printf("\t""compiled : %s %s\n", __DATE__, __TIME__);
#ifdef UNICODE
	printf("\t""UNICODE defined\n");
#else
	printf("\t""UNICODE >>> not defined <<<\n");
#endif
#ifdef _UNICODE
	printf("\t""_UNICODE defined\n");
#else
	printf("\t""_UNICODE >>> not defined <<<\n");
#endif
	{                             printf("\t""sizeof (int)      = %zu\n"   , sizeof (int  ) );}
	{                             printf("\t""sizeof (long)     = %zu\n"   , sizeof (long ) );}
	{                             printf("\t""sizeof (*)        = %zu\n"   , sizeof (void*) );}
	{char       v =     (char)~0; printf("\t""sizeof (char)     = %zu%s\n", sizeof v, v < 0 ? " >>> signed <<<" : "");}
	{TCHAR      v =    (TCHAR)~0; printf("\t""sizeof (TCHAR)    = %zu%s\n", sizeof v, v < 0 ? " >>> signed <<<" : "");}
	{WCHAR      v =    (WCHAR)~0; printf("\t""sizeof (WCHAR)    = %zu%s\n", sizeof v, v < 0 ? " >>> signed <<<" : "");}
 //	{wchar_t    v =  (wchar_t)~0; printf("\t""sizeof (wchar_t)  = %zu%s\n", sizeof v, v < 0 ? " >>> signed <<<" : "");}
 //	{char16_t   v = (char16_t)~0; printf("\t""sizeof (char16_t) = %zu%s\n", sizeof v, v < 0 ? " >>> signed <<<" : "");}
 //	{char32_t   v = (char32_t)~0; printf("\t""sizeof (char32_t) = %zu%s\n", sizeof v, v < 0 ? " >>> signed <<<" : "");}
	{int v = strcmp("\x81", "\x80"); printf("\t""strcmp(\"\\x81\", \"\\x80\"): %d%s\n", v, v < 0 ? " >>> !? <<<\n" : "");}
	{                             printf("\t""'\\x80' < '\\x81': %s\n", '\x80' < '\x81' ? "true" : ">>> false <<<"); }
	{                             printf("\t""'\\x80' == 0x80: %s\n", '\x80' == 0x80 ? "true" : ">>> false <<<"); }
	// ../NppHorizontalRuler.vs2015.vcxproj: <AdditionalOptions>/J %(AdditionalOptions)</AdditionalOptions>
#endif
    ////////////////////////////////////////////////////////////
    switch (reasonForCall)
    {
      case DLL_PROCESS_ATTACH:
		g_DllhInst = (HINSTANCE)hModule;
        pluginInit(hModule);
        break;

      case DLL_PROCESS_DETACH:
		pluginTerminate();
        break;

      case DLL_THREAD_ATTACH:
        break;

      case DLL_THREAD_DETACH:
        break;
    }

    return TRUE;
}

extern "C" __declspec(dllexport) void setInfo(NppData notpadPlusData)
{
	nppData = notpadPlusData;
	commandMenuInit();
}

extern "C" __declspec(dllexport) const TCHAR * getName()
{
	return NPP_PLUGIN_NAME;
}

extern "C" __declspec(dllexport) FuncItem * getFuncsArray(int *nbF)
{
	*nbF = nbFunc;
	return funcItem;
}

extern "C" __declspec(dllexport) void beNotified(SCNotification *notifyCode)
{
	onHorizontalRulerBeNotified(notifyCode);
}

extern "C" __declspec(dllexport) LRESULT messageProc(UINT /*Message*/, WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	return TRUE;
}

#ifdef UNICODE
extern "C" __declspec(dllexport) BOOL isUnicode()
{
    return TRUE;
}

#endif //UNICODE

void pluginInit(HANDLE /*hModule*/)
{
	commandMenuInit();
}

void pluginTerminate()
{
	commandMenuCleanUp();
}

void commandMenuInit()
{
    //--------------------------------------------//
    //-- STEP 3. CUSTOMIZE YOUR PLUGIN COMMANDS --//
    //--------------------------------------------//
    // with function :
    // setCommand(int index,                      // zero based number to indicate the order of command
    //            TCHAR *commandName,             // the command name that you want to see in plugin menu
    //            PFUNCPLUGINCMD functionPointer, // the symbol of function (function pointer) associated with this command. The body should be defined below. See Step 4.
    //            ShortcutKey *shortcut,          // optional. Define a shortcut to trigger this command
    //            bool check0nInit                // optional. Make this menu item be checked visually
    //            );
	setCommand(RULER_VISIBLE, TEXT("Visible Ruler"), RulerVisible, NULL, false);
	setCommand(RULER_HIDE, TEXT("Hide Ruler"), RulerHide, NULL, false);
	setCommand(ABOUT, TEXT("About"), aboutDlg, NULL, false);
}

void commandMenuCleanUp()
{
	//Delete ShortcutKey
}

void setShortcutKey(ShortcutKey *sk, UCHAR key, bool isCtrl, bool isAlt, bool isShift){
	sk->_key = key;
	sk->_isCtrl = isCtrl;
	sk->_isAlt = isAlt;
	sk->_isShift = isShift;
}

bool setCommand(size_t index, TCHAR *cmdName, PFUNCPLUGINCMD pFunc, ShortcutKey *sk, bool check0nInit) 
{
    if (index >= nbFunc)
        return false;

    if (!pFunc)
        return false;

    lstrcpy(funcItem[index]._itemName, cmdName);
    funcItem[index]._pFunc = pFunc;
    funcItem[index]._init2Check = check0nInit;
    funcItem[index]._pShKey = sk;

    return true;
}

void aboutDlg()
{
	::MessageBox(NULL, 
				TEXT("The author is Japanese.\n")
				TEXT("Unfortunately not in English.\n")
				TEXT("This translation also will make bing.\n")
				TEXT("\n")
				TEXT("Bugs and wishes there was other please email until freesftys@yahoo.co.jp.\n"),
				TEXT("Horizontal Ruler Plugins"),
				MB_OK);
}
