#!perl

# UnicodeBlocks.pl
# Last update: 2016.06.20
# (c) 2016 JOJO

#Usage: perl scintilla/scripts/UnicodeBlocks.pl > scintilla/src/UnicodeBlocksData

use utf8;
use warnings;
use strict;
use File::Basename;

my $DEBUG = 0;

my $UnicodeBlocks = File::Basename::dirname($0)."/UnicodeBlocks.txt";	# 'scintilla/scripts/UnicodeBlocks.txt'

my @B;

unshift @B, -1;	# dummy -1
open FILE, '<:utf8', $UnicodeBlocks or die $!;
while (not eof(FILE)) {
	# 0000..007F; Basic Latin
	my $line = <FILE>;
	
	next unless $line =~ m/^([0-9A-F]+)\.\.([0-9A-F]+);/;
	my $begin = $1;
	my $end   = $2;
	
	my $ibegin = hex($begin);
	my $iend   = hex($end) + 1;
	print sprintf "// %s..%s;\t%04X..%04X\n", $begin, $end, $ibegin, $iend if $DEBUG;

	push @B, $ibegin if $ibegin != $B[-1];
	push @B, $iend   if $iend   != $B[-1];
}
close FILE;
shift @B;	# dummy -1

print "/*
 * http://www.unicode.org/Public/UNIDATA/Blocks.txt
 */
const uint32_t data[] = {\n";
print "$_,\n" for @B;
print "};\n";
