﻿/*
This file is:
The zlib/libpng License 
Copyright (c) 2012 freesftys<freesftys@gmail.com>

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from 
the use of this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

    1. The origin of this software must not be misrepresented; you must not 
	   claim that you wrote the original software. If you use this software in 
	   a product, an acknowledgment in the product documentation would be 
	   appreciated but is not required.
	
    2. Altered source versions must be plainly marked as such, and must not be 
       misrepresented as being the original software.
	
    3. This notice may not be removed or altered from any source distribution.

原文
http://opensource.org/licenses/Zlib

日本語訳
http://sourceforge.jp/projects/opensource/wiki/licenses%2Fzlib_libpng_license
*/


#ifndef INI_H
#define INI_H

#include <windows.h>
#include <tchar.h>
#include <stdio.h>

#define NUMDIGIT	64

class Ini
{

private:
	WCHAR *fullPath;

	Ini();
	~Ini();

	int _readData(const WCHAR *section, const WCHAR *key, WCHAR *buf, int bufsize);

public:
	static Ini* getInstance(){
		static Ini _ini;
		return &_ini;
	}

	bool inited;
	bool setIniPath(const WCHAR* directory, const WCHAR* fileName);

	void writeData(const WCHAR *section, const WCHAR *key, const WCHAR *value);
	void writeData(const WCHAR *section, const WCHAR *key, const bool value);
	void writeData(const WCHAR *section, const WCHAR *key, const int value);
	void writeData(const WCHAR *section, const WCHAR *key, const unsigned int value);
	void writeData(const WCHAR *section, const WCHAR *key, const unsigned long value);
	void writeData(const WCHAR *section, const WCHAR *key, const double value);

	void readData(const WCHAR *section, const WCHAR *key, WCHAR value[], int size);
	void readData(const WCHAR *section, const WCHAR *key, bool *value);
	void readData(const WCHAR *section, const WCHAR *key, int *value);
	void readData(const WCHAR *section, const WCHAR *key, unsigned int *value);
	void readData(const WCHAR *section, const WCHAR *key, unsigned long *value);
	void readData(const WCHAR *section, const WCHAR *key, float *value);
	void readData(const WCHAR *section, const WCHAR *key, double *value);
};

#endif