/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package custom.IOPRace;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;

public class IOPRace extends Quest
{
	final private static int RIGNOS = 32349;
	final private static int STAMP = 10013;
	final private static int KEY = 9694;
	
	private int _player = -1;
	
	public IOPRace(int id, String name, String descr)
	{
		super(id, name, descr);
		addStartNpc(RIGNOS);
		addTalkId(RIGNOS);
		addFirstTalkId(RIGNOS);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(getName());
		if (st == null)
			st = newQuestState(player);
		
		if (player.getLevel() < 78)
			return "32349-notavailable.htm";
		//[JOJO]-------------------------------------------------
		if (_player == -1 || _player != player.getObjectId())
				player.stopSkillEffects(5239);
		if (_player != -1)
		{
			long n;
			if (_player != player.getObjectId())
				return "32349-notavailable.htm";
			else if ((n = st.getQuestItemsCount(STAMP)) < 1)
				return "32349-started.htm";
			else if ( n                                 < 4)
				return "32349-notfinish.htm";
			else
				return "32349-return.htm";
		}
		//-------------------------------------------------------
		
		npc.showChatWindow(player);
		return null;
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(getName());
		if (st == null)
			st = newQuestState(player);
		
		if (_player == -1)
		{
			// clean old data
			player.stopSkillEffects(5239);
			if (player.getPet() != null)
				player.getPet().stopSkillEffects(5239);
			
			st.takeItems(STAMP, -1);
			st.set("1st", "0");
			st.set("2nd", "0");
			st.set("3rd", "0");
			st.set("4th", "0");
			
			L2Skill skill = SkillTable.getInstance().getInfo(5239, 5);
			if (skill != null)
			{
				skill.getEffects(npc, player);
				if (player.getPet() != null)
					skill.getEffects(npc, player.getPet());
			}
			
			startQuestTimer("timer", 1800000, null, null); // 30 min
			_player = player.getObjectId();

			//[JOJO]-------------------------------------------------
//			st.playSound("ItemSound.quest_accept");
			st.playSound("ItemSound2.race_start");
			final class S_Race implements Runnable
			{
				private final L2PcInstance _pc;
				private S_Race(L2PcInstance player) { _pc = player; }
				public void run() { _pc.sendPacket(new PlaySound(1, "S_Race", 0, 0, 0, 0, 0)); }
			}
			ThreadPoolManager.getInstance().scheduleGeneral(new S_Race(player), 3000L);
			//-------------------------------------------------------
		}
		
		return null;
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = "";
		
		if (event.equals/*IgnoreCase*/("timer"))
		{
			_player = -1;
			return null;
		}
		else if (event.equals/*IgnoreCase*/("finish"))
		{
			if (_player == player.getObjectId())
			{
				QuestState st = player.getQuestState(getName());
				st.giveItems(KEY, 3);
				st.takeItems(STAMP, -1);
				st.exitQuest(true);
				st.playSound("ItemSound.quest_finish");	//[JOJO]
			}
		}
		
		return htmltext;
	}
	
	public static void main(String[] args)
	{
		new IOPRace(-1, "IOPRace", "custom");
	}
}