/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.util.Rnd;

/**
 * uJ I[N I[o[[h
 * Breka Orc Overlord
 */
public class BrekaOrcOverlord extends Quest
{
	private static final int BREKA_ORC_OVERLORD = 20270;
	
//	private static int[] SAY1 =
//	{
//	};
	
	private static int[] SAY2 =
	{
		1000290,	//Dear ultimate power!!!							ɂ̗͂I
		1000395,	//I never thought I'd use this against a novice!	˂𑊎ɂ̃XLgƂ́I
		1000396,	//You won't take me down easily.					܂܂ɂ͏Ă񂼁I
		1000397,	//The battle has just begun!						ꂩ炪{̐킢I
	};
	
	public BrekaOrcOverlord(int questId, String name, String descr)
	{
		super(questId, name, descr);
//		addAttackId(BREKA_ORC_OVERLORD);
		addSpellFinishedId(BREKA_ORC_OVERLORD);
	}
	
//	@Override
//	public String onAttack (L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
//	{
//		if (npc.getCurrentHp() == npc.getMaxHp())
//			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), SAY1[Rnd.get(SAY1.length)]).addPcName(attacker));
//		else if (Rnd.get(20) == 0)
//			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), SAY2[Rnd.get(SAY2.length)]));
//		return null;
//	}
	
	@Override
	public String onSpellFinished(L2Npc npc, L2PcInstance player, L2Skill skill)
	{
		if (Rnd.get(100) > npc.getSkillChance())
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), SAY2[Rnd.get(SAY2.length)]));
		return null;
	}
	
	public static void main(String[] args)
	{
		new BrekaOrcOverlord(-1, "BrekaOrcOverlord", "ai");
	}
}
