/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.templates.StatsSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class L2SkillDrain
extends L2Skill {
    private static final Logger _logDamage = Logger.getLogger("damage");
    private float _absorbPart;
    private int _absorbAbs;

    public L2SkillDrain(StatsSet set) {
        super(set);
        this._absorbPart = set.getFloat("absorbPart", 0.0f);
        this._absorbAbs = set.getInteger("absorbAbs", 0);
    }

    @Override
    public void useSkill(L2Character activeChar, L2Object[] targets) {
        if (activeChar.isAlikeDead()) {
            return;
        }
        boolean ss = false;
        boolean bss = false;
        for (L2Character target : (L2Character[])targets) {
            if (target.isAlikeDead() && this.getTargetType() != L2Skill.SkillTargetType.TARGET_CORPSE_MOB || activeChar != target && target.isInvul()) continue;
            L2ItemInstance weaponInst = activeChar.getActiveWeaponInstance();
            if (weaponInst != null) {
                if (weaponInst.getChargedSpiritshot() == 2) {
                    bss = true;
                    weaponInst.setChargedSpiritshot(0);
                } else if (weaponInst.getChargedSpiritshot() == 1) {
                    ss = true;
                    weaponInst.setChargedSpiritshot(0);
                }
            } else if (activeChar instanceof L2Summon) {
                L2Summon activeSummon = (L2Summon)activeChar;
                if (activeSummon.getChargedSpiritShot() == 2) {
                    bss = true;
                    activeSummon.setChargedSpiritShot(0);
                } else if (activeSummon.getChargedSpiritShot() == 1) {
                    ss = true;
                    activeSummon.setChargedSpiritShot(0);
                }
            }
            boolean mcrit = Formulas.calcMCrit(activeChar.getMCriticalHit(target, this));
            byte shld = Formulas.calcShldUse(activeChar, target, this);
            int damage = (int)Formulas.calcMagicDam(activeChar, target, this, shld, ss, bss, mcrit);
            int _drain = 0;
            int _cp = (int)target.getCurrentCp();
            int _hp = (int)target.getCurrentHp();
            _drain = _cp > 0 ? (damage < _cp ? 0 : damage - _cp) : (damage > _hp ? _hp : damage);
            double hpAdd = (float)this._absorbAbs + this._absorbPart * (float)_drain;
            double hp = activeChar.getCurrentHp() + hpAdd > (double)activeChar.getMaxHp() ? (double)activeChar.getMaxHp() : activeChar.getCurrentHp() + hpAdd;
            activeChar.setCurrentHp(hp);
            StatusUpdate suhp = new StatusUpdate(activeChar);
            suhp.addAttribute(9, (int)hp);
            activeChar.sendPacket(suhp);
            if (!(damage <= 0 || target.isDead() && this.getTargetType() == L2Skill.SkillTargetType.TARGET_CORPSE_MOB)) {
                if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                    target.breakAttack();
                    target.breakCast();
                }
                activeChar.sendDamageMessage(target, damage, mcrit, false, false);
                if (Config.LOG_GAME_DAMAGE && activeChar instanceof L2Playable && damage > Config.LOG_GAME_DAMAGE_THRESHOLD) {
                    LogRecord record = new LogRecord(Level.INFO, "");
                    record.setParameters(new Object[]{activeChar, " did damage ", damage, this, " to ", target});
                    record.setLoggerName("mdam");
                    _logDamage.log(record);
                }
                if (this.hasEffects() && this.getTargetType() != L2Skill.SkillTargetType.TARGET_CORPSE_MOB) {
                    SystemMessage sm;
                    if ((Formulas.calcSkillReflect(target, this) & 1) > 0) {
                        activeChar.stopSkillEffects(this.getId());
                        this.getEffects(target, activeChar);
                        sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
                        sm.addSkillName(this.getId());
                        activeChar.sendPacket(sm);
                    } else {
                        target.stopSkillEffects(this.getId());
                        if (Formulas.calcSkillSuccess(activeChar, target, this, shld, false, ss, bss)) {
                            this.getEffects(activeChar, target);
                        } else {
                            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                            sm.addCharName(target);
                            sm.addSkillName(this);
                            activeChar.sendPacket(sm);
                        }
                    }
                }
                target.reduceCurrentHp(damage, activeChar, this);
            }
            if (!target.isDead() || this.getTargetType() != L2Skill.SkillTargetType.TARGET_CORPSE_MOB || !(target instanceof L2Npc)) continue;
            ((L2Npc)target).endDecayTask();
        }
        L2Effect effect = activeChar.getFirstEffect(this.getId());
        if (effect != null && effect.isSelfEffect()) {
            effect.exit();
        }
        this.getEffectsSelf(activeChar);
    }

    public void useCubicSkill(L2CubicInstance activeCubic, L2Object[] targets) {
        if (Config.DEBUG) {
            _log.info("L2SkillDrain: useCubicSkill()");
        }
        for (L2Character target : (L2Character[])targets) {
            if (target.isAlikeDead() && this.getTargetType() != L2Skill.SkillTargetType.TARGET_CORPSE_MOB) continue;
            boolean mcrit = Formulas.calcMCrit(activeCubic.getMCriticalHit(target, this));
            byte shld = Formulas.calcShldUse(activeCubic.getOwner(), target, this);
            int damage = (int)Formulas.calcMagicDam(activeCubic, target, this, mcrit, shld);
            if (Config.DEBUG) {
                _log.info("L2SkillDrain: useCubicSkill() -> damage = " + damage);
            }
            double hpAdd = (float)this._absorbAbs + this._absorbPart * (float)damage;
            L2PcInstance owner = activeCubic.getOwner();
            double hp = owner.getCurrentHp() + hpAdd > (double)owner.getMaxHp() ? (double)owner.getMaxHp() : owner.getCurrentHp() + hpAdd;
            owner.setCurrentHp(hp);
            StatusUpdate suhp = new StatusUpdate(owner);
            suhp.addAttribute(9, (int)hp);
            owner.sendPacket(suhp);
            if (damage <= 0 || target.isDead() && this.getTargetType() == L2Skill.SkillTargetType.TARGET_CORPSE_MOB) continue;
            target.reduceCurrentHp(damage, activeCubic.getOwner(), this);
            if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                target.breakAttack();
                target.breakCast();
            }
            owner.sendDamageMessage(target, damage, mcrit, false, false);
        }
    }
}

