/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectManaHealOverTime
extends L2Effect {
    public EffectManaHealOverTime(Env env, EffectTemplate template) {
        super(env, template);
    }

    public EffectManaHealOverTime(Env env, L2Effect effect) {
        super(env, effect);
    }

    @Override
    protected boolean effectCanBeStolen() {
        return true;
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.MANA_HEAL_OVER_TIME;
    }

    @Override
    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        double mp = this.getEffected().getCurrentMp();
        double maxmp = this.getEffected().getMaxMp();
        if ((mp += this.calc()) > maxmp) {
            mp = maxmp;
        }
        this.getEffected().setCurrentMp(mp);
        StatusUpdate sump = new StatusUpdate(this.getEffected());
        sump.addAttribute(11, (int)mp);
        this.getEffected().sendPacket(sump);
        return true;
    }
}

