/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.base.PlayerState;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.skills.conditions.ConditionChangeWeapon;
import com.l2jserver.gameserver.skills.conditions.ConditionForceBuff;
import com.l2jserver.gameserver.skills.conditions.ConditionGameChance;
import com.l2jserver.gameserver.skills.conditions.ConditionGameTime;
import com.l2jserver.gameserver.skills.conditions.ConditionLogicAnd;
import com.l2jserver.gameserver.skills.conditions.ConditionLogicNot;
import com.l2jserver.gameserver.skills.conditions.ConditionLogicOr;
import com.l2jserver.gameserver.skills.conditions.ConditionMinDistance;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerActiveEffectId;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerActiveSkillId;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerAgathionId;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerCharges;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerClassIdRestriction;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerCloakStatus;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerCp;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerFlyMounted;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerGrade;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerHasCastle;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerHasClanHall;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerHasFort;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerHasPet;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerHp;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerInstanceId;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerInvSize;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerIsClanLeader;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerIsHero;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerLandingZone;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerLevel;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerLevelRange;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerMp;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerPkCount;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerPledgeClass;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerRace;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerRangeFromNpc;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerServitorNpcId;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerSex;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerSiegeSide;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerSouls;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerState;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerSubclass;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerTvTEvent;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerWeight;
import com.l2jserver.gameserver.skills.conditions.ConditionSiegeZone;
import com.l2jserver.gameserver.skills.conditions.ConditionSkillStats;
import com.l2jserver.gameserver.skills.conditions.ConditionSlotItemId;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetAbnormal;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetActiveEffectId;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetActiveSkillId;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetAggro;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetClassIdRestriction;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetLevel;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetNpcId;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetNpcType;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetPlayable;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetRace;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetRaceId;
import com.l2jserver.gameserver.skills.conditions.ConditionTargetUsesWeaponKind;
import com.l2jserver.gameserver.skills.conditions.ConditionUsingItemType;
import com.l2jserver.gameserver.skills.conditions.ConditionUsingSkill;
import com.l2jserver.gameserver.skills.conditions.ConditionWithSkill;
import com.l2jserver.gameserver.skills.effects.EffectChanceSkillTrigger;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.skills.funcs.Lambda;
import com.l2jserver.gameserver.skills.funcs.LambdaCalc;
import com.l2jserver.gameserver.skills.funcs.LambdaConst;
import com.l2jserver.gameserver.skills.funcs.LambdaStats;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class DocumentBase {
    static Logger _log = Logger.getLogger(DocumentBase.class.getName());
    private File _file;
    protected Map<String, String[]> _tables;

    DocumentBase(File pFile) {
        this._file = pFile;
        this._tables = new FastMap();
    }

    Document parse() {
        Document doc;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            doc = factory.newDocumentBuilder().parse(this._file);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error loading file " + this._file, e);
            return null;
        }
        try {
            this.parseDocument(doc);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error in file " + this._file, e);
            return null;
        }
        return doc;
    }

    protected abstract void parseDocument(Document var1);

    protected abstract StatsSet getStatsSet();

    protected abstract String getTableValue(String var1);

    protected abstract String getTableValue(String var1, int var2);

    protected void resetTable() {
        this._tables = new FastMap();
    }

    protected void setTable(String name, String[] table) {
        this._tables.put(name, table);
    }

    protected void parseTemplate(Node n, Object template) {
        Condition condition = null;
        if ((n = n.getFirstChild()) == null) {
            return;
        }
        if ("cond".equalsIgnoreCase(n.getNodeName())) {
            condition = this.parseCondition(n.getFirstChild(), template);
            Node msg = n.getAttributes().getNamedItem("msg");
            Node msgId = n.getAttributes().getNamedItem("msgId");
            if (condition != null && msg != null) {
                condition.setMessage(msg.getNodeValue());
            } else if (condition != null && msgId != null) {
                condition.setMessageId(Integer.decode(this.getValue(msgId.getNodeValue(), null)));
                Node addName = n.getAttributes().getNamedItem("addName");
                if (addName != null && Integer.decode(this.getValue(msgId.getNodeValue(), null)) > 0) {
                    condition.addName();
                }
            }
            n = n.getNextSibling();
        }
        while (n != null) {
            if ("add".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Add", condition);
            } else if ("sub".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Sub", condition);
            } else if ("mul".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Mul", condition);
            } else if ("basemul".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "BaseMul", condition);
            } else if ("div".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Div", condition);
            } else if ("set".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Set", condition);
            } else if ("enchant".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "Enchant", condition);
            } else if ("enchanthp".equalsIgnoreCase(n.getNodeName())) {
                this.attachFunc(n, template, "EnchantHp", condition);
            } else if ("effect".equalsIgnoreCase(n.getNodeName())) {
                if (template instanceof EffectTemplate) {
                    throw new RuntimeException("Nested effects");
                }
                this.attachEffect(n, template, condition);
            }
            n = n.getNextSibling();
        }
    }

    protected void attachFunc(Node n, Object template, String name, Condition attachCond) {
        Stats stat = Stats.valueOfXml(n.getAttributes().getNamedItem("stat").getNodeValue());
        String order = n.getAttributes().getNamedItem("order").getNodeValue();
        Lambda lambda = this.getLambda(n, template);
        int ord = Integer.decode(this.getValue(order, template));
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        FuncTemplate ft = new FuncTemplate(attachCond, applayCond, name, stat, ord, lambda);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(ft);
        } else if (template instanceof L2Skill) {
            ((L2Skill)template).attach(ft);
        } else if (template instanceof EffectTemplate) {
            ((EffectTemplate)template).attach(ft);
        }
    }

    protected void attachLambdaFunc(Node n, Object template, LambdaCalc calc) {
        String name = n.getNodeName();
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        name = sb.toString();
        Lambda lambda = this.getLambda(n, template);
        FuncTemplate ft = new FuncTemplate(null, null, name, null, calc.funcs.length, lambda);
        calc.addFunc(ft.getFunc(new Env(), calc));
    }

    protected void attachEffect(Node n, Object template, Condition attachCond) {
        ChanceCondition chance;
        NamedNodeMap attrs = n.getAttributes();
        String name = this.getValue(attrs.getNamedItem("name").getNodeValue().intern(), template);
        int abnormalTime = 1;
        int count = 1;
        if (attrs.getNamedItem("count") != null) {
            count = Integer.decode(this.getValue(attrs.getNamedItem("count").getNodeValue(), template));
        }
        if (attrs.getNamedItem("abnormalTime") != null) {
            abnormalTime = Integer.decode(this.getValue(attrs.getNamedItem("abnormalTime").getNodeValue(), template));
            if (Config.ENABLE_MODIFY_SKILL_DURATION && Config.SKILL_DURATION_LIST.containsKey(((L2Skill)template).getId())) {
                if (((L2Skill)template).getLevel() < 100) {
                    abnormalTime = Config.SKILL_DURATION_LIST.get(((L2Skill)template).getId());
                } else if (((L2Skill)template).getLevel() >= 100 && ((L2Skill)template).getLevel() < 140) {
                    abnormalTime += Config.SKILL_DURATION_LIST.get(((L2Skill)template).getId());
                } else if (((L2Skill)template).getLevel() > 140) {
                    abnormalTime = Config.SKILL_DURATION_LIST.get(((L2Skill)template).getId());
                }
                if (Config.DEBUG) {
                    _log.info("*** Skill " + ((L2Skill)template).getName() + " (" + ((L2Skill)template).getLevel() + ") changed duration to " + abnormalTime + " seconds.");
                }
            }
        } else if (((L2Skill)template).getBuffDuration() > 0) {
            abnormalTime = ((L2Skill)template).getBuffDuration() / 1000 / count;
        }
        boolean self = false;
        if (attrs.getNamedItem("self") != null && Integer.decode(this.getValue(attrs.getNamedItem("self").getNodeValue(), template)) == 1) {
            self = true;
        }
        boolean icon = true;
        if (attrs.getNamedItem("noicon") != null && Integer.decode(this.getValue(attrs.getNamedItem("noicon").getNodeValue(), template)) == 1) {
            icon = false;
        }
        Lambda lambda = this.getLambda(n, template);
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        AbnormalEffect abnormal = AbnormalEffect.NULL;
        if (attrs.getNamedItem("abnormal") != null) {
            String abn = attrs.getNamedItem("abnormal").getNodeValue();
            abnormal = AbnormalEffect.getByName(abn);
        }
        AbnormalEffect special = AbnormalEffect.NULL;
        if (attrs.getNamedItem("special") != null) {
            String spc = attrs.getNamedItem("special").getNodeValue();
            special = AbnormalEffect.getByName(spc);
        }
        AbnormalEffect event = AbnormalEffect.NULL;
        if (attrs.getNamedItem("event") != null) {
            String spc = attrs.getNamedItem("event").getNodeValue();
            event = AbnormalEffect.getByName(spc);
        }
        byte abnormalLvl = 0;
        String abnormalType = "none";
        if (attrs.getNamedItem("abnormalType") != null) {
            abnormalType = attrs.getNamedItem("abnormalType").getNodeValue();
        }
        if (attrs.getNamedItem("abnormalLvl") != null) {
            abnormalLvl = Byte.parseByte(this.getValue(attrs.getNamedItem("abnormalLvl").getNodeValue(), template));
        }
        double effectPower = -1.0;
        if (attrs.getNamedItem("effectPower") != null) {
            effectPower = Double.parseDouble(this.getValue(attrs.getNamedItem("effectPower").getNodeValue(), template));
        }
        L2SkillType type = null;
        if (attrs.getNamedItem("effectType") != null) {
            String typeName = this.getValue(attrs.getNamedItem("effectType").getNodeValue(), template);
            try {
                type = Enum.valueOf(L2SkillType.class, typeName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Not skilltype found for: " + typeName);
            }
        }
        boolean isChanceSkillTrigger = name == EffectChanceSkillTrigger.class.getName();
        int trigId = 0;
        if (attrs.getNamedItem("triggeredId") != null) {
            trigId = Integer.parseInt(this.getValue(attrs.getNamedItem("triggeredId").getNodeValue(), template));
        } else if (isChanceSkillTrigger) {
            throw new NoSuchElementException(name + " requires triggerId");
        }
        int trigLvl = 1;
        if (attrs.getNamedItem("triggeredLevel") != null) {
            trigLvl = Integer.parseInt(this.getValue(attrs.getNamedItem("triggeredLevel").getNodeValue(), template));
        }
        String chanceCond = null;
        if (attrs.getNamedItem("chanceType") != null) {
            chanceCond = this.getValue(attrs.getNamedItem("chanceType").getNodeValue(), template);
        } else if (isChanceSkillTrigger) {
            throw new NoSuchElementException(name + " requires chanceType");
        }
        int activationChance = -1;
        if (attrs.getNamedItem("activationChance") != null) {
            activationChance = Integer.parseInt(this.getValue(attrs.getNamedItem("activationChance").getNodeValue(), template));
        }
        int activationMinDamage = -1;
        if (attrs.getNamedItem("activationMinDamage") != null) {
            activationMinDamage = Integer.parseInt(this.getValue(attrs.getNamedItem("activationMinDamage").getNodeValue(), template));
        }
        String activationElements = null;
        if (attrs.getNamedItem("activationElements") != null) {
            activationElements = this.getValue(attrs.getNamedItem("activationElements").getNodeValue(), template);
        }
        String activationSkills = null;
        if (attrs.getNamedItem("activationSkills") != null) {
            activationSkills = this.getValue(attrs.getNamedItem("activationSkills").getNodeValue(), template);
        }
        boolean pvpOnly = false;
        if (attrs.getNamedItem("pvpChanceOnly") != null) {
            pvpOnly = Boolean.parseBoolean(this.getValue(attrs.getNamedItem("pvpChanceOnly").getNodeValue(), template));
        }
        if ((chance = ChanceCondition.parse(chanceCond, activationChance, activationMinDamage, activationElements, activationSkills, pvpOnly)) == null && isChanceSkillTrigger) {
            throw new NoSuchElementException("Invalid chance condition: " + chanceCond + " " + activationChance);
        }
        EffectTemplate lt = new EffectTemplate(attachCond, applayCond, name, lambda, count, abnormalTime, abnormal, special, event, abnormalType, abnormalLvl, icon, effectPower, type, trigId, trigLvl, chance);
        this.parseTemplate(n, lt);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(lt);
        } else if (template instanceof L2Skill) {
            if (self) {
                ((L2Skill)template).attachSelf(lt);
            } else {
                ((L2Skill)template).attach(lt);
            }
        }
    }

    protected Condition parseCondition(Node n, Object template) {
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        if (n == null) {
            return null;
        }
        if ("and".equalsIgnoreCase(n.getNodeName())) {
            return this.parseLogicAnd(n, template);
        }
        if ("or".equalsIgnoreCase(n.getNodeName())) {
            return this.parseLogicOr(n, template);
        }
        if ("not".equalsIgnoreCase(n.getNodeName())) {
            return this.parseLogicNot(n, template);
        }
        if ("player".equalsIgnoreCase(n.getNodeName())) {
            return this.parsePlayerCondition(n, template);
        }
        if ("target".equalsIgnoreCase(n.getNodeName())) {
            return this.parseTargetCondition(n, template);
        }
        if ("skill".equalsIgnoreCase(n.getNodeName())) {
            return this.parseSkillCondition(n);
        }
        if ("using".equalsIgnoreCase(n.getNodeName())) {
            return this.parseUsingCondition(n);
        }
        if ("game".equalsIgnoreCase(n.getNodeName())) {
            return this.parseGameCondition(n);
        }
        return null;
    }

    protected Condition parseLogicAnd(Node n, Object template) {
        ConditionLogicAnd cond = new ConditionLogicAnd();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond.conditions == null || cond.conditions.length == 0) {
            _log.severe("Empty <and> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseLogicOr(Node n, Object template) {
        ConditionLogicOr cond = new ConditionLogicOr();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond.conditions == null || cond.conditions.length == 0) {
            _log.severe("Empty <or> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseLogicNot(Node n, Object template) {
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return new ConditionLogicNot(this.parseCondition(n, template));
        }
        _log.severe("Empty <not> condition in " + this._file);
        return null;
    }

    protected Condition parsePlayerCondition(Node n, Object template) {
        Condition cond = null;
        byte[] forces = new byte[2];
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("races".equalsIgnoreCase(a.getNodeName())) {
                String[] racesVal = a.getNodeValue().split(",");
                Race[] races = new Race[racesVal.length];
                for (int r = 0; r < racesVal.length; ++r) {
                    if (racesVal[r] == null) continue;
                    races[r] = Race.valueOf(racesVal[r]);
                }
                cond = this.joinAnd(cond, new ConditionPlayerRace(races));
                continue;
            }
            if ("level".equalsIgnoreCase(a.getNodeName())) {
                int lvl = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerLevel(lvl));
                continue;
            }
            if ("levelRange".equalsIgnoreCase(a.getNodeName())) {
                String[] range = this.getValue(a.getNodeValue(), template).split(";");
                if (range.length != 2) continue;
                int[] lvlRange = new int[]{Integer.decode(this.getValue(a.getNodeValue(), template).split(";")[0]), Integer.decode(this.getValue(a.getNodeValue(), template).split(";")[1])};
                cond = this.joinAnd(cond, new ConditionPlayerLevelRange(lvlRange));
                continue;
            }
            if ("resting".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.RESTING, val));
                continue;
            }
            if ("flying".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.FLYING, val));
                continue;
            }
            if ("moving".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.MOVING, val));
                continue;
            }
            if ("running".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.RUNNING, val));
                continue;
            }
            if ("standing".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.STANDING, val));
                continue;
            }
            if ("behind".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.BEHIND, val));
                continue;
            }
            if ("front".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.FRONT, val));
                continue;
            }
            if ("chaotic".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.CHAOTIC, val));
                continue;
            }
            if ("olympiad".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.OLYMPIAD, val));
                continue;
            }
            if ("ishero".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerIsHero(val));
                continue;
            }
            if ("hp".equalsIgnoreCase(a.getNodeName())) {
                int hp = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerHp(hp));
                continue;
            }
            if ("mp".equalsIgnoreCase(a.getNodeName())) {
                int hp = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerMp(hp));
                continue;
            }
            if ("cp".equalsIgnoreCase(a.getNodeName())) {
                int cp = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerCp(cp));
                continue;
            }
            if ("grade".equalsIgnoreCase(a.getNodeName())) {
                int expIndex = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerGrade(expIndex));
                continue;
            }
            if ("pkCount".equalsIgnoreCase(a.getNodeName())) {
                int expIndex = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerPkCount(expIndex));
                continue;
            }
            if ("siegezone".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionSiegeZone(value, true));
                continue;
            }
            if ("siegeside".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerSiegeSide(value));
                continue;
            }
            if ("battle_force".equalsIgnoreCase(a.getNodeName())) {
                forces[0] = Byte.decode(this.getValue(a.getNodeValue(), null));
                continue;
            }
            if ("spell_force".equalsIgnoreCase(a.getNodeName())) {
                forces[1] = Byte.decode(this.getValue(a.getNodeValue(), null));
                continue;
            }
            if ("charges".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerCharges(value));
                continue;
            }
            if ("souls".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerSouls(value));
                continue;
            }
            if ("weight".equalsIgnoreCase(a.getNodeName())) {
                int weight = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerWeight(weight));
                continue;
            }
            if ("invSize".equalsIgnoreCase(a.getNodeName())) {
                int size = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerInvSize(size));
                continue;
            }
            if ("isClanLeader".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerIsClanLeader(val));
                continue;
            }
            if ("onTvTEvent".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerTvTEvent(val));
                continue;
            }
            if ("pledgeClass".equalsIgnoreCase(a.getNodeName())) {
                int pledgeClass = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerPledgeClass(pledgeClass));
                continue;
            }
            if ("clanHall".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerHasClanHall(array));
                continue;
            }
            if ("fort".equalsIgnoreCase(a.getNodeName())) {
                int fort = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerHasFort(fort));
                continue;
            }
            if ("castle".equalsIgnoreCase(a.getNodeName())) {
                int castle = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerHasCastle(castle));
                continue;
            }
            if ("sex".equalsIgnoreCase(a.getNodeName())) {
                int sex = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionPlayerSex(sex));
                continue;
            }
            if ("flyMounted".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerFlyMounted(val));
                continue;
            }
            if ("landingZone".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerLandingZone(val));
                continue;
            }
            if ("active_effect_id".equalsIgnoreCase(a.getNodeName())) {
                int effect_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveEffectId(effect_id));
                continue;
            }
            if ("active_effect_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int effect_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int effect_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveEffectId(effect_id, effect_lvl));
                continue;
            }
            if ("active_skill_id".equalsIgnoreCase(a.getNodeName())) {
                int skill_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveSkillId(skill_id));
                continue;
            }
            if ("active_skill_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int skill_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int skill_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionPlayerActiveSkillId(skill_id, skill_lvl));
                continue;
            }
            if ("class_id_restriction".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerClassIdRestriction(array));
                continue;
            }
            if ("subclass".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerSubclass(val));
                continue;
            }
            if ("instanceId".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerInstanceId(array));
                continue;
            }
            if ("agathionId".equalsIgnoreCase(a.getNodeName())) {
                int agathionId = Integer.decode(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerAgathionId(agathionId));
                continue;
            }
            if ("cloakStatus".equalsIgnoreCase(a.getNodeName())) {
                int val = Integer.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionPlayerCloakStatus(val));
                continue;
            }
            if ("hasPet".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerHasPet(array));
                continue;
            }
            if ("servitorNpcId".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionPlayerServitorNpcId(array));
                continue;
            }
            if (!"npcIdRadius".equalsIgnoreCase(a.getNodeName())) continue;
            StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
            int npcId = 0;
            int radius = 0;
            if (st.countTokens() > 1) {
                npcId = Integer.decode(this.getValue(st.nextToken().trim(), null));
                radius = Integer.decode(this.getValue(st.nextToken().trim(), null));
            }
            cond = this.joinAnd(cond, new ConditionPlayerRangeFromNpc(npcId, radius));
        }
        if (forces[0] + forces[1] > 0) {
            cond = this.joinAnd(cond, new ConditionForceBuff(forces));
        }
        if (cond == null) {
            _log.severe("Unrecognized <player> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseTargetCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            ArrayList<Integer> array;
            Node a = attrs.item(i);
            if ("aggro".equalsIgnoreCase(a.getNodeName())) {
                boolean val = Boolean.valueOf(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionTargetAggro(val));
                continue;
            }
            if ("siegezone".equalsIgnoreCase(a.getNodeName())) {
                int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionSiegeZone(value, false));
                continue;
            }
            if ("level".equalsIgnoreCase(a.getNodeName())) {
                int lvl = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetLevel(lvl));
                continue;
            }
            if ("playable".equalsIgnoreCase(a.getNodeName())) {
                cond = this.joinAnd(cond, new ConditionTargetPlayable());
                continue;
            }
            if ("class_id_restriction".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                array = new ArrayList<Integer>(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionTargetClassIdRestriction(array));
                continue;
            }
            if ("active_effect_id".equalsIgnoreCase(a.getNodeName())) {
                int effect_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetActiveEffectId(effect_id));
                continue;
            }
            if ("active_effect_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int effect_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int effect_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionTargetActiveEffectId(effect_id, effect_lvl));
                continue;
            }
            if ("active_skill_id".equalsIgnoreCase(a.getNodeName())) {
                int skill_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetActiveSkillId(skill_id));
                continue;
            }
            if ("active_skill_id_lvl".equalsIgnoreCase(a.getNodeName())) {
                String val = this.getValue(a.getNodeValue(), template);
                int skill_id = Integer.decode(this.getValue(val.split(",")[0], template));
                int skill_lvl = Integer.decode(this.getValue(val.split(",")[1], template));
                cond = this.joinAnd(cond, new ConditionTargetActiveSkillId(skill_id, skill_lvl));
                continue;
            }
            if ("abnormal".equalsIgnoreCase(a.getNodeName())) {
                int abnormalId = Integer.decode(this.getValue(a.getNodeValue(), template));
                cond = this.joinAnd(cond, new ConditionTargetAbnormal(abnormalId));
                continue;
            }
            if ("mindistance".equalsIgnoreCase(a.getNodeName())) {
                int distance = Integer.decode(this.getValue(a.getNodeValue(), null));
                cond = this.joinAnd(cond, new ConditionMinDistance(distance * distance));
                continue;
            }
            if ("race_id".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                array = new ArrayList(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionTargetRaceId(array));
                continue;
            }
            if ("races".equalsIgnoreCase(a.getNodeName())) {
                String[] racesVal = a.getNodeValue().split(",");
                Race[] races = new Race[racesVal.length];
                for (int r = 0; r < racesVal.length; ++r) {
                    if (racesVal[r] == null) continue;
                    races[r] = Race.valueOf(racesVal[r]);
                }
                cond = this.joinAnd(cond, new ConditionTargetRace(races));
                continue;
            }
            if ("using".equalsIgnoreCase(a.getNodeName())) {
                int mask = 0;
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                block4: while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    for (L2WeaponType l2WeaponType : L2WeaponType.values()) {
                        if (!l2WeaponType.toString().equals(item)) continue;
                        mask |= l2WeaponType.mask();
                        break;
                    }
                    for (Enum enum_ : L2ArmorType.values()) {
                        if (!((L2ArmorType)enum_).toString().equals(item)) continue;
                        mask |= ((L2ArmorType)enum_).mask();
                        continue block4;
                    }
                }
                cond = this.joinAnd(cond, new ConditionTargetUsesWeaponKind(mask));
                continue;
            }
            if ("npcId".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                array = new ArrayList(st.countTokens());
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    array.add(Integer.decode(this.getValue(item, null)));
                }
                cond = this.joinAnd(cond, new ConditionTargetNpcId(array));
                continue;
            }
            if (!"npcType".equalsIgnoreCase(a.getNodeName())) continue;
            String values = this.getValue(a.getNodeValue(), template).trim();
            String[] valuesSplit = values.split(",");
            L2Object.InstanceType[] types = new L2Object.InstanceType[valuesSplit.length];
            for (int j = 0; j < valuesSplit.length; ++j) {
                L2Object.InstanceType type = Enum.valueOf(L2Object.InstanceType.class, valuesSplit[j]);
                if (type == null) {
                    throw new IllegalArgumentException("Instance type not recognized: " + valuesSplit[j]);
                }
                types[j] = type;
            }
            cond = this.joinAnd(cond, new ConditionTargetNpcType(types));
        }
        if (cond == null) {
            _log.severe("Unrecognized <target> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseSkillCondition(Node n) {
        NamedNodeMap attrs = n.getAttributes();
        Stats stat = Stats.valueOfXml(attrs.getNamedItem("stat").getNodeValue());
        return new ConditionSkillStats(stat);
    }

    protected Condition parseUsingCondition(Node n) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            if ("kind".equalsIgnoreCase(a.getNodeName())) {
                int mask = 0;
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                while (st.hasMoreTokens()) {
                    int old = mask;
                    String item = st.nextToken().trim();
                    if (ItemTable._weaponTypes.containsKey(item)) {
                        mask |= ItemTable._weaponTypes.get(item).mask();
                    }
                    if (ItemTable._armorTypes.containsKey(item)) {
                        mask |= ItemTable._armorTypes.get(item).mask();
                    }
                    if (old != mask) continue;
                    _log.info("[parseUsingCondition=\"kind\"] Unknown item type name: " + item);
                }
                cond = this.joinAnd(cond, new ConditionUsingItemType(mask));
                continue;
            }
            if ("skill".equalsIgnoreCase(a.getNodeName())) {
                int id = Integer.parseInt(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionUsingSkill(id));
                continue;
            }
            if ("slotitem".equalsIgnoreCase(a.getNodeName())) {
                StringTokenizer st = new StringTokenizer(a.getNodeValue(), ";");
                int id = Integer.parseInt(st.nextToken().trim());
                int slot = Integer.parseInt(st.nextToken().trim());
                int enchant = 0;
                if (st.hasMoreTokens()) {
                    enchant = Integer.parseInt(st.nextToken().trim());
                }
                cond = this.joinAnd(cond, new ConditionSlotItemId(slot, id, enchant));
                continue;
            }
            if (!"weaponChange".equalsIgnoreCase(a.getNodeName())) continue;
            boolean val = Boolean.valueOf(a.getNodeValue());
            cond = this.joinAnd(cond, new ConditionChangeWeapon(val));
        }
        if (cond == null) {
            _log.severe("Unrecognized <using> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseGameCondition(Node n) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            int val;
            Node a = attrs.item(i);
            if ("skill".equalsIgnoreCase(a.getNodeName())) {
                val = Boolean.valueOf(a.getNodeValue()).booleanValue();
                cond = this.joinAnd(cond, new ConditionWithSkill(val != 0));
            }
            if ("night".equalsIgnoreCase(a.getNodeName())) {
                val = Boolean.valueOf(a.getNodeValue()).booleanValue();
                cond = this.joinAnd(cond, new ConditionGameTime(ConditionGameTime.CheckGameTime.NIGHT, val != 0));
            }
            if (!"chance".equalsIgnoreCase(a.getNodeName())) continue;
            val = Integer.decode(this.getValue(a.getNodeValue(), null));
            cond = this.joinAnd(cond, new ConditionGameChance(val));
        }
        if (cond == null) {
            _log.severe("Unrecognized <game> condition in " + this._file);
        }
        return cond;
    }

    protected void parseTable(Node n) {
        NamedNodeMap attrs = n.getAttributes();
        String name = attrs.getNamedItem("name").getNodeValue();
        if (name.charAt(0) != '#') {
            throw new IllegalArgumentException("Table name must start with #");
        }
        StringTokenizer data = new StringTokenizer(n.getFirstChild().getNodeValue());
        ArrayList<String> array = new ArrayList<String>(data.countTokens());
        while (data.hasMoreTokens()) {
            array.add(StringIntern.intern(data.nextToken()));
        }
        this.setTable(name, array.toArray(new String[array.size()]));
    }

    protected void parseBeanSet(Node n, StatsSet set, Integer level) {
        char ch;
        String name = n.getAttributes().getNamedItem("name").getNodeValue().trim();
        String value = n.getAttributes().getNamedItem("val").getNodeValue().trim();
        char c = ch = value.length() == 0 ? (char)' ' : (char)value.charAt(0);
        if (ch == '#' || ch == '-' || Character.isDigit(ch)) {
            set.set(name, String.valueOf(this.getValue(value, level)));
        } else {
            set.set(name, value);
        }
    }

    protected void setExtractableSkillData(StatsSet set, String value) {
        set.set("capsuled_items_skill", value);
    }

    protected Lambda getLambda(Node n, Object template) {
        Node nval = n.getAttributes().getNamedItem("val");
        if (nval != null) {
            String val = nval.getNodeValue();
            if (val.charAt(0) == '#') {
                return new LambdaConst(Double.parseDouble(this.getTableValue(val)));
            }
            if (val.charAt(0) == '$') {
                if (val.equalsIgnoreCase("$player_level")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_LEVEL);
                }
                if (val.equalsIgnoreCase("$target_level")) {
                    return new LambdaStats(LambdaStats.StatsType.TARGET_LEVEL);
                }
                if (val.equalsIgnoreCase("$player_max_hp")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_MAX_HP);
                }
                if (val.equalsIgnoreCase("$player_max_mp")) {
                    return new LambdaStats(LambdaStats.StatsType.PLAYER_MAX_MP);
                }
                StatsSet set = this.getStatsSet();
                String field = set.getString(val.substring(1));
                if (field != null) {
                    return new LambdaConst(Double.parseDouble(this.getValue(field, template)));
                }
                throw new IllegalArgumentException("Unknown value " + val);
            }
            return new LambdaConst(Double.parseDouble(val));
        }
        LambdaCalc calc = new LambdaCalc();
        for (n = n.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        if (n == null || !"val".equals(n.getNodeName())) {
            throw new IllegalArgumentException("Value not specified");
        }
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.attachLambdaFunc(n, template, calc);
        }
        return calc;
    }

    protected String getValue(String value, Object template) {
        if (value.charAt(0) == '#') {
            if (template instanceof L2Skill) {
                return this.getTableValue(value);
            }
            if (template instanceof Integer) {
                return this.getTableValue(value, (Integer)template);
            }
            throw new IllegalStateException();
        }
        return value;
    }

    protected Condition joinAnd(Condition cond, Condition c) {
        if (cond == null) {
            return c;
        }
        if (cond instanceof ConditionLogicAnd) {
            ((ConditionLogicAnd)cond).add(c);
            return cond;
        }
        ConditionLogicAnd and = new ConditionLogicAnd();
        and.add(cond);
        and.add(c);
        return and;
    }
}

