/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Calendar;
import java.util.logging.Logger;

public class SiegeInfo
extends L2GameServerPacket {
    private static final String _S__C9_SIEGEINFO = "[S] c9 SiegeInfo";
    private static Logger _log = Logger.getLogger(SiegeInfo.class.getName());
    private Castle _castle;

    public SiegeInfo(Castle castle) {
        this._castle = castle;
    }

    @Override
    protected final void writeImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        this.writeC(201);
        this.writeD(this._castle.getCastleId());
        this.writeD(this._castle.getOwnerId() == activeChar.getClanId() && activeChar.isClanLeader() ? 1 : 0);
        this.writeD(this._castle.getOwnerId());
        if (this._castle.getOwnerId() > 0) {
            L2Clan owner = ClanTable.getInstance().getClan(this._castle.getOwnerId());
            if (owner != null) {
                this.writeS(owner.getName());
                this.writeS(owner.getLeaderName());
                this.writeD(owner.getAllyId());
                this.writeS(owner.getAllyName());
            } else {
                _log.warning("Null owner for castle: " + this._castle.getName());
            }
        } else {
            this.writeS("");
            this.writeS("");
            this.writeD(0);
            this.writeS("");
        }
        this.writeD((int)(Calendar.getInstance().getTimeInMillis() / 1000L));
        this.writeD((int)(this._castle.getSiege().getSiegeDate().getTimeInMillis() / 1000L));
        this.writeD(0);
    }

    @Override
    public String getType() {
        return _S__C9_SIEGEINFO;
    }
}

