/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2ManufactureList;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class RecipeShopManageList
extends L2GameServerPacket {
    private static final String _S__D8_RecipeShopManageList = "[S] de RecipeShopManageList";
    private L2PcInstance _seller;
    private boolean _isDwarven;
    private L2RecipeList[] _recipes;

    public RecipeShopManageList(L2PcInstance seller, boolean isDwarven) {
        this._seller = seller;
        this._isDwarven = isDwarven;
        this._recipes = this._isDwarven && this._seller.hasDwarvenCraft() ? this._seller.getDwarvenRecipeBook() : this._seller.getCommonRecipeBook();
        if (this._seller.getCreateList() != null) {
            L2ManufactureList list = this._seller.getCreateList();
            for (L2ManufactureItem item : list.getList()) {
                if (item.isDwarven() == this._isDwarven && seller.hasRecipeList(item.getRecipeId())) continue;
                list.getList().remove(item);
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(222);
        this.writeD(this._seller.getObjectId());
        this.writeD((int)this._seller.getAdena());
        this.writeD(this._isDwarven ? 0 : 1);
        if (this._recipes == null) {
            this.writeD(0);
        } else {
            this.writeD(this._recipes.length);
            for (int i = 0; i < this._recipes.length; ++i) {
                L2RecipeList temp = this._recipes[i];
                this.writeD(temp.getId());
                this.writeD(i + 1);
            }
        }
        if (this._seller.getCreateList() == null) {
            this.writeD(0);
        } else {
            L2ManufactureList list = this._seller.getCreateList();
            this.writeD(list.size());
            for (L2ManufactureItem item : list.getList()) {
                this.writeD(item.getRecipeId());
                this.writeD(0);
                this.writeQ(item.getCost());
            }
        }
    }

    @Override
    public String getType() {
        return _S__D8_RecipeShopManageList;
    }
}

